/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

class ConvertNamespaceQuickFix
implements LintIdeQuickFix {
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        if (tag == null) {
            return;
        }
        for (XmlAttribute attribute : tag.getAttributes()) {
            String uri;
            if (!attribute.getName().startsWith("xmlns") || (uri = attribute.getValue()) == null || uri.isEmpty() || !uri.startsWith("http://schemas.android.com/apk/res/") || uri.equals("http://schemas.android.com/apk/res/android")) continue;
            attribute.setValue("http://schemas.android.com/apk/res-auto");
        }
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class) != null;
    }

    @NotNull
    public String getName() {
        return AndroidBundle.message("android.lint.fix.replace.namespace", new Object[0]);
    }
}

