/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.lint.RemoveSdkCheckFix;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;

public class AndroidLintObsoleteSdkIntInspection
extends AndroidLintInspectionBase {
    public AndroidLintObsoleteSdkIntInspection() {
        super(AndroidBundle.message("android.lint.inspections.obsolete.sdk.int", new Object[0]), ApiDetector.OBSOLETE_SDK);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2, @Nullable LintFix fixData) {
        if (fixData instanceof LintFix.DataMap) {
            LintFix.DataMap map2 = (LintFix.DataMap)fixData;
            Boolean constant = (Boolean)map2.get(Boolean.class);
            if (constant != null) {
                PsiBinaryExpression subExpression = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiBinaryExpression.class, (boolean)false);
                if (subExpression != null) {
                    return new LintIdeQuickFix[]{new LintIdeQuickFix.LocalFixWrappee((LocalQuickFixOnPsiElement)new SimplifyBooleanExpressionFix((PsiExpression)subExpression, constant.booleanValue()))};
                }
                if (startElement.getLanguage() == KotlinLanguage.INSTANCE) {
                    return new LintIdeQuickFix[]{new RemoveSdkCheckFix(constant)};
                }
            } else {
                File file2 = (File)map2.get(File.class);
                AndroidVersion minSdkVersion2 = (AndroidVersion)map2.get(AndroidVersion.class);
                String destFolder = (String)map2.get(String.class);
                if (file2 != null && destFolder != null && minSdkVersion2 != null) {
                    AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)startElement);
                    VirtualFile dir = StandardFileSystems.local().findFileByPath(file2.getPath());
                    if (facet2 != null && dir != null) {
                        return new LintIdeQuickFix[]{new MergeResourceFolderFix(facet2, dir, destFolder, minSdkVersion2)};
                    }
                }
            }
        }
        return super.getQuickFixes(startElement, endElement, message2, fixData);
    }

    private static class MergeResourceFolderFix
    implements LintIdeQuickFix {
        private final AndroidFacet facet;
        private final VirtualFile dir;
        private final String destFolderName;
        private final AndroidVersion minSdkVersion;
        List<VirtualFile> sourceFolders;

        MergeResourceFolderFix(@NotNull AndroidFacet facet2, @NotNull VirtualFile dir, @NotNull String destFolderName, AndroidVersion minSdkVersion2) {
            this.facet = facet2;
            this.dir = dir;
            this.destFolderName = destFolderName;
            this.minSdkVersion = minSdkVersion2;
        }

        private List<VirtualFile> findSourceFolders() {
            if (this.sourceFolders == null) {
                ArrayList folders = Lists.newArrayList();
                int apiLevel = this.minSdkVersion.getFeatureLevel();
                String dirName = this.dir.getName();
                FolderConfiguration oldConfig = FolderConfiguration.getConfigForFolder((String)dirName);
                assert (oldConfig != null);
                assert (oldConfig.getVersionQualifier() != null);
                int startingVersion = oldConfig.getVersionQualifier().getVersion();
                oldConfig.setVersionQualifier(null);
                ResourceFolderType folderType = ResourceFolderType.getFolderType((String)dirName);
                for (VirtualFile folder : this.dir.getParent().getChildren()) {
                    VersionQualifier versionQualifier;
                    FolderConfiguration siblingConfig;
                    if (!folder.isDirectory() || folderType != ResourceFolderType.getFolderType((String)folder.getName()) || (siblingConfig = FolderConfiguration.getConfigForFolder((String)folder.getName())) == null || (versionQualifier = siblingConfig.getVersionQualifier()) == null || versionQualifier.hasFakeValue() || versionQualifier.getVersion() > apiLevel || versionQualifier.getVersion() < startingVersion) continue;
                    siblingConfig.setVersionQualifier(null);
                    if (!siblingConfig.equals((Object)oldConfig)) continue;
                    folders.add(folder);
                }
                Collections.sort(folders, (f1, f2) -> {
                    FolderConfiguration configuration1 = FolderConfiguration.getConfigForFolder((String)f1.getName());
                    FolderConfiguration configuration2 = FolderConfiguration.getConfigForFolder((String)f2.getName());
                    assert (configuration1 != null);
                    assert (configuration2 != null);
                    return -configuration1.compareTo(configuration2);
                });
                this.sourceFolders = folders;
            }
            return this.sourceFolders;
        }

        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            ResourceFolderRepository repository = ResourceFolderRegistry.getInstance(this.facet.getModule().getProject()).get(this.facet, this.dir.getParent());
            Project project = this.facet.getModule().getProject();
            List<VirtualFile> folders = this.findSourceFolders();
            if (!folders.isEmpty()) {
                for (int i2 = 0; i2 < folders.size() - 1; ++i2) {
                    VirtualFile folder = folders.get(i2);
                    VirtualFile target = folders.get(i2 + 1);
                    MergeResourceFolderFix.mergeResourceFolder(project, folder, target.getName(), repository);
                }
                MergeResourceFolderFix.mergeResourceFolder(project, folders.get(folders.size() - 1), this.destFolderName, repository);
            }
        }

        private static void mergeResourceFolder(@NotNull Project project, @NotNull VirtualFile dir, @NotNull String targetDir, @NotNull LocalResourceRepository repository) {
            Class<AndroidLintInspectionBase> requestor = AndroidLintInspectionBase.class;
            FolderConfiguration oldConfig = FolderConfiguration.getConfigForFolder((String)dir.getName());
            FolderConfiguration newConfig = FolderConfiguration.getConfigForFolder((String)targetDir);
            assert (oldConfig != null);
            assert (newConfig != null);
            ArrayListMultimap destFolderResources = ArrayListMultimap.create((int)100, (int)2);
            ArrayList<ResourceItem> srcItems = new ArrayList<ResourceItem>();
            for (ResourceItem item : repository.getAllResources()) {
                FolderConfiguration configuration = item.getConfiguration();
                if (oldConfig.equals((Object)configuration)) {
                    VirtualFile sourceFile = IdeResourcesUtil.getSourceAsVirtualFile(item);
                    if (sourceFile == null || !dir.equals(sourceFile.getParent())) continue;
                    srcItems.add(item);
                    continue;
                }
                if (!newConfig.equals((Object)configuration)) continue;
                destFolderResources.put((Object)item.getName(), (Object)item.getType());
            }
            VirtualFile res = dir.getParent();
            if (res == null) {
                return;
            }
            try {
                VirtualFile destDir = res.findOrCreateChildData(requestor, targetDir);
                for (ResourceItem item : srcItems) {
                    PathString source = item.getSource();
                    if (source == null) continue;
                    String dirName = source.getParentFileName();
                    if (dirName != null && dirName.startsWith("values")) {
                        String textValue = null;
                        ResourceValue resourceValue2 = item.getResourceValue();
                        if (resourceValue2 != null) {
                            textValue = resourceValue2.getValue();
                        }
                        textValue = StringUtil.notNullize(textValue);
                        String fileName = source.getFileName();
                        List<String> dirNames = Collections.singletonList(targetDir);
                        if (destFolderResources.containsEntry((Object)item.getName(), (Object)item.getType())) {
                            IdeResourcesUtil.changeValueResource(project, res, item.getName(), item.getType(), textValue, fileName, dirNames, false);
                            continue;
                        }
                        IdeResourcesUtil.createValueResource(project, res, item.getName(), item.getType(), fileName, dirNames, textValue);
                        continue;
                    }
                    VirtualFile virtualFile = IdeResourcesUtil.getSourceAsVirtualFile(item);
                    if (virtualFile != null) {
                        VirtualFile existing2 = destDir.findChild(virtualFile.getName());
                        if (existing2 != null) {
                            existing2.delete(requestor);
                        }
                        VfsUtilCore.copyFile(requestor, (VirtualFile)virtualFile, (VirtualFile)destDir);
                        continue;
                    }
                    return;
                }
                for (VirtualFile resourceFile : dir.getChildren()) {
                    resourceFile.delete(requestor);
                }
                dir.delete(requestor);
            }
            catch (IOException e) {
                Logger.getInstance(AndroidLintInspectionBase.class).error((Throwable)e);
            }
        }

        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            return this.dir.isDirectory();
        }

        @NotNull
        public String getName() {
            List<VirtualFile> folders = this.findSourceFolders();
            ArrayList names = Lists.newArrayListWithCapacity((int)folders.size());
            for (VirtualFile file2 : folders) {
                String name = file2.getName();
                int index2 = name.indexOf(45);
                if (index2 != -1) {
                    name = name.substring(index2);
                }
                names.add(name);
            }
            String sourceFolders = Joiner.on((String)" and ").join((Iterable)names);
            return String.format("Merge resources from %1$s into %2$s", sourceFolders, this.destFolderName);
        }
    }
}

