/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.resources.ResourceUrl;
import com.android.tools.idea.lint.GenerateBackupDescriptorFix;
import com.android.tools.idea.lint.SetAndGenerateBackupDescriptor;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.SetAttributeQuickFix;
import com.android.tools.lint.checks.ManifestDetector;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintAllowBackupInspection
extends AndroidLintInspectionBase {
    public AndroidLintAllowBackupInspection() {
        super(AndroidBundle.message("android.lint.inspections.allow.backup", new Object[0]), ManifestDetector.ALLOW_BACKUP);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2) {
        ResourceUrl url;
        if ("Missing `<full-backup-content>` resource".equals(message2) && (url = ResourceUrl.parse((String)startElement.getText())) != null) {
            return new LintIdeQuickFix[]{new GenerateBackupDescriptorFix(url)};
        }
        return new LintIdeQuickFix[]{new SetAttributeQuickFix("Set backup attribute", null, "allowBackup", null), new SetAttributeQuickFix("Set fullBackupContent attribute", null, "fullBackupContent", null){

            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                return SetAndGenerateBackupDescriptor.isAllowBackupEnabled(startElement) && super.isApplicable(startElement, endElement, contextType);
            }
        }, new SetAndGenerateBackupDescriptor()};
    }
}

