/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.idea.layoutinspector.model.StatusNotification;
import com.android.tools.idea.layoutinspector.ui.InspectorBannerService;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "actionLayout", "Ljava/awt/FlowLayout;", "actionPanel", "bannerBackground", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "bannerForeground", "classInitialized", "", "text", "Ljavax/swing/JLabel;", "getText$annotations", "()V", "getText", "()Ljavax/swing/JLabel;", "applyNewNotification", "", "statusNotification", "Lcom/android/tools/idea/layoutinspector/model/StatusNotification;", "applyUISettings", "doLayout", "updateUI", "intellij.android.layout-inspector"})
public final class InspectorBanner
extends JPanel {
    private final JBColor bannerBackground = JBColor.namedColor((String)"Notification.background", (Color)((Color)new JBColor(16775377, 1914967)));
    private final JBColor bannerForeground = JBColor.namedColor((String)"Notification.foreground", (Color)((Color)new JBColor(0x555555, 0xAAAAAA)));
    @NotNull
    private final JLabel text = new JLabel();
    private final FlowLayout actionLayout = new FlowLayout(1, JBUI.scale((int)6), 0);
    private final JPanel actionPanel = new JPanel(this.actionLayout);
    private boolean classInitialized = true;

    @VisibleForTesting
    public static /* synthetic */ void getText$annotations() {
    }

    @NotNull
    public final JLabel getText() {
        return this.text;
    }

    private final void applyUISettings() {
        this.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
        JBEmptyBorder borderSpacing = JBUI.Borders.empty((int)3, (int)6);
        this.actionPanel.setBorder((Border)borderSpacing);
        this.actionLayout.setHgap(JBUI.scale((int)3));
        this.text.setBorder((Border)borderSpacing);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.classInitialized) {
            this.applyUISettings();
        }
    }

    private final void applyNewNotification(StatusNotification statusNotification) {
        this.setVisible(statusNotification != null);
        StatusNotification statusNotification2 = statusNotification;
        if (statusNotification2 == null) {
            return;
        }
        StatusNotification notification = statusNotification2;
        this.text.setText(notification.getMessage());
        this.actionPanel.removeAll();
        Iterable $this$forEach$iv = notification.getActions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnAction action2 = (AnAction)element$iv;
            boolean bl = false;
            HyperlinkLabel actionLabel = new HyperlinkLabel(action2.getTemplateText(), (Color)JBColor.BLUE);
            actionLabel.addHyperlinkListener(new HyperlinkListener(actionLabel, action2){
                final /* synthetic */ HyperlinkLabel $actionLabel;
                final /* synthetic */ AnAction $action;

                public final void hyperlinkUpdate(HyperlinkEvent it) {
                    DataContext context = DataManager.getInstance().getDataContext((Component)this.$actionLabel);
                    Presentation presentation = this.$action.getTemplatePresentation().clone();
                    AnActionEvent event = new AnActionEvent(it.getInputEvent(), context, "Notification", presentation, ActionManager.getInstance(), 0);
                    this.$action.actionPerformed(event);
                }
                {
                    this.$actionLabel = hyperlinkLabel;
                    this.$action = anAction;
                }
            });
            this.actionPanel.add((Component)actionLabel);
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.text.getX() + this.text.getWidth() > this.actionPanel.getX()) {
            int n = 0;
            int n2 = this.actionPanel.getX() - this.text.getX();
            boolean bl = false;
            this.text.setSize(new Dimension(Math.max(n, n2), this.text.getSize().height));
        }
    }

    public InspectorBanner(@NotNull Project project) {
        super(new BorderLayout());
        this.setVisible(false);
        this.setBackground((Color)this.bannerBackground);
        this.text.setForeground((Color)this.bannerForeground);
        this.actionPanel.setBackground((Color)this.bannerBackground);
        this.add((Component)this.text, "West");
        this.add((Component)this.actionPanel, "East");
        this.applyUISettings();
        InspectorBannerService.Companion.getInstance(project).getNotificationListeners().add(new Function1<StatusNotification, Unit>(this){

            public final void invoke(@Nullable StatusNotification p1) {
                ((InspectorBanner)this.receiver).applyNewNotification(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(InspectorBanner.class);
            }

            public final String getName() {
                return "applyNewNotification";
            }

            public final String getSignature() {
                return "applyNewNotification(Lcom/android/tools/idea/layoutinspector/model/StatusNotification;)V";
            }
        });
    }
}

