/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.model;

import com.android.tools.idea.layoutinspector.SkiaParser;
import com.android.tools.idea.layoutinspector.SkiaParserService;
import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.ComponentTreeLoaderImpl;
import com.android.tools.idea.layoutinspector.model.TreeLoader;
import com.android.tools.idea.layoutinspector.resource.ResourceLookup;
import com.android.tools.idea.layoutinspector.transport.InspectorClient;
import com.android.tools.layoutinspector.proto.LayoutInspectorProto;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016JB\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J:\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/layoutinspector/model/ComponentTreeLoader;", "Lcom/android/tools/idea/layoutinspector/model/TreeLoader;", "()V", "getAllWindowIds", "", "", "data", "", "client", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "loadComponentTree", "Lkotlin/Pair;", "Lcom/android/tools/idea/layoutinspector/model/AndroidWindow;", "", "maybeEvent", "resourceLookup", "Lcom/android/tools/idea/layoutinspector/resource/ResourceLookup;", "skiaParser", "Lcom/android/tools/idea/layoutinspector/SkiaParserService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.layout-inspector"})
public final class ComponentTreeLoader
implements TreeLoader {
    public static final ComponentTreeLoader INSTANCE;

    @Override
    @Nullable
    public Pair<AndroidWindow, Integer> loadComponentTree(@Nullable Object data, @NotNull ResourceLookup resourceLookup, @NotNull InspectorClient client, @NotNull Project project) {
        return this.loadComponentTree(data, resourceLookup, client, SkiaParser.INSTANCE, project);
    }

    @VisibleForTesting
    @Nullable
    public final Pair<AndroidWindow, Integer> loadComponentTree(@Nullable Object maybeEvent, @NotNull ResourceLookup resourceLookup, @NotNull InspectorClient client, @NotNull SkiaParserService skiaParser, @NotNull Project project) {
        AndroidWindow androidWindow;
        Object object = maybeEvent;
        if (!(object instanceof LayoutInspectorProto.LayoutInspectorEvent)) {
            object = null;
        }
        LayoutInspectorProto.LayoutInspectorEvent layoutInspectorEvent = (LayoutInspectorProto.LayoutInspectorEvent)object;
        if (layoutInspectorEvent == null) {
            return null;
        }
        LayoutInspectorProto.LayoutInspectorEvent event = layoutInspectorEvent;
        if (event.getTree().hasRoot()) {
            androidWindow = new ComponentTreeLoaderImpl(event.getTree(), resourceLookup).loadComponentTree(client, skiaParser, project);
            if (androidWindow == null) {
                return null;
            }
        } else {
            androidWindow = null;
        }
        AndroidWindow window2 = androidWindow;
        return new Pair(window2, (Object)event.getTree().getGeneration());
    }

    @Nullable
    public List<Long> getAllWindowIds(@Nullable Object data, @NotNull InspectorClient client) {
        Object object = data;
        if (!(object instanceof LayoutInspectorProto.LayoutInspectorEvent)) {
            object = null;
        }
        LayoutInspectorProto.LayoutInspectorEvent layoutInspectorEvent = (LayoutInspectorProto.LayoutInspectorEvent)object;
        if (layoutInspectorEvent == null) {
            return null;
        }
        LayoutInspectorProto.LayoutInspectorEvent event = layoutInspectorEvent;
        return event.getTree().getAllWindowIdsList();
    }

    private ComponentTreeLoader() {
    }

    static {
        ComponentTreeLoader componentTreeLoader;
        INSTANCE = componentTreeLoader = new ComponentTreeLoader();
    }
}

