/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector;

import com.android.annotations.concurrency.Slow;
import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.layoutinspector.InvalidPictureException;
import com.android.tools.idea.layoutinspector.RequestedNodeInfo;
import com.android.tools.idea.layoutinspector.ServerInfo;
import com.android.tools.idea.layoutinspector.ServerVersionSpec;
import com.android.tools.idea.layoutinspector.SkiaParser;
import com.android.tools.idea.layoutinspector.SkiaParserService;
import com.android.tools.idea.layoutinspector.UnsupportedPictureVersionException;
import com.android.tools.idea.layoutinspector.VersionMap;
import com.android.tools.idea.layoutinspector.model.SkiaViewNode;
import com.android.tools.idea.layoutinspector.proto.SkiaParser;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\rH\u0007J\b\u0010\u001c\u001a\u00020\u0018H\u0003J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u000eH\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0007J6\u0010'\u001a\u0004\u0018\u00010\u00132\u0006\u0010%\u001a\u00020&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0)2\u0006\u0010*\u001a\u00020+2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0017J\b\u0010,\u001a\u00020-H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\u00062\u0006\u0010%\u001a\u00020&H\u0003J\b\u0010/\u001a\u00020-H\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u0006\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/idea/layoutinspector/SkiaParser;", "Lcom/android/tools/idea/layoutinspector/SkiaParserService;", "()V", "VERSION_MAP_FILE_NAME", "", "devbuildServerInfo", "Lcom/android/tools/idea/layoutinspector/ServerInfo;", "latestPackagePath", "mapLock", "", "progressIndicator", "Lcom/android/tools/idea/sdk/progress/StudioLoggerProgressIndicator;", "supportedVersionMap", "", "", "unmarshaller", "Ljavax/xml/bind/Unmarshaller;", "kotlin.jvm.PlatformType", "buildTree", "Lcom/android/tools/idea/layoutinspector/model/SkiaViewNode;", "node", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParser$InspectorView;", "isInterrupted", "Lkotlin/Function0;", "", "drawIdToRequest", "", "Lcom/android/tools/idea/layoutinspector/RequestedNodeInfo;", "downloadLatestVersion", "findServerInfoForSkpVersion", "skpVersion", "findVersionInMap", "getLatestParserPackage", "Lcom/android/repository/api/LocalPackage;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "getSkpVersion", "data", "", "getViewTree", "requestedNodes", "", "scale", "", "readVersionMapping", "", "runServer", "shutdownAll", "intellij.android.layout-inspector"})
public final class SkiaParser
implements SkiaParserService {
    private static final Unmarshaller unmarshaller;
    private static final ServerInfo devbuildServerInfo;
    private static Map<Integer, ServerInfo> supportedVersionMap;
    private static String latestPackagePath;
    private static final Object mapLock;
    private static final String VERSION_MAP_FILE_NAME = "version-map.xml";
    private static final StudioLoggerProgressIndicator progressIndicator;
    public static final SkiaParser INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    @Slow
    @Nullable
    public SkiaViewNode getViewTree(@NotNull byte[] data, @NotNull Iterable<RequestedNodeInfo> requestedNodes, double scale, @NotNull Function0<Boolean> isInterrupted) throws InvalidPictureException {
        Iterable<RequestedNodeInfo> iterable;
        ServerInfo serverInfo = this.runServer(data);
        if (serverInfo == null) {
            throw (Throwable)new UnsupportedPictureVersionException(this.getSkpVersion(data));
        }
        ServerInfo server = serverInfo;
        SkiaParser.GetViewTreeResponse response = server.getViewTree(data, requestedNodes, scale);
        SkiaParser.GetViewTreeResponse getViewTreeResponse = response;
        if (getViewTreeResponse != null && (getViewTreeResponse = getViewTreeResponse.getRoot()) != null) {
            Object object;
            SkiaParser.GetViewTreeResponse getViewTreeResponse2 = getViewTreeResponse;
            boolean bl = false;
            boolean bl2 = false;
            SkiaParser.GetViewTreeResponse it = getViewTreeResponse2;
            boolean bl3 = false;
            try {
                Map map2;
                void $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                object = requestedNodes;
                Function0<Boolean> function0 = isInterrupted;
                SkiaParser.GetViewTreeResponse getViewTreeResponse3 = it;
                SkiaParser skiaParser = INSTANCE;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                void var19_19 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void req;
                    RequestedNodeInfo requestedNodeInfo2 = (RequestedNodeInfo)element$iv$iv;
                    map2 = destination$iv$iv;
                    boolean bl4 = false;
                    Long l = req.getDrawId();
                    map2.put(l, element$iv$iv);
                }
                map2 = destination$iv$iv;
                object = skiaParser.buildTree((SkiaParser.InspectorView)getViewTreeResponse3, function0, map2);
            }
            catch (InterruptedException interruptedException) {
                object = null;
            }
            iterable = object;
        } else {
            iterable = null;
        }
        return iterable;
    }

    @Override
    @Slow
    public void shutdownAll() {
        Map<Integer, ServerInfo> map2 = supportedVersionMap;
        if (map2 != null && (map2 = map2.values()) != null) {
            Iterable $this$forEach$iv = (Iterable)((Object)map2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerInfo it = (ServerInfo)element$iv;
                boolean bl = false;
                it.shutdown();
            }
        }
        devbuildServerInfo.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @Nullable
    public final SkiaViewNode buildTree(@NotNull SkiaParser.InspectorView node2, @NotNull Function0<Boolean> isInterrupted, @NotNull Map<Long, RequestedNodeInfo> drawIdToRequest) {
        SkiaViewNode skiaViewNode;
        if (((Boolean)isInterrupted.invoke()).booleanValue()) {
            throw (Throwable)new InterruptedException();
        }
        if (!node2.getImage().isEmpty()) {
            int n;
            int n2;
            if (node2.getWidth() > 0) {
                n2 = node2.getWidth();
            } else {
                RequestedNodeInfo requestedNodeInfo2 = drawIdToRequest.get(node2.getId());
                if (requestedNodeInfo2 != null) {
                    n2 = requestedNodeInfo2.getWidth();
                } else {
                    return null;
                }
            }
            int width = n2;
            if (node2.getHeight() > 0) {
                n = node2.getHeight();
            } else {
                RequestedNodeInfo requestedNodeInfo3 = drawIdToRequest.get(node2.getId());
                if (requestedNodeInfo3 != null) {
                    n = requestedNodeInfo3.getHeight();
                } else {
                    return null;
                }
            }
            int height = n;
            int[] intArray = new int[width * height];
            node2.getImage().asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().get(intArray);
            DataBufferInt buffer = new DataBufferInt(intArray, width * height);
            SinglePixelPackedSampleModel model2 = new SinglePixelPackedSampleModel(3, width, height, new int[]{0xFF0000, 65280, 255, (int)0xFF000000L});
            WritableRaster raster = Raster.createWritableRaster(model2, buffer, new Point(0, 0));
            DirectColorModel colorModel = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, (int)0xFF000000L, false, 3);
            skiaViewNode = new SkiaViewNode(node2.getId(), new BufferedImage(colorModel, raster, false, null));
        } else {
            List list;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable width = node2.getChildrenList();
            long l = node2.getId();
            boolean $i$f$mapNotNull = false;
            void intArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SkiaViewNode skiaViewNode2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                SkiaParser.InspectorView it = (SkiaParser.InspectorView)element$iv$iv;
                boolean bl2 = false;
                if (INSTANCE.buildTree(it, isInterrupted, drawIdToRequest) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                SkiaViewNode it$iv$iv = skiaViewNode2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = list = (List)destination$iv$iv;
            long l2 = l;
            skiaViewNode = new SkiaViewNode(l2, list2);
        }
        return skiaViewNode;
    }

    @Slow
    private final ServerInfo runServer(byte[] data) {
        ServerInfo serverInfo = this.findServerInfoForSkpVersion(this.getSkpVersion(data));
        if (serverInfo == null) {
            return null;
        }
        ServerInfo server = serverInfo;
        server.runServer();
        return server;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final int getSkpVersion(@NotNull byte[] data) {
        int n = 0;
        List list = ArraysKt.slice((byte[])data, (IntRange)new IntRange(n, 7));
        String string = "skiapict";
        Charset charset = Charsets.US_ASCII;
        int n2 = 0;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        if (Intrinsics.areEqual((Object)list, (Object)ArraysKt.asList((byte[])byArray)) ^ true || data.length < 12) {
            throw (Throwable)new InvalidPictureException();
        }
        int skpVersion = 0;
        int mult = 1;
        n2 = 0;
        int n3 = 3;
        while (n2 <= n3) {
            void i2;
            skpVersion += data[i2 + 8] * mult;
            mult <<= 8;
            ++i2;
        }
        return skpVersion;
    }

    @VisibleForTesting
    @Nullable
    public final ServerInfo findServerInfoForSkpVersion(int skpVersion) {
        ServerInfo serverInfo;
        if (((Boolean)StudioFlags.DYNAMIC_LAYOUT_INSPECTOR_USE_DEVBUILD_SKIA_SERVER.get()).booleanValue()) {
            return devbuildServerInfo;
        }
        if (supportedVersionMap == null) {
            this.readVersionMapping();
        }
        if ((serverInfo = this.findVersionInMap(skpVersion)) == null) {
            LocalPackage latest = this.getLatestParserPackage(AndroidSdks.getInstance().tryToChooseSdkHandler());
            Object object = latest;
            if (object == null || (object = object.getPath()) == null || !((String)object).equals(latestPackagePath)) {
                this.readVersionMapping();
                serverInfo = this.findVersionInMap(skpVersion);
            }
            if (serverInfo == null && this.downloadLatestVersion()) {
                serverInfo = this.findVersionInMap(skpVersion);
            }
        }
        return serverInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ServerInfo findVersionInMap(int skpVersion) {
        ServerInfo serverInfo;
        Object object = mapLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            ServerInfo serverInfo2;
            boolean bl3 = false;
            Map<Integer, ServerInfo> map2 = supportedVersionMap;
            if (map2 != null) {
                Object v1;
                block6: {
                    Map<Integer, ServerInfo> map3 = map2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Map<Integer, ServerInfo> it = map3;
                    boolean bl6 = false;
                    Iterable iterable = it.values();
                    boolean bl7 = false;
                    Iterable iterable2 = iterable;
                    boolean bl8 = false;
                    for (Object t : iterable2) {
                        ServerInfo serverInfo3 = (ServerInfo)t;
                        boolean bl9 = false;
                        if (!serverInfo3.getSkpVersionRange().contains(skpVersion)) continue;
                        v1 = t;
                        break block6;
                    }
                    v1 = null;
                }
                serverInfo2 = v1;
            } else {
                serverInfo2 = null;
            }
            serverInfo = serverInfo2;
        }
        return serverInfo;
    }

    @Slow
    private final boolean downloadLatestVersion() {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)progressIndicator);
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (ProgressIndicator)progressIndicator, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
        RemotePackage remotePackage = sdkHandler.getLatestRemotePackageForPrefix("skiaparser", null, true, (ProgressIndicator)progressIndicator);
        if (remotePackage == null) {
            return false;
        }
        RemotePackage latestRemote = remotePackage;
        String maybeNewPackage = latestRemote.getPath();
        UpdatablePackage updatablePackage = (UpdatablePackage)sdkManager.getPackages().getConsolidatedPkgs().get(maybeNewPackage);
        if (updatablePackage == null) {
            return false;
        }
        UpdatablePackage updatablePackage2 = updatablePackage;
        if (updatablePackage2.hasLocal() && !updatablePackage2.isUpdate()) {
            return false;
        }
        CompletableFuture installResult = new CompletableFuture();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(updatablePackage2, sdkManager, maybeNewPackage, installResult){
            final /* synthetic */ UpdatablePackage $updatablePackage;
            final /* synthetic */ RepoManager $sdkManager;
            final /* synthetic */ String $maybeNewPackage;
            final /* synthetic */ CompletableFuture $installResult;

            public final void run() {
                boolean bl = false;
                ModelWizardDialog modelWizardDialog2 = SdkQuickfixUtils.createDialogForPackages(null, CollectionsKt.listOf((Object)this.$updatablePackage), CollectionsKt.emptyList(), false);
                if (modelWizardDialog2 != null) {
                    modelWizardDialog2.show();
                }
                UpdatablePackage newPackage = (UpdatablePackage)this.$sdkManager.getPackages().getConsolidatedPkgs().get(this.$maybeNewPackage);
                if (newPackage == null || !newPackage.hasLocal() || newPackage.isUpdate()) {
                    this.$installResult.complete(false);
                }
                SkiaParser.access$readVersionMapping(SkiaParser.INSTANCE);
                this.$installResult.complete(true);
            }
            {
                this.$updatablePackage = updatablePackage;
                this.$sdkManager = repoManager;
                this.$maybeNewPackage = string;
                this.$installResult = completableFuture;
            }
        });
        return (Boolean)installResult.get() != false && supportedVersionMap != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readVersionMapping() {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        LocalPackage latestPackage = this.getLatestParserPackage(sdkHandler);
        if (latestPackage != null) {
            File mappingFile = new File(latestPackage.getLocation(), VERSION_MAP_FILE_NAME);
            try {
                InputStream mapInputStream = sdkHandler.getFileOp().newFileInputStream(mappingFile);
                Object object = unmarshaller.unmarshal(mapInputStream);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.layoutinspector.VersionMap");
                }
                VersionMap map2 = (VersionMap)object;
                Object object2 = mapLock;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object2) {
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Map newMap = new LinkedHashMap();
                    for (ServerVersionSpec spec : map2.getServers()) {
                        Map<Integer, ServerInfo> map3 = supportedVersionMap;
                        ServerInfo existing2 = map3 != null ? map3.get(spec.getVersion()) : null;
                        ServerInfo serverInfo = existing2;
                        if (serverInfo != null && (serverInfo = serverInfo.getSkpVersionRange()) != null) {
                            if (serverInfo.getStart().intValue() == spec.getSkpStart()) {
                                Integer n = spec.getSkpEnd();
                                if (n != null && existing2.getSkpVersionRange().getLast() == n.intValue()) {
                                    newMap.put(spec.getVersion(), existing2);
                                    continue;
                                }
                            }
                        }
                        newMap.put(spec.getVersion(), new ServerInfo(spec.getVersion(), spec.getSkpStart(), spec.getSkpEnd()));
                    }
                    supportedVersionMap = newMap;
                    latestPackagePath = latestPackage.getPath();
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (Exception e) {
                Logger.getInstance(com.android.tools.idea.layoutinspector.proto.SkiaParser.class).warn("Failed to parse mapping file", (Throwable)e);
            }
        }
    }

    private final LocalPackage getLatestParserPackage(AndroidSdkHandler sdkHandler) {
        return sdkHandler.getLatestLocalPackageForPrefix("skiaparser", (Predicate)getLatestParserPackage.1.INSTANCE, true, (ProgressIndicator)progressIndicator);
    }

    private SkiaParser() {
    }

    static {
        SkiaParser skiaParser;
        INSTANCE = skiaParser = new SkiaParser();
        unmarshaller = JAXBContext.newInstance((Class[])new Class[]{VersionMap.class}).createUnmarshaller();
        devbuildServerInfo = new ServerInfo(null, -1, -1);
        mapLock = new Object();
        progressIndicator = new StudioLoggerProgressIndicator(com.android.tools.idea.layoutinspector.proto.SkiaParser.class);
    }

    public static final /* synthetic */ void access$readVersionMapping(SkiaParser $this) {
        $this.readVersionMapping();
    }
}

