/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector;

import com.android.annotations.concurrency.Slow;
import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.layoutinspector.RequestedNodeInfo;
import com.android.tools.idea.layoutinspector.SkiaParserKt;
import com.android.tools.idea.layoutinspector.proto.SkiaParser;
import com.android.tools.idea.layoutinspector.proto.SkiaParserServiceGrpc;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.net.NetUtils;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.NettyChannelBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\n\u0010%\u001a\u0004\u0018\u00010&H\u0002J(\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/H\u0007J(\u00100\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010(2\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u000205H\u0007J\b\u00106\u001a\u000205H\u0007J\b\u00107\u001a\u000205H\u0007J\b\u00108\u001a\u000209H\u0003R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006:"}, d2={"Lcom/android/tools/idea/layoutinspector/ServerInfo;", "", "serverVersion", "", "skpStart", "skpEnd", "(Ljava/lang/Integer;ILjava/lang/Integer;)V", "channel", "Lio/grpc/ManagedChannel;", "getChannel", "()Lio/grpc/ManagedChannel;", "setChannel", "(Lio/grpc/ManagedChannel;)V", "client", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParserServiceGrpc$SkiaParserServiceBlockingStub;", "getClient", "()Lcom/android/tools/idea/layoutinspector/proto/SkiaParserServiceGrpc$SkiaParserServiceBlockingStub;", "setClient", "(Lcom/android/tools/idea/layoutinspector/proto/SkiaParserServiceGrpc$SkiaParserServiceBlockingStub;)V", "handler", "Lcom/intellij/execution/process/OSProcessHandler;", "getHandler", "()Lcom/intellij/execution/process/OSProcessHandler;", "setHandler", "(Lcom/intellij/execution/process/OSProcessHandler;)V", "packagePath", "", "progressIndicator", "Lcom/android/tools/idea/sdk/progress/StudioLoggerProgressIndicator;", "serverName", "getServerVersion", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "skpVersionRange", "Lkotlin/ranges/IntRange;", "getSkpVersionRange", "()Lkotlin/ranges/IntRange;", "findPath", "Ljava/io/File;", "getViewTree", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParser$GetViewTreeResponse;", "data", "", "requestedNodes", "", "Lcom/android/tools/idea/layoutinspector/RequestedNodeInfo;", "scale", "", "getViewTreeImpl", "getViewTreeWithRetry", "request", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParser$GetViewTreeRequest;", "ping", "", "runServer", "shutdown", "tryDownload", "", "intellij.android.layout-inspector"})
public final class ServerInfo {
    private final String serverName;
    @NotNull
    private final IntRange skpVersionRange;
    @Nullable
    private SkiaParserServiceGrpc.SkiaParserServiceBlockingStub client;
    @Nullable
    private ManagedChannel channel;
    @Nullable
    private OSProcessHandler handler;
    private final StudioLoggerProgressIndicator progressIndicator;
    private final String packagePath;
    @Nullable
    private final Integer serverVersion;

    @NotNull
    public final IntRange getSkpVersionRange() {
        return this.skpVersionRange;
    }

    @Nullable
    public final SkiaParserServiceGrpc.SkiaParserServiceBlockingStub getClient() {
        return this.client;
    }

    public final void setClient(@Nullable SkiaParserServiceGrpc.SkiaParserServiceBlockingStub skiaParserServiceBlockingStub) {
        this.client = skiaParserServiceBlockingStub;
    }

    @Nullable
    public final ManagedChannel getChannel() {
        return this.channel;
    }

    public final void setChannel(@Nullable ManagedChannel managedChannel) {
        this.channel = managedChannel;
    }

    @Nullable
    public final OSProcessHandler getHandler() {
        return this.handler;
    }

    public final void setHandler(@Nullable OSProcessHandler oSProcessHandler) {
        this.handler = oSProcessHandler;
    }

    private final File findPath() {
        File file2;
        if (this.serverVersion == null) {
            file2 = new File(PathManager.getHomePath(), "../../bazel-bin/tools/base/dynamic-layout-inspector/" + this.serverName);
        } else {
            AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            LocalPackage localPackage = sdkHandler.getLocalPackage(this.packagePath, (ProgressIndicator)this.progressIndicator);
            if (localPackage == null) {
                return null;
            }
            LocalPackage serverPackage = localPackage;
            if (SkiaParserKt.access$getMinimumRevisions$p().getOrDefault(serverPackage.getPath(), new Revision(0)).compareTo(serverPackage.getVersion()) > 0) {
                UpdatablePackage updatablePackage = (UpdatablePackage)sdkHandler.getSdkManager((ProgressIndicator)this.progressIndicator).getPackages().getConsolidatedPkgs().get(this.packagePath);
                if (updatablePackage == null) {
                    return null;
                }
                UpdatablePackage updatablePackage2 = updatablePackage;
                if (updatablePackage2.isUpdate()) {
                    boolean bl = false;
                    ModelWizardDialog modelWizardDialog2 = SdkQuickfixUtils.createDialogForPackages(null, CollectionsKt.listOf((Object)updatablePackage2), CollectionsKt.emptyList(), false);
                    if (modelWizardDialog2 != null) {
                        modelWizardDialog2.show();
                    }
                }
                LocalPackage localPackage2 = sdkHandler.getLocalPackage(this.packagePath, (ProgressIndicator)this.progressIndicator);
                if (localPackage2 == null) {
                    return null;
                }
                serverPackage = localPackage2;
                if (SkiaParserKt.access$getMinimumRevisions$p().getOrDefault(serverPackage.getPath(), new Revision(0)).compareTo(serverPackage.getVersion()) > 0) {
                    return null;
                }
            }
            file2 = new File(serverPackage.getLocation(), this.serverName);
        }
        return file2;
    }

    @Slow
    public final void runServer() {
        block10: {
            File path2;
            if (this.client != null) {
                ManagedChannel managedChannel = this.channel;
                if (managedChannel == null || !managedChannel.isShutdown()) {
                    ManagedChannel managedChannel2 = this.channel;
                    if (managedChannel2 == null || !managedChannel2.isTerminated()) {
                        Object object = this.handler;
                        if (object != null && (object = object.getProcess()) != null) {
                            if (((Process)object).isAlive()) {
                                return;
                            }
                        }
                    }
                }
            }
            File file2 = path2 = this.findPath();
            if (file2 == null || !file2.exists()) {
                if (!this.tryDownload()) {
                    throw (Throwable)new Exception("Unable to find server version " + this.serverVersion);
                }
            }
            File file3 = this.findPath();
            if (file3 == null) {
                throw (Throwable)new Exception("Unable to find server version " + this.serverVersion);
            }
            File realPath = file3;
            int localPort = NetUtils.findAvailableSocketPort();
            if (localPort < 0) {
                throw (Throwable)new Exception("Unable to find available socket port");
            }
            this.channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)"localhost", (int)localPort).usePlaintext().maxInboundMessageSize(0x1FFFFFFF)).build();
            this.client = SkiaParserServiceGrpc.newBlockingStub((Channel)((Channel)this.channel));
            OSProcessHandler oSProcessHandler = this.handler = (OSProcessHandler)new OSProcessHandler.Silent(new GeneralCommandLine(new String[]{realPath.getAbsolutePath(), String.valueOf(localPort)}));
            if (oSProcessHandler == null) {
                Intrinsics.throwNpe();
            }
            oSProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event.getExitCode() != 0 && event.getExitCode() != 137) {
                        Logger.getInstance(SkiaParser.class).error("SkiaServer terminated exitCode: " + event.getExitCode() + "  text: " + event.getText());
                    } else {
                        Logger.getInstance(SkiaParser.class).info("SkiaServer terminated successfully");
                    }
                }

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    Logger.getInstance(SkiaParser.class).debug("SkiaServer willTerminate");
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                    Logger.getInstance(SkiaParser.class).info("SkiaServer Message: " + event.getText());
                }
            });
            OSProcessHandler oSProcessHandler2 = this.handler;
            if (oSProcessHandler2 == null) break block10;
            ((OSProcessHandler.Silent)oSProcessHandler2).startNotify();
        }
    }

    @Slow
    public final void shutdown() {
        ManagedChannel managedChannel = this.channel;
        if (managedChannel != null) {
            managedChannel.shutdownNow();
        }
        ManagedChannel managedChannel2 = this.channel;
        if (managedChannel2 != null) {
            managedChannel2.awaitTermination(1L, TimeUnit.SECONDS);
        }
        this.channel = null;
        this.client = null;
        OSProcessHandler oSProcessHandler = this.handler;
        if (oSProcessHandler != null) {
            oSProcessHandler.destroyProcess();
        }
        this.handler = null;
    }

    /*
     * WARNING - void declaration
     */
    @Slow
    private final boolean tryDownload() {
        void result2;
        if (this.serverVersion == null) {
            return false;
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)this.progressIndicator);
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (ProgressIndicator)this.progressIndicator, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
        UpdatablePackage updatablePackage = (UpdatablePackage)sdkManager.getPackages().getConsolidatedPkgs().get(this.packagePath);
        if (updatablePackage == null) {
            return false;
        }
        UpdatablePackage updatablePackage2 = updatablePackage;
        if (updatablePackage2.hasLocal() && !updatablePackage2.isUpdate()) {
            return false;
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(this, updatablePackage2, sdkManager, (Ref.BooleanRef)result2){
            final /* synthetic */ ServerInfo this$0;
            final /* synthetic */ UpdatablePackage $updatablePackage;
            final /* synthetic */ RepoManager $sdkManager;
            final /* synthetic */ Ref.BooleanRef $result;

            public final void invoke() {
                boolean bl = false;
                ModelWizardDialog modelWizardDialog2 = SdkQuickfixUtils.createDialogForPackages(null, CollectionsKt.listOf((Object)this.$updatablePackage), CollectionsKt.emptyList(), false);
                if (modelWizardDialog2 == null) {
                    return;
                }
                modelWizardDialog2.show();
                this.$sdkManager.reloadLocalIfNeeded((ProgressIndicator)ServerInfo.access$getProgressIndicator$p(this.this$0));
                UpdatablePackage updatablePackage = (UpdatablePackage)this.$sdkManager.getPackages().getConsolidatedPkgs().get(ServerInfo.access$getPackagePath$p(this.this$0));
                if (updatablePackage == null) {
                    return;
                }
                UpdatablePackage newPackage = updatablePackage;
                this.$result.element = newPackage.hasLocal() && !newPackage.isUpdate();
            }
            {
                this.this$0 = serverInfo;
                this.$updatablePackage = updatablePackage;
                this.$sdkManager = repoManager;
                this.$result = booleanRef;
                super(0);
            }
        }), (int)1, null);
        return result2.element;
    }

    @Slow
    @Nullable
    public final SkiaParser.GetViewTreeResponse getViewTree(@NotNull byte[] data, @NotNull Iterable<RequestedNodeInfo> requestedNodes, double scale) {
        this.ping();
        return this.getViewTreeImpl(data, requestedNodes, scale);
    }

    @Slow
    public final void ping() {
        this.getViewTreeImpl(new byte[1], CollectionsKt.emptyList(), 0.0);
    }

    /*
     * WARNING - void declaration
     */
    private final SkiaParser.GetViewTreeResponse getViewTreeImpl(byte[] data, Iterable<RequestedNodeInfo> requestedNodes, double scale) {
        Collection<SkiaParser.RequestedNodeInfo> collection2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable<RequestedNodeInfo> iterable = requestedNodes;
        SkiaParser.GetViewTreeRequest.Builder builder2 = SkiaParser.GetViewTreeRequest.newBuilder().setVersion(1).setSkp(ByteString.copyFrom((byte[])data));
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RequestedNodeInfo requestedNodeInfo2 = (RequestedNodeInfo)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            SkiaParser.RequestedNodeInfo requestedNodeInfo3 = SkiaParser.RequestedNodeInfo.newBuilder().setId(it.getDrawId()).setWidth(it.getWidth()).setHeight(it.getHeight()).setX(it.getX()).setY(it.getY()).build();
            collection2.add(requestedNodeInfo3);
        }
        collection2 = (List)destination$iv$iv;
        SkiaParser.GetViewTreeRequest request = builder2.addAllRequestedNodes((Iterable)collection2).setScale((float)scale).build();
        return this.getViewTreeWithRetry(request);
    }

    private final SkiaParser.GetViewTreeResponse getViewTreeWithRetry(SkiaParser.GetViewTreeRequest request) {
        long delay = 10L;
        StatusRuntimeException lastException = null;
        for (int tries = 0; tries < 10; ++tries) {
            try {
                SkiaParserServiceGrpc.SkiaParserServiceBlockingStub skiaParserServiceBlockingStub = this.client;
                return skiaParserServiceBlockingStub != null ? skiaParserServiceBlockingStub.getViewTree(request) : null;
            }
            catch (StatusRuntimeException ex) {
                if (ex.getStatus().getCode() != Status.Code.UNAVAILABLE) {
                    throw (Throwable)ex;
                }
                Thread.sleep(delay);
                long l = (long)2 * delay;
                long l2 = 1000L;
                boolean bl = false;
                delay = Math.min(l, l2);
                lastException = ex;
                continue;
            }
        }
        StatusRuntimeException statusRuntimeException = lastException;
        if (statusRuntimeException == null) {
            Intrinsics.throwNpe();
        }
        throw (Throwable)statusRuntimeException;
    }

    @Nullable
    public final Integer getServerVersion() {
        return this.serverVersion;
    }

    public ServerInfo(@Nullable Integer serverVersion, int skpStart, @Nullable Integer skpEnd) {
        this.serverVersion = serverVersion;
        this.serverName = "skia-grpc-server" + (SystemInfo.isWindows ? ".exe" : "");
        Integer n = skpEnd;
        this.skpVersionRange = new IntRange(skpStart, n != null ? n : Integer.MAX_VALUE);
        this.progressIndicator = new StudioLoggerProgressIndicator(ServerInfo.class);
        this.packagePath = "skiaparser;" + this.serverVersion;
    }

    public static final /* synthetic */ StudioLoggerProgressIndicator access$getProgressIndicator$p(ServerInfo $this) {
        return $this.progressIndicator;
    }

    public static final /* synthetic */ String access$getPackagePath$p(ServerInfo $this) {
        return $this.packagePath;
    }
}

