/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector;

import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.transport.DisconnectedClient;
import com.android.tools.idea.layoutinspector.transport.InspectorClient;
import com.android.tools.layoutinspector.proto.LayoutInspectorProto;
import com.android.tools.profiler.proto.Common;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "Lcom/intellij/openapi/Disposable;", "layoutInspectorModel", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "parentDisposable", "(Lcom/android/tools/idea/layoutinspector/model/InspectorModel;Lcom/intellij/openapi/Disposable;)V", "allClients", "", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "getAllClients", "()Ljava/util/List;", "currentClient", "getCurrentClient", "()Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "currentClientReference", "Ljava/util/concurrent/atomic/AtomicReference;", "latestLoadTime", "Ljava/util/concurrent/atomic/AtomicLong;", "getLayoutInspectorModel", "()Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "dispose", "", "loadComponentTree", "event", "", "logError", "processChanged", "client", "registerClientListeners", "setCurrentTestClient", "intellij.android.layout-inspector"})
public final class LayoutInspector
implements Disposable {
    private final AtomicReference<InspectorClient> currentClientReference;
    private final AtomicLong latestLoadTime;
    @NotNull
    private final List<InspectorClient> allClients;
    @NotNull
    private final InspectorModel layoutInspectorModel;

    @NotNull
    public final InspectorClient getCurrentClient() {
        return this.currentClientReference.get();
    }

    @NotNull
    public final List<InspectorClient> getAllClients() {
        return this.allClients;
    }

    public void dispose() {
    }

    private final void registerClientListeners(InspectorClient client) {
        client.register(Common.Event.EventGroupIds.LAYOUT_INSPECTOR_ERROR, (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(this){

            public final void invoke(@NotNull Object p1) {
                LayoutInspector.access$logError((LayoutInspector)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(LayoutInspector.class);
            }

            public final String getName() {
                return "logError";
            }

            public final String getSignature() {
                return "logError(Ljava/lang/Object;)V";
            }
        }));
        client.register(Common.Event.EventGroupIds.COMPONENT_TREE, (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(this){

            public final void invoke(@NotNull Object p1) {
                LayoutInspector.access$loadComponentTree((LayoutInspector)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(LayoutInspector.class);
            }

            public final String getName() {
                return "loadComponentTree";
            }

            public final String getSignature() {
                return "loadComponentTree(Ljava/lang/Object;)V";
            }
        }));
        client.registerProcessChanged((Function1<? super InspectorClient, Unit>)((Function1)new Function1<InspectorClient, Unit>(this){

            public final void invoke(@NotNull InspectorClient p1) {
                LayoutInspector.access$processChanged((LayoutInspector)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(LayoutInspector.class);
            }

            public final String getName() {
                return "processChanged";
            }

            public final String getSignature() {
                return "processChanged(Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;)V";
            }
        }));
    }

    public final void setCurrentTestClient(@NotNull InspectorClient client) {
        this.currentClientReference.set(client);
    }

    private final void processChanged(InspectorClient client) {
        if (client.isConnected()) {
            InspectorClient oldClient = this.currentClientReference.getAndSet(client);
            if (oldClient != client) {
                oldClient.disconnect();
                this.layoutInspectorModel.updateConnection(client);
            }
        } else if (this.currentClientReference.compareAndSet(client, DisconnectedClient.INSTANCE)) {
            this.layoutInspectorModel.updateConnection(DisconnectedClient.INSTANCE);
            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                final /* synthetic */ LayoutInspector this$0;

                public final void run() {
                    if (this.this$0.getCurrentClient() == DisconnectedClient.INSTANCE) {
                        boolean bl = false;
                        this.this$0.getLayoutInspectorModel().update(null, CollectionsKt.emptyList(), 0);
                    }
                }
                {
                    this.this$0 = layoutInspector;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void loadComponentTree(Object event) {
        long time2 = System.currentTimeMillis();
        List<?> allIds = this.getCurrentClient().getTreeLoader().getAllWindowIds(event, this.getCurrentClient());
        Pair<AndroidWindow, Integer> pair = this.getCurrentClient().getTreeLoader().loadComponentTree(event, this.layoutInspectorModel.getResourceLookup(), this.getCurrentClient(), this.layoutInspectorModel.getProject());
        if (pair == null) {
            return;
        }
        Object object = pair;
        AndroidWindow androidWindow = (AndroidWindow)object.component1();
        int generation = ((Number)object.component2()).intValue();
        if (allIds != null) {
            object = this.latestLoadTime;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                void window2;
                boolean bl3 = false;
                if (this.latestLoadTime.get() > time2) {
                    return;
                }
                this.latestLoadTime.set(time2);
                this.layoutInspectorModel.update((AndroidWindow)window2, allIds, generation);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private final void logError(Object event) {
        Object object = event;
        String error = object instanceof LayoutInspectorProto.LayoutInspectorEvent ? ((LayoutInspectorProto.LayoutInspectorEvent)event).getErrorMessage() : (object instanceof String ? (String)event : "Unknown Error");
        Logger.getInstance((String)LayoutInspector.class.getCanonicalName()).warn(error);
    }

    @NotNull
    public final InspectorModel getLayoutInspectorModel() {
        return this.layoutInspectorModel;
    }

    public LayoutInspector(@NotNull InspectorModel layoutInspectorModel, @NotNull Disposable parentDisposable) {
        this.layoutInspectorModel = layoutInspectorModel;
        this.currentClientReference = new AtomicReference<DisconnectedClient>(DisconnectedClient.INSTANCE);
        this.latestLoadTime = new AtomicLong(-1L);
        this.allClients = InspectorClient.Companion.createInstances(this.layoutInspectorModel, this);
        Iterable $this$forEach$iv = this.allClients;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InspectorClient it = (InspectorClient)element$iv;
            boolean bl = false;
            this.registerClientListeners(it);
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public static final /* synthetic */ void access$logError(LayoutInspector $this, Object event) {
        $this.logError(event);
    }

    public static final /* synthetic */ void access$loadComponentTree(LayoutInspector $this, Object event) {
        $this.loadComponentTree(event);
    }

    public static final /* synthetic */ void access$processChanged(LayoutInspector $this, InspectorClient client) {
        $this.processChanged(client);
    }
}

