/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PersistentGradleDistributionSHA256", storages={@Storage(value="cachedGradleSHA256.xml")})
public class PersistentSHA256Checksums
implements PersistentStateComponent<PersistentSHA256Checksums> {
    public HashMap<String, String> myStoredChecksums;

    public static PersistentSHA256Checksums getInstance() {
        return (PersistentSHA256Checksums)ServiceManager.getService(PersistentSHA256Checksums.class);
    }

    public PersistentSHA256Checksums getState() {
        return this;
    }

    public void loadState(@NotNull PersistentSHA256Checksums state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public boolean isChecksumStored(@Nullable String distribution, @Nullable String checksum) {
        if (this.myStoredChecksums == null) {
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)distribution) || StringUtil.isEmptyOrSpaces((String)checksum)) {
            return false;
        }
        return checksum.equals(this.myStoredChecksums.getOrDefault(distribution, null));
    }

    public void storeChecksum(@NotNull String distribution, @NotNull String checksum) {
        if (this.myStoredChecksums == null) {
            this.myStoredChecksums = new HashMap();
        }
        this.myStoredChecksums.put(distribution, checksum);
    }
}

