/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.tools.idea.util.PropertiesFiles;
import com.android.tools.idea.wizard.template.TemplateData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.io.Resources;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleWrapper {
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Pattern GRADLE_DISTRIBUTION_URL_PATTERN = Pattern.compile(".*/gradle-([^-]+)(-[^\\/\\\\]+)?-(bin|all).zip");
    @NotNull
    private final File myPropertiesFilePath;
    @Nullable
    private final Project myProject;

    @Nullable
    public static GradleWrapper find(@NotNull Project project) {
        String basePath = project.getBasePath();
        if (basePath == null) {
            return null;
        }
        File baseDir = new File(basePath);
        File propertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(baseDir);
        return propertiesFilePath.isFile() ? new GradleWrapper(propertiesFilePath, project) : null;
    }

    @NotNull
    public static GradleWrapper get(@NotNull File propertiesFilePath, @Nullable Project project) {
        return new GradleWrapper(propertiesFilePath, project);
    }

    @NotNull
    public static GradleWrapper create(@NotNull VirtualFile projectPath, @Nullable Project project) throws IOException {
        return GradleWrapper.create(projectPath, "6.7.1", project);
    }

    @NotNull
    public static GradleWrapper create(@NotNull File projectPath, @Nullable Project project) throws IOException {
        return GradleWrapper.create(projectPath, "6.7.1", project);
    }

    @NotNull
    public static GradleWrapper create(@NotNull File projectPath, @NotNull String gradleVersion2, @Nullable Project project) throws IOException {
        VirtualFile projectDirVirtualFile = VfsUtil.findFileByIoFile((File)projectPath, (boolean)true);
        if (projectDirVirtualFile == null) {
            throw new IOException("Not existent project path: " + projectPath);
        }
        return GradleWrapper.create(projectDirVirtualFile, gradleVersion2, project);
    }

    @NotNull
    public static GradleWrapper create(@NotNull VirtualFile projectPath, @NotNull String gradleVersion2, @Nullable Project project) throws IOException {
        WriteAction.computeAndWait(() -> {
            if (projectPath.findFileByRelativePath(SdkConstants.FD_GRADLE_WRAPPER) == null) {
                boolean madeExecutable;
                VirtualFile wrapperVf = GradleWrapper.getWrapperLocation();
                String sourceRootUrl = wrapperVf.getUrl();
                VfsUtil.copyDirectory(GradleWrapper.class, (VirtualFile)wrapperVf, (VirtualFile)projectPath, it -> projectPath.findFileByRelativePath(it.getUrl().substring(sourceRootUrl.length())) == null);
                VirtualFile gradlewDest = projectPath.findChild("gradlew");
                boolean bl = madeExecutable = gradlewDest != null && new File(gradlewDest.getPath()).setExecutable(true);
                if (!madeExecutable) {
                    Logger.getInstance(GradleWrapper.class).warn("Unable to make gradlew executable");
                }
            }
            return null;
        });
        File propertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(new File(projectPath.getPath()));
        GradleWrapper gradleWrapper = GradleWrapper.get(propertiesFilePath, project);
        gradleWrapper.updateDistributionUrl(gradleVersion2);
        return gradleWrapper;
    }

    @NotNull
    private static VirtualFile getWrapperLocation() {
        File resource = new File("templates/project/wrapper");
        String resourceName = "/" + resource.getPath().replace('\\', '/');
        URL wrapperUrl = Resources.getResource(TemplateData.class, (String)resourceName);
        VirtualFile wrapperVf = VfsUtil.findFileByURL((URL)wrapperUrl);
        assert (wrapperVf != null);
        wrapperVf.refresh(false, true);
        return wrapperVf;
    }

    private GradleWrapper(@NotNull File propertiesFilePath, @Nullable Project project) {
        this.myProject = project;
        this.myPropertiesFilePath = propertiesFilePath;
    }

    @NotNull
    public File getPropertiesFilePath() {
        return this.myPropertiesFilePath;
    }

    @Nullable
    public VirtualFile getPropertiesFile() {
        return VfsUtil.findFileByIoFile((File)this.myPropertiesFilePath, (boolean)true);
    }

    @NotNull
    public static File getDefaultPropertiesFilePath(@NotNull File projectPath) {
        return new File(projectPath, GRADLEW_PROPERTIES_PATH);
    }

    public boolean updateDistributionUrlAndDisplayFailure(@NotNull String gradleVersion2) {
        try {
            boolean updated = this.updateDistributionUrl(gradleVersion2);
            if (updated) {
                return true;
            }
        }
        catch (IOException e) {
            String msg = String.format("Unable to update Gradle wrapper to use Gradle %1$s\n", gradleVersion2);
            msg = msg + e.getMessage();
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
        }
        return false;
    }

    public boolean updateDistributionUrl(@NotNull String gradleVersion2) throws IOException {
        Properties properties2 = this.getProperties();
        String distributionUrl = GradleWrapper.getDistributionUrl(gradleVersion2, true);
        String property2 = properties2.getProperty("distributionUrl");
        if (property2 != null && (property2.equals(distributionUrl) || property2.equals(GradleWrapper.getDistributionUrl(gradleVersion2, true)))) {
            return false;
        }
        properties2.setProperty("distributionUrl", distributionUrl);
        GradleWrapper.saveProperties(properties2, this.myPropertiesFilePath, this.myProject);
        return true;
    }

    public boolean updateDistributionUrl(@NotNull File gradleDistribution) throws IOException {
        String path2 = gradleDistribution.getPath();
        if (!FileUtilRt.extensionEquals((String)path2, (String)"zip")) {
            throw new IllegalArgumentException("'" + path2 + "' should be a zip file");
        }
        Properties properties2 = this.getProperties();
        properties2.setProperty("distributionUrl", gradleDistribution.toURI().toURL().toString());
        GradleWrapper.saveProperties(properties2, this.myPropertiesFilePath, this.myProject);
        return true;
    }

    @NotNull
    public Properties getProperties() throws IOException {
        return PropertiesFiles.getProperties(this.myPropertiesFilePath);
    }

    private static void saveProperties(@NotNull Properties properties2, @NotNull File file2, @Nullable Project project) throws IOException {
        PropertiesFiles.savePropertiesToFile(properties2, file2, null);
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
        if (virtualFile != null) {
            virtualFile.refresh(false, false);
            if (project != null) {
                Document document;
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
                PsiFile psiFile2 = PsiManagerEx.getInstanceEx((Project)project).findFile(virtualFile);
                if (psiFile2 != null && (document = manager.getDocument(psiFile2)) != null) {
                    Application app = ApplicationManager.getApplication();
                    app.invokeAndWait(() -> app.runWriteAction(() -> manager.commitDocument(document)));
                }
            }
        }
    }

    @Nullable
    public String getGradleVersion() throws IOException {
        Matcher m;
        String url = this.getProperties().getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @Nullable
    public String getGradleFullVersion() throws IOException {
        Matcher m;
        String url = this.getProperties().getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1) + Strings.nullToEmpty((String)m.group(2));
        }
        return null;
    }

    @Nullable
    public String getDistributionSha256Sum() throws IOException {
        return this.getProperties().getProperty("distributionSha256Sum");
    }

    @Nullable
    public String getDistributionUrl() throws IOException {
        return this.getProperties().getProperty("distributionUrl");
    }

    @NotNull
    public String getUpdatedDistributionUrl(String gradleVersion2, boolean binOnlyIfCurrentlyUnknown) throws IOException {
        String current = this.getDistributionUrl();
        if (current == null) {
            return GradleWrapper.getDistributionUrl(gradleVersion2, binOnlyIfCurrentlyUnknown);
        }
        if (current.contains("://services.gradle.org/")) {
            Matcher m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(current);
            if (m.matches()) {
                return GradleWrapper.getDistributionUrl(gradleVersion2, "bin".equals(m.group(3)));
            }
            return GradleWrapper.getDistributionUrl(gradleVersion2, binOnlyIfCurrentlyUnknown);
        }
        Matcher m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(current);
        if (m.matches()) {
            StringBuilder sb = new StringBuilder();
            sb.append(current, 0, m.start(1));
            sb.append(gradleVersion2);
            sb.append(current, m.end(2) == -1 ? m.end(1) : m.end(2), current.length());
            return sb.toString();
        }
        return GradleWrapper.getDistributionUrl(gradleVersion2, binOnlyIfCurrentlyUnknown);
    }

    @NotNull
    public static String getDistributionUrl(@NotNull String gradleVersion2, boolean binOnly) {
        String folderName = GradleWrapper.isSnapshot(gradleVersion2) ? "distributions-snapshots" : "distributions";
        String suffix = binOnly ? "bin" : "all";
        return String.format("https://services.gradle.org/%1$s/gradle-%2$s-%3$s.zip", folderName, gradleVersion2, suffix);
    }

    @VisibleForTesting
    static boolean isSnapshot(@NotNull String gradleVersion2) {
        return gradleVersion2.indexOf(45) != -1 && gradleVersion2.endsWith("+0000");
    }
}

