/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.AppBundleVariantBuildOutput;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.upgrade.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.gradle.util.GradleBuildOutputUtil;
import com.android.tools.idea.gradle.util.OutputType;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.android.utils.HtmlBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicAppUtils {
    private static final int UPDATE_BUTTON_INDEX = 1;

    @NotNull
    public static List<Module> getDependentFeatureModulesForBase(@NotNull Module module2) {
        AndroidModuleModel androidModule = AndroidModuleModel.get(module2);
        if (androidModule == null) {
            return ImmutableList.of();
        }
        return DynamicAppUtils.getDependentFeatureModulesForBase(module2.getProject(), androidModule.getAndroidProject());
    }

    @Nullable
    public static Module getBaseFeature(@NotNull Module module2) {
        String gradlePath = DynamicAppUtils.getGradlePath(module2);
        if (gradlePath == null) {
            return null;
        }
        return Arrays.stream(ModuleManager.getInstance((Project)module2.getProject()).getModules()).filter(baseModule -> {
            AndroidModuleModel baseModel = AndroidModuleModel.get(baseModule);
            return baseModel != null && baseModel.getAndroidProject().getDynamicFeatures().contains(gradlePath);
        }).findFirst().orElse(null);
    }

    @NotNull
    public static List<Module> getDependentFeatureModulesForBase(@NotNull Project project, @NotNull IdeAndroidProject androidProject) {
        Map<String, Module> featureMap = DynamicAppUtils.getDynamicFeaturesMap(project);
        return androidProject.getDynamicFeatures().stream().map(featurePath -> (Module)featureMap.get(featurePath)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public static List<Module> getModulesToBuild(@NotNull Module module2) {
        return Stream.concat(Stream.of(module2), DynamicAppUtils.getDependentFeatureModulesForBase(module2).stream()).collect(Collectors.toList());
    }

    @NotNull
    public static List<Module> getFeatureModulesDependingOnFeature(@NotNull Module featureModule) {
        if (!((Boolean)StudioFlags.SUPPORT_FEATURE_ON_FEATURE_DEPS.get()).booleanValue()) {
            return ImmutableList.of();
        }
        return DynamicAppUtils.selectFeatureModules(ModuleManager.getInstance((Project)featureModule.getProject()).getModuleDependentModules(featureModule).stream());
    }

    @NotNull
    public static List<Module> getFeatureModuleDependenciesForFeature(@NotNull Module featureModule) {
        if (!((Boolean)StudioFlags.SUPPORT_FEATURE_ON_FEATURE_DEPS.get()).booleanValue()) {
            return ImmutableList.of();
        }
        return DynamicAppUtils.selectFeatureModules(Stream.of(ModuleRootManager.getInstance((Module)featureModule).getDependencies()));
    }

    public static boolean baseIsInstantEnabled(@NotNull Project project) {
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel model2 = AndroidModuleModel.get(module2);
            if (model2 == null || !model2.getAndroidProject().isBaseSplit() || !model2.getSelectedVariant().getInstantAppCompatible()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<Module> getModulesSupportingBundleTask(@NotNull Project project) {
        return ProjectStructure.getInstance(project).getAppModules().stream().filter(module2 -> DynamicAppUtils.supportsBundleTask(module2)).collect(Collectors.toList());
    }

    public static boolean supportsBundleTask(@NotNull Module module2) {
        AndroidModuleModel androidModule = AndroidModuleModel.get(module2);
        if (androidModule == null) {
            return false;
        }
        return !StringUtil.isEmpty((String)androidModule.getSelectedVariant().getMainArtifact().getBundleTaskName());
    }

    public static boolean promptUserForGradleUpdate(@NotNull Project project) {
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.openHtmlBody();
        builder2.add("Building Android App Bundles requires you to update to the latest version of the Android Gradle Plugin.");
        builder2.newline();
        builder2.addLink("Learn More", "https://d.android.com/r/studio-ui/dynamic-delivery/overview.html");
        builder2.newline();
        builder2.newline();
        builder2.add("App bundles allow you to support multiple device configurations from a single build artifact.");
        builder2.newline();
        builder2.add("App stores that support the bundle format use it to build and sign your APKs for you, and");
        builder2.newline();
        builder2.add("serve those APKs to users as needed.");
        builder2.newline();
        builder2.newline();
        builder2.closeHtmlBody();
        int result2 = Messages.showDialog((Project)project, (String)builder2.getHtml(), (String)"Update the Android Gradle Plugin", (String[])new String[]{Messages.getCancelButton(), "Update"}, (int)1, (Icon)AllIcons.General.WarningDialog);
        if (result2 == 1) {
            ApplicationManager.getApplication().invokeLater(() -> {
                GradleVersion gradleVersion2 = GradleVersion.parse((String)"6.7.1");
                GradleVersion pluginVersion = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
                AndroidPluginVersionUpdater updater = AndroidPluginVersionUpdater.getInstance(project);
                Runnable updatePluginVersion = () -> {
                    AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(project);
                    updater.updatePluginVersion(pluginVersion, gradleVersion2, pluginInfo == null ? null : pluginInfo.getPluginVersion());
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    updatePluginVersion.run();
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(updatePluginVersion);
                }
            });
        }
        return result2 == 1;
    }

    @NotNull
    public static String getFeatureNameFromPathHack(@NotNull Path path2) {
        String fileName = path2.getFileName().toString();
        int separatorIndex = fileName.lastIndexOf(45);
        if (separatorIndex < 0) {
            return "";
        }
        return fileName.substring(0, separatorIndex);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ApkInfo collectAppBundleOutput(@NotNull Module module2, @NotNull PostBuildModelProvider outputModelProvider, @NotNull String pkgName) {
        File apkFolder;
        AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
        if (androidModel == null) {
            DynamicAppUtils.getLogger().warn("Android model is null. Sync might have failed");
            return null;
        }
        File file2 = apkFolder = androidModel.getFeatures().isBuildOutputFileSupported() ? GradleBuildOutputUtil.getOutputFileOrFolderFromListingFile(androidModel, androidModel.getSelectedVariant().getName(), OutputType.ApkFromBundle, false) : DynamicAppUtils.collectApkFolderFromPostBuildModel(module2, outputModelProvider, androidModel);
        if (apkFolder == null) {
            DynamicAppUtils.getLogger().warn("Could not find apk folder.");
            return null;
        }
        try (Stream<Path> stream = Files.list(apkFolder.toPath());){
            List<ApkFileUnit> apks = stream.map(path2 -> new ApkFileUnit(DynamicAppUtils.getFeatureNameFromPathHack(path2), path2.toFile())).collect(Collectors.toList());
            ApkInfo apkInfo = new ApkInfo(apks, pkgName);
            return apkInfo;
        }
        catch (IOException e) {
            DynamicAppUtils.getLogger().warn(String.format("Error reading list of APK files from bundle build output directory \"%s\".", apkFolder), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static File collectApkFolderFromPostBuildModel(@NotNull Module module2, @NotNull PostBuildModelProvider outputModelProvider, @NotNull AndroidModuleModel androidModel) {
        PostBuildModel model2 = outputModelProvider.getPostBuildModel();
        if (model2 == null) {
            DynamicAppUtils.getLogger().warn("Post build model is null. Build might have failed.");
            return null;
        }
        AppBundleProjectBuildOutput output = model2.findAppBundleProjectBuildOutput(module2);
        if (output == null) {
            DynamicAppUtils.getLogger().warn("Project output is null. Build may have failed.");
            return null;
        }
        for (AppBundleVariantBuildOutput variantBuildOutput : output.getAppBundleVariantsBuildOutput()) {
            if (!variantBuildOutput.getName().equals(androidModel.getSelectedVariant().getName())) continue;
            return variantBuildOutput.getApkFolder();
        }
        DynamicAppUtils.getLogger().warn("Bundle variant build output model has no entries. Build may have failed.");
        return null;
    }

    public static boolean useSelectApksFromBundleBuilder(@NotNull Module module2, @NotNull AndroidRunConfigurationBase configuration, @Nullable AndroidVersion minTargetDeviceVersion) {
        AndroidModuleModel androidModuleModel;
        if (configuration instanceof AndroidRunConfiguration) {
            AndroidRunConfiguration androidConfiguration = (AndroidRunConfiguration)configuration;
            if (androidConfiguration.DEPLOY_APK_FROM_BUNDLE) {
                Preconditions.checkArgument((boolean)androidConfiguration.DEPLOY);
                return true;
            }
        }
        if (minTargetDeviceVersion != null && minTargetDeviceVersion.getFeatureLevel() < 21 && !DynamicAppUtils.getDependentFeatureModulesForBase(module2).isEmpty()) {
            return true;
        }
        return configuration instanceof AndroidTestRunConfiguration && (androidModuleModel = AndroidModuleModel.get(module2)) != null && androidModuleModel.getAndroidProject().getProjectType() == 6;
    }

    public static boolean shouldCollectListOfLanguages(@NotNull Module module2, @NotNull AndroidRunConfigurationBase configuration, @Nullable AndroidVersion minTargetDeviceVersion) {
        if (!DynamicAppUtils.useSelectApksFromBundleBuilder(module2, configuration, minTargetDeviceVersion)) {
            return false;
        }
        return minTargetDeviceVersion == null || minTargetDeviceVersion.getFeatureLevel() >= 21;
    }

    @NotNull
    public static List<Module> getDependentInstantFeatureModules(@NotNull Module module2) {
        AndroidModuleModel androidModule = AndroidModuleModel.get(module2);
        if (androidModule == null) {
            return ImmutableList.of();
        }
        return DynamicAppUtils.getDependentInstantFeatureModules(module2.getProject(), androidModule.getAndroidProject());
    }

    @NotNull
    public static List<Module> getDependentInstantFeatureModules(@NotNull Project project, @NotNull IdeAndroidProject androidProject) {
        Map<String, Module> featureMap = DynamicAppUtils.getDynamicFeaturesMap(project);
        return androidProject.getDynamicFeatures().stream().map(featurePath -> (Module)featureMap.get(featurePath)).filter(Objects::nonNull).filter(f -> AndroidModuleModel.get(f).getSelectedVariant().getInstantAppCompatible()).collect(Collectors.toList());
    }

    public static boolean isFeatureEnabled(@NotNull List<String> myDisabledFeatures, @NotNull ApkFileUnit apkFileUnit) {
        return myDisabledFeatures.stream().noneMatch(m -> DynamicAppUtils.featureNameEquals(apkFileUnit, m));
    }

    public static boolean featureNameEquals(@NotNull ApkFileUnit apkFileUnit, @NotNull String featureName) {
        return StringUtil.equals((CharSequence)featureName.replace('-', '_'), (CharSequence)apkFileUnit.getModuleName());
    }

    @NotNull
    private static Map<String, Module> getDynamicFeaturesMap(@NotNull Project project) {
        return Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).map(module2 -> {
            AndroidModuleModel model2 = AndroidModuleModel.get(module2);
            if (model2 == null) {
                return null;
            }
            if (model2.getAndroidProject().getProjectType() != 6) {
                return null;
            }
            String gradlePath = DynamicAppUtils.getGradlePath(module2);
            if (gradlePath == null) {
                return null;
            }
            return Pair.create((Object)gradlePath, (Object)module2);
        }).filter(Objects::nonNull).collect(Collectors.toMap(p -> (String)p.first, p -> (Module)p.second, DynamicAppUtils::handleModuleAmbiguity));
    }

    @NotNull
    private static List<Module> selectFeatureModules(Stream<Module> moduleStream) {
        return moduleStream.filter(module2 -> {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module2);
            if (androidModuleModel == null) {
                return false;
            }
            int type = androidModuleModel.getAndroidProject().getProjectType();
            return type == 5 || type == 6;
        }).collect(Collectors.toList());
    }

    @Nullable
    private static String getGradlePath(@NotNull Module module2) {
        GradleFacet facet2 = GradleFacet.getInstance(module2);
        if (facet2 == null) {
            return null;
        }
        GradleModuleModel gradleModel = facet2.getGradleModuleModel();
        if (gradleModel == null) {
            return null;
        }
        return gradleModel.getGradlePath();
    }

    @NotNull
    private static Module handleModuleAmbiguity(@NotNull Module m1, @NotNull Module m2) {
        DynamicAppUtils.getLogger().warn(String.format("Unexpected ambiguity processing modules: %s - %s", m1.getName(), m2.getName()));
        return m1;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(DynamicAppUtils.class);
    }
}

