/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.LocalMavenRepository;
import com.android.tools.idea.sdk.IdeSdks;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdkRepositories {
    public static final String ANDROID_REPOSITORY_NAME = "Android Repository";
    public static final String GOOGLE_REPOSITORY_NAME = "Google Repository";

    private AndroidSdkRepositories() {
    }

    @Nullable
    public static ArtifactRepository getAndroidRepository() {
        return AndroidSdkRepositories.getMavenRepository(SdkMavenRepository.ANDROID, ANDROID_REPOSITORY_NAME);
    }

    @Nullable
    public static ArtifactRepository getGoogleRepository() {
        return AndroidSdkRepositories.getMavenRepository(SdkMavenRepository.GOOGLE, GOOGLE_REPOSITORY_NAME);
    }

    @Nullable
    private static ArtifactRepository getMavenRepository(@NotNull SdkMavenRepository repository, @NotNull String name) {
        File location = AndroidSdkRepositories.getRepositoryLocation(repository);
        return location != null ? new LocalMavenRepository(location, name) : null;
    }

    @Nullable
    private static File getRepositoryLocation(@NotNull SdkMavenRepository repository) {
        File androidSdkPath = IdeSdks.getInstance().getAndroidSdkPath();
        return repository.getRepositoryLocation(androidSdkPath, true, FileOpUtils.create());
    }
}

