/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies;

import com.android.tools.idea.gradle.structure.dependencies.AbstractAddDependenciesDialog;
import com.android.tools.idea.gradle.structure.dependencies.AbstractDependencyScopesPanel;
import com.android.tools.idea.gradle.structure.dependencies.DependencyScopePanel;
import com.android.tools.idea.gradle.structure.dependencies.DependencyScopesSelector;
import com.android.tools.idea.gradle.structure.dependencies.ModuleDependenciesForm;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.intellij.openapi.ui.ValidationInfo;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddModuleDependencyDialog
extends AbstractAddDependenciesDialog {
    @NotNull
    public static final String TITLE = "Add Module Dependency";
    private ModuleDependenciesForm myModuleDependenciesForm;

    public AddModuleDependencyDialog(@NotNull PsModule module2) {
        super(module2);
        this.setTitle(TITLE);
        this.init();
    }

    @Override
    public void addNewDependencies() {
        List<PsModule> modules = this.myModuleDependenciesForm.getSelectedModules();
        DependencyScopesSelector scopesPanel = this.getScopesPanel();
        String scopesName = scopesPanel.getSelectedScopeName();
        modules.forEach(module2 -> this.getModule().addModuleDependency(Objects.requireNonNull(module2.getGradlePath()), scopesName));
    }

    @Override
    @NotNull
    protected String getSplitterProportionKey() {
        return "psd.add.module.dependency.main.horizontal.splitter.proportion";
    }

    @Override
    @NotNull
    protected JComponent getDependencySelectionView() {
        if (this.myModuleDependenciesForm == null) {
            this.myModuleDependenciesForm = new ModuleDependenciesForm(this.getModule());
        }
        return this.myModuleDependenciesForm.getPanel();
    }

    @Override
    @NotNull
    protected String getInstructions() {
        return "Please select the modules to add as dependencies.";
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "psd.add.module.dependency.panel.dimension";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.myModuleDependenciesForm != null) {
            return this.myModuleDependenciesForm.getPreferredFocusedComponent();
        }
        return null;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        List<PsModule> modules = this.myModuleDependenciesForm.getSelectedModules();
        if (modules.isEmpty()) {
            return new ValidationInfo("Select at least one module", this.myModuleDependenciesForm.getPreferredFocusedComponent());
        }
        return this.getScopesPanel().validateInput();
    }

    @Override
    @NotNull
    protected AbstractDependencyScopesPanel createDependencyScopesPanel(@NotNull PsModule module2) {
        return new DependencyScopePanel(module2, PsModule.ImportantFor.MODULE);
    }
}

