/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.daemon.AvailableLibraryUpdateStorage;
import com.android.tools.idea.gradle.structure.daemon.PsAnalyzerDaemonKt;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsLibraryUpdateCheckerDaemon;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModelAnalyzer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDeclaredLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsGeneralIssue;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.meta.DslText;
import com.android.tools.idea.gradle.structure.model.meta.ModelPropertyCore;
import com.android.tools.idea.gradle.structure.model.meta.ParsedValue;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.android.tools.idea.gradle.structure.quickfix.PsLibraryDependencyVersionQuickFixPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003<=>B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001e\u0010\b\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\t\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0007J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0003J\b\u0010,\u001a\u00020\u001fH\u0003J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0003J\u001e\u0010.\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\b\u0001\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001f00J\u001e\u00101\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\b\u0001\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001f00J\u0010\u00102\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\fH\u0007J\b\u00103\u001a\u00020\u001fH\u0007J\b\u00104\u001a\u00020\u001fH\u0003J$\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u0002072\n\b\u0002\u00108\u001a\u0004\u0018\u0001092\u0006\u0010#\u001a\u00020$H\u0002J\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020\"0;2\u0006\u0010&\u001a\u00020'R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0015\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR&\u0010\b\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u001b\u001a\u0015\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001a\u00a8\u0006?"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon;", "Lcom/android/tools/idea/gradle/structure/daemon/PsDaemon;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/android/tools/idea/gradle/structure/model/PsProject;", "libraryUpdateCheckerDaemon", "Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;", "modelAnalyzers", "", "Ljava/lang/Class;", "Lcom/android/tools/idea/gradle/structure/daemon/analysis/PsModelAnalyzer;", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/gradle/structure/model/PsProject;Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;Ljava/util/Map;)V", "issues", "Lcom/android/tools/idea/gradle/structure/model/PsIssueCollection;", "getIssues", "()Lcom/android/tools/idea/gradle/structure/model/PsIssueCollection;", "issuesUpdatedEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$IssuesUpdatedListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "mainQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getMainQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "onRunningEventDispatcher", "resultsUpdaterQueue", "getResultsUpdaterQueue", "addAll", "", "newIssues", "", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "now", "", "doAnalyzeStructure", "model", "Lcom/android/tools/idea/gradle/structure/model/PsModel;", "getAvailableUpdatesFor", "Lcom/android/tools/idea/gradle/structure/model/PsGeneralIssue;", "dependency", "Lcom/android/tools/idea/gradle/structure/model/PsDeclaredLibraryDependency;", "notifyRunning", "notifyUpdated", "onIssuesChange", "listener", "Lkotlin/Function0;", "onRunningChange", "queueCheck", "recreateUpdateIssues", "recreateUpdatesAsIssues", "removeIssues", "type", "Lcom/android/tools/idea/gradle/structure/model/PsIssueType;", "byPath", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "validate", "Lkotlin/sequences/Sequence;", "AnalyzeModuleStructure", "IssuesComputed", "IssuesUpdatedListener", "intellij.android.projectSystem.gradle.psd"})
public final class PsAnalyzerDaemon
extends PsDaemon {
    @NotNull
    private final MergingUpdateQueue mainQueue;
    @NotNull
    private final MergingUpdateQueue resultsUpdaterQueue;
    @NotNull
    private final PsIssueCollection issues;
    private final EventDispatcher<IssuesUpdatedListener> onRunningEventDispatcher;
    private final EventDispatcher<IssuesUpdatedListener> issuesUpdatedEventDispatcher;
    private final PsProject project;
    private final PsLibraryUpdateCheckerDaemon libraryUpdateCheckerDaemon;
    private final Map<Class<?>, PsModelAnalyzer<? extends PsModule>> modelAnalyzers;

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        return this.mainQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        return this.resultsUpdaterQueue;
    }

    @NotNull
    public final PsIssueCollection getIssues() {
        return this.issues;
    }

    @UiThread
    public final void recreateUpdateIssues() {
        this.libraryUpdateCheckerDaemon.queueUpdateCheck();
    }

    /*
     * WARNING - void declaration
     */
    @UiThread
    private final void recreateUpdatesAsIssues() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        PsAnalyzerDaemon.removeIssues$default(this, PsIssueType.LIBRARY_UPDATES_AVAILABLE, null, true, 2, null);
        Iterable iterable = this.project.getModules();
        PsAnalyzerDaemon psAnalyzerDaemon = this;
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            PsModule module2 = (PsModule)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = module2.getDependencies().getLibraries();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsGeneralIssue psGeneralIssue;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                PsDeclaredLibraryDependency it = (PsDeclaredLibraryDependency)element$iv$iv2;
                boolean bl3 = false;
                if (this.getAvailableUpdatesFor(it) == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                PsGeneralIssue it$iv$iv = psGeneralIssue;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        psAnalyzerDaemon.addAll(list, false);
        this.notifyRunning();
    }

    @UiThread
    private final PsGeneralIssue getAvailableUpdatesFor(PsDeclaredLibraryDependency dependency) {
        AvailableLibraryUpdateStorage results = this.libraryUpdateCheckerDaemon.getAvailableLibraryUpdateStorage();
        PsArtifactDependencySpec spec = dependency.getSpec();
        GradleVersion gradleVersion2 = results.findUpdatedVersionFor(spec);
        if (gradleVersion2 == null) {
            return null;
        }
        GradleVersion versionToUpdateTo = gradleVersion2;
        String text2 = "Newer version available: <b>" + versionToUpdateTo + "<b>";
        PsLibraryDependencyNavigationPath mainPath = dependency.getPath();
        ParsedValue versionValue = ((ModelPropertyCore)dependency.getVersionProperty().bind(Unit.INSTANCE)).getParsedValue().getValue();
        boolean valueIsReference = versionValue instanceof ParsedValue.Set.Parsed && ((ParsedValue.Set.Parsed)versionValue).getDslText() instanceof DslText.Reference;
        return new PsGeneralIssue(text2, "", mainPath, PsIssueType.LIBRARY_UPDATES_AVAILABLE, PsIssue.Severity.UPDATE, !valueIsReference ? CollectionsKt.listOf((Object)new PsLibraryDependencyVersionQuickFixPath(dependency, versionToUpdateTo.toString(), null, 4, null)) : CollectionsKt.listOf((Object[])new PsLibraryDependencyVersionQuickFixPath[]{new PsLibraryDependencyVersionQuickFixPath(dependency, versionToUpdateTo.toString(), true), new PsLibraryDependencyVersionQuickFixPath(dependency, versionToUpdateTo.toString(), false)}));
    }

    public final void onIssuesChange(@NotNull Disposable parentDisposable, @UiThread @NotNull Function0<Unit> listener2) {
        this.issuesUpdatedEventDispatcher.addListener((EventListener)new IssuesUpdatedListener(listener2){
            final /* synthetic */ Function0 $listener;

            public void issuesUpdated() {
                this.$listener.invoke();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        }, parentDisposable);
    }

    public final void onRunningChange(@NotNull Disposable parentDisposable, @UiThread @NotNull Function0<Unit> listener2) {
        this.onRunningEventDispatcher.addListener((EventListener)new IssuesUpdatedListener(listener2){
            final /* synthetic */ Function0 $listener;

            public void issuesUpdated() {
                this.$listener.invoke();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        }, parentDisposable);
    }

    @UiThread
    public final void queueCheck(@NotNull PsModule model2) {
        this.removeIssues(PsIssueType.PROJECT_ANALYSIS, model2.getPath(), false);
        this.getMainQueue().queue((Update)new AnalyzeModuleStructure(model2));
        this.notifyRunning();
    }

    @NotNull
    public final Sequence<PsIssue> validate(@NotNull PsModel model2) {
        Sequence<PsIssue> sequence;
        block5: {
            block4: {
                sequence = this.modelAnalyzers.get(model2.getClass());
                if (sequence == null) break block4;
                Sequence<PsIssue> $this$cast$iv = sequence;
                boolean $i$f$cast = false;
                Sequence<PsIssue> sequence2 = $this$cast$iv;
                if (sequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.gradle.structure.daemon.analysis.PsModelAnalyzer<com.android.tools.idea.gradle.structure.model.PsModel>");
                }
                sequence = sequence2;
                if (sequence2 != null && (sequence = sequence.analyze((PsIssue)((Object)model2))) != null) break block5;
            }
            sequence = SequencesKt.sequenceOf((Object[])new PsIssue[0]);
        }
        return sequence;
    }

    private final void doAnalyzeStructure(PsModel model2) {
        PsModelAnalyzer<? extends PsModule> analyzer;
        PsModelAnalyzer<? extends PsModule> psModelAnalyzer;
        PsModelAnalyzer<? extends PsModule> psModelAnalyzer2 = this.modelAnalyzers.get(model2.getClass());
        if (psModelAnalyzer2 != null) {
            PsModelAnalyzer<? extends PsModule> $this$cast$iv = psModelAnalyzer2;
            boolean $i$f$cast = false;
            psModelAnalyzer = $this$cast$iv;
            if (psModelAnalyzer == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.gradle.structure.daemon.analysis.PsModelAnalyzer<com.android.tools.idea.gradle.structure.model.PsModel>");
            }
        } else {
            psModelAnalyzer = null;
        }
        if ((analyzer = psModelAnalyzer) == null) {
            PsAnalyzerDaemonKt.access$getLOG$p().info("Failed to find analyzer for model of type " + model2.getClass().getName());
            return;
        }
        if (!this.isStopped()) {
            boolean bl = analyzer.getSupportedModelType().isInstance(model2);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(this, analyzer, model2){
                final /* synthetic */ PsAnalyzerDaemon this$0;
                final /* synthetic */ PsModelAnalyzer $analyzer;
                final /* synthetic */ PsModel $model;

                public final void invoke() {
                    List newIssues = !this.this$0.isStopped() && !this.$analyzer.getDisposed() ? SequencesKt.toList(this.$analyzer.analyze((PsModel)this.$analyzer.getSupportedModelType().cast(this.$model))) : CollectionsKt.emptyList();
                    this.this$0.addAll(newIssues, false);
                }
                {
                    this.this$0 = psAnalyzerDaemon;
                    this.$analyzer = psModelAnalyzer;
                    this.$model = psModel;
                    super(0);
                }
            }));
        }
        this.getResultsUpdaterQueue().queue((Update)new IssuesComputed());
    }

    private final void removeIssues(PsIssueType type, PsPath byPath, boolean now) {
        this.issues.remove(type, byPath);
        this.notifyUpdated(now);
    }

    static /* synthetic */ void removeIssues$default(PsAnalyzerDaemon psAnalyzerDaemon, PsIssueType psIssueType, PsPath psPath, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            psPath = null;
        }
        psAnalyzerDaemon.removeIssues(psIssueType, psPath, bl);
    }

    /*
     * WARNING - void declaration
     */
    @UiThread
    public final void addAll(@NotNull List<? extends PsIssue> newIssues, boolean now) {
        void $this$forEach$iv;
        Iterable iterable = newIssues;
        PsIssueCollection psIssueCollection = this.issues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsIssue p1 = (PsIssue)element$iv;
            boolean bl = false;
            psIssueCollection.add(p1);
        }
        this.notifyUpdated(now);
    }

    @AnyThread
    private final void notifyUpdated(boolean now) {
        if (now) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ((IssuesUpdatedListener)this.issuesUpdatedEventDispatcher.getMulticaster()).issuesUpdated();
        } else {
            this.getResultsUpdaterQueue().queue((Update)new IssuesComputed());
        }
    }

    @UiThread
    private final void notifyRunning() {
        ((IssuesUpdatedListener)this.onRunningEventDispatcher.getMulticaster()).issuesUpdated();
    }

    public PsAnalyzerDaemon(@NotNull Disposable parentDisposable, @NotNull PsProject project, @NotNull PsLibraryUpdateCheckerDaemon libraryUpdateCheckerDaemon, @NotNull Map<Class<?>, ? extends PsModelAnalyzer<? extends PsModule>> modelAnalyzers) {
        super(parentDisposable);
        this.project = project;
        this.libraryUpdateCheckerDaemon = libraryUpdateCheckerDaemon;
        this.modelAnalyzers = modelAnalyzers;
        this.mainQueue = this.createQueue("Project Structure Daemon Analyzer", null);
        this.resultsUpdaterQueue = this.createQueue("Project Structure Analysis Results Updater", MergingUpdateQueue.ANY_COMPONENT);
        this.issues = new PsIssueCollection();
        this.onRunningEventDispatcher = EventDispatcher.create(IssuesUpdatedListener.class);
        this.issuesUpdatedEventDispatcher = EventDispatcher.create(IssuesUpdatedListener.class);
        this.libraryUpdateCheckerDaemon.add((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.recreateUpdatesAsIssues();
            }
        }), this);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$AnalyzeModuleStructure;", "Lcom/intellij/util/ui/update/Update;", "myModel", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon;Lcom/android/tools/idea/gradle/structure/model/PsModule;)V", "run", "", "intellij.android.projectSystem.gradle.psd"})
    private final class AnalyzeModuleStructure
    extends Update {
        private final PsModule myModel;

        public void run() {
            try {
                if (!this.isDisposed() && !PsAnalyzerDaemon.this.isStopped()) {
                    PsAnalyzerDaemon.this.doAnalyzeStructure(this.myModel);
                }
            }
            catch (Throwable e) {
                PsAnalyzerDaemonKt.access$getLOG$p().error("Failed to analyze " + this.myModel, e);
            }
        }

        public AnalyzeModuleStructure(PsModule myModel) {
            super((Object)myModel);
            this.myModel = myModel;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$IssuesComputed;", "Lcom/intellij/util/ui/update/Update;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon;)V", "run", "", "intellij.android.projectSystem.gradle.psd"})
    private final class IssuesComputed
    extends Update {
        @UiThread
        public void run() {
            ((IssuesUpdatedListener)PsAnalyzerDaemon.this.issuesUpdatedEventDispatcher.getMulticaster()).issuesUpdated();
        }

        public IssuesComputed() {
            super(IssuesComputed.class);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$IssuesUpdatedListener;", "Ljava/util/EventListener;", "issuesUpdated", "", "intellij.android.projectSystem.gradle.psd"})
    private static interface IssuesUpdatedListener
    extends EventListener {
        public void issuesUpdated();
    }
}

