/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionChangeEventDispatcher<T> {
    @NotNull
    private List<SelectionChangeListener<T>> myListeners = new CopyOnWriteArrayList<SelectionChangeListener<T>>();

    public void addListener(@NotNull SelectionChangeListener<T> listener2, @NotNull Disposable parentDisposable) {
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myListeners.remove(listener2));
    }

    public void selectionChanged(@Nullable T newSelection) {
        this.myListeners.forEach(listener2 -> listener2.selectionChanged(newSelection));
    }
}

