/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.adtui.HtmlLabel;
import com.android.tools.idea.gradle.structure.configurables.issues.DependencyViewIssuesRenderer;
import com.android.tools.idea.gradle.structure.configurables.issues.NavigationHyperlinkListener;
import com.android.tools.idea.gradle.structure.configurables.ui.CollapsiblePanel;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssuesViewerPanel
extends CollapsiblePanel {
    @VisibleForTesting
    public PsIssue.Severity mySeverity;
    private List<PsIssue> myIssues;
    @VisibleForTesting
    public JEditorPane issuesView = new JEditorPane();
    private static final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ((IssuesViewerPanel)evt.getSource()).updateTitle();
        }
    };

    public IssuesViewerPanel(@NotNull NavigationHyperlinkListener hyperlinkListener2, @NotNull Font font) {
        super("");
        this.issuesView.setFocusable(false);
        this.issuesView.addHyperlinkListener((HyperlinkListener)((Object)hyperlinkListener2));
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.issuesView, (Font)font);
        this.setContents(this.issuesView);
        this.addPropertyChangeListener("expanded", propertyChangeListener);
    }

    public void displayIssues(@Nullable PsPath path2, @NotNull DependencyViewIssuesRenderer renderer2, @NotNull PsIssue.Severity severity, @NotNull List<PsIssue> issues) {
        this.mySeverity = severity;
        this.myIssues = issues;
        this.issuesView.setText(renderer2.render(issues, path2));
        this.issuesView.setCaretPosition(0);
        this.updateTitle();
    }

    public void updateTitle() {
        SimpleColoredComponent title = this.getTitleComponent();
        title.clear();
        title.setIcon(this.mySeverity.getIcon());
        title.append(this.mySeverity.getText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        int issueCount = this.myIssues.size();
        if (!this.isExpanded()) {
            title.append(" (" + issueCount + " item" + (issueCount == 1 ? "" : "s") + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }
}

