/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.actions;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowStructureSettingsAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import org.jetbrains.annotations.NotNull;

public class AndroidShowStructureSettingsAction
extends ShowStructureSettingsAction {
    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project != null) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabledAndVisible(true);
            presentation.setIcon(AllIcons.General.ProjectStructure);
            presentation.setText(ActionsBundle.actionText((String)"ShowProjectStructureSettings"));
            presentation.setDescription(ActionsBundle.actionDescription((String)"ShowProjectStructureSettings"));
        }
        super.update(e);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null && IdeInfo.getInstance().isAndroidStudio()) {
            project = ProjectManager.getInstance().getDefaultProject();
            AndroidShowStructureSettingsAction.showAndroidProjectStructure(project);
            return;
        }
        if (project != null && GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            AndroidShowStructureSettingsAction.showAndroidProjectStructure(project);
            return;
        }
        super.actionPerformed(e);
    }

    private static void showAndroidProjectStructure(@NotNull Project project) {
        ProjectStructureConfigurable.getInstance(project).show();
    }
}

