/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.util.BuildMode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.tooling.BuildAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GradleTaskRunner {
    public boolean run(@NotNull ListMultimap<Path, String> var1, @Nullable BuildMode var2, @NotNull List<String> var3) throws InvocationTargetException, InterruptedException;

    @NotNull
    public static DefaultGradleTaskRunner newRunner(@NotNull Project project, @Nullable BuildAction<?> buildAction) {
        return new DefaultGradleTaskRunner(project, buildAction);
    }

    public static class DefaultGradleTaskRunner
    implements GradleTaskRunner {
        @NotNull
        private final Project myProject;
        @NotNull
        private final AtomicReference<Object> model = new AtomicReference();
        @Nullable
        final BuildAction<?> myBuildAction;

        DefaultGradleTaskRunner(@NotNull Project project, @Nullable BuildAction<?> buildAction) {
            this.myProject = project;
            this.myBuildAction = buildAction;
        }

        @Override
        @WorkerThread
        public boolean run(@NotNull ListMultimap<Path, String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments) {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            final GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(this.myProject);
            final AtomicBoolean success2 = new AtomicBoolean();
            final CountDownLatch done = new CountDownLatch(1);
            GradleBuildInvoker.AfterGradleInvocationTask afterTask = new GradleBuildInvoker.AfterGradleInvocationTask(){

                @Override
                public void execute(@NotNull GradleInvocationResult result2) {
                    success2.set(result2.isBuildSuccessful());
                    model.set(result2.getModel());
                    gradleBuildInvoker.remove(this);
                    done.countDown();
                }
            };
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    done.countDown();
                    return;
                }
                gradleBuildInvoker.add(afterTask);
                gradleBuildInvoker.executeTasks(tasks, buildMode, commandLineArguments, this.myBuildAction);
            });
            try {
                done.await();
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException();
            }
            return success2.get();
        }

        @Nullable
        public Object getModel() {
            return this.model.get();
        }

        @VisibleForTesting
        @Nullable
        BuildAction<?> getBuildAction() {
            return this.myBuildAction;
        }
    }
}

