/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.repositories;

import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.repositories.IdeGoogleMavenRepository;
import com.android.tools.idea.gradle.repositories.OfflineIdeGoogleMavenRepository;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManagerKt;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleLocalCache;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 /2\u00020\u0001:\u0001/B\u0007\b\u0010\u00a2\u0006\u0002\u0010\u0002B)\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J8\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u001f2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00162\u0006\u0010 \u001a\u00020\u0007J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007J8\u0010!\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J$\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010%\u001a\u00020\u000f2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)J$\u0010*\u001a\u0004\u0018\u00010\f2\u0006\u0010%\u001a\u00020\u000f2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)J2\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0-2\b\u0010.\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/idea/gradle/repositories/RepositoryUrlManager;", "", "()V", "googleMavenRepository", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "cachedGoogleMavenRepository", "forceRepositoryChecksInTests", "", "useEmbeddedStudioRepo", "(Lcom/android/ide/common/repository/GoogleMavenRepository;Lcom/android/ide/common/repository/GoogleMavenRepository;ZZ)V", "pendingNetworkRequests", "", "", "findCompileDependencies", "", "Lcom/android/ide/common/repository/GradleCoordinate;", "groupId", "artifactId", "version", "Lcom/android/ide/common/repository/GradleVersion;", "findVersion", "filter", "Ljava/util/function/Predicate;", "includePreviews", "fileOp", "Lcom/android/repository/io/FileOp;", "getArchiveForCoordinate", "Ljava/io/File;", "gradleCoordinate", "sdkLocation", "getArtifactStringCoordinate", "Lcom/android/tools/idea/projectsystem/GoogleMavenArtifactId;", "preview", "getLibraryRevision", "refreshCacheInBackground", "", "resolveDynamicCoordinate", "coordinate", "project", "Lcom/intellij/openapi/project/Project;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "resolveDynamicCoordinateVersion", "resolveDynamicSdkDependencies", "dependencies", "Lcom/google/common/collect/Multimap;", "supportLibVersionFilter", "Companion", "intellij.android.core"})
public final class RepositoryUrlManager {
    private final Set<String> pendingNetworkRequests;
    private final GoogleMavenRepository googleMavenRepository;
    private final GoogleMavenRepository cachedGoogleMavenRepository;
    private final boolean forceRepositoryChecksInTests;
    private final boolean useEmbeddedStudioRepo;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getArtifactStringCoordinate(@NotNull GoogleMavenArtifactId artifactId, boolean preview) {
        return this.getArtifactStringCoordinate(artifactId, null, preview);
    }

    @Nullable
    public final String getArtifactStringCoordinate(@NotNull GoogleMavenArtifactId artifactId, @Nullable Predicate<GradleVersion> filter2, boolean preview) {
        String string = this.getLibraryRevision(artifactId.getMavenGroupId(), artifactId.getMavenArtifactId(), filter2, preview, FileOpUtils.create());
        if (string == null) {
            return null;
        }
        String revision = string;
        return artifactId.getCoordinate(revision).toString();
    }

    @Nullable
    public final String getLibraryRevision(@NotNull String groupId, @NotNull String artifactId, @Nullable Predicate<GradleVersion> filter2, boolean includePreviews, @NotNull FileOp fileOp) {
        GradleVersion gradleVersion2 = this.findVersion(groupId, artifactId, filter2, includePreviews, fileOp);
        return gradleVersion2 != null ? gradleVersion2.toString() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final GradleVersion findVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Predicate<GradleVersion> filter2, boolean includePreviews, @NotNull FileOp fileOp) {
        GradleVersion version2 = null;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            version2 = this.cachedGoogleMavenRepository.findVersion(groupId, artifactId, filter2, includePreviews);
            this.refreshCacheInBackground(groupId, artifactId);
        } else {
            version2 = this.googleMavenRepository.findVersion(groupId, artifactId, filter2, includePreviews);
        }
        if (version2 != null) {
            return version2;
        }
        if (this.useEmbeddedStudioRepo) {
            GradleCoordinate gradleCoordinate;
            block6: {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    File it = (File)element$iv$iv;
                    boolean bl = false;
                    File file2 = it;
                    if (!(file2 != null && file2.isDirectory())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$firstNotNullResult$iv = (List)destination$iv$iv;
                boolean $i$f$firstNotNullResult = false;
                for (Object element$iv : $this$firstNotNullResult$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    GradleCoordinate result$iv = MavenRepositories.getHighestInstalledVersion((String)groupId, (String)artifactId, (File)it, filter2, (boolean)includePreviews, (FileOp)fileOp);
                    if (result$iv == null) continue;
                    gradleCoordinate = result$iv;
                    break block6;
                }
                gradleCoordinate = null;
            }
            return gradleCoordinate != null ? gradleCoordinate.getVersion() : null;
        }
        return null;
    }

    @NotNull
    public final List<GradleCoordinate> findCompileDependencies(@NotNull String groupId, @NotNull String artifactId, @NotNull GradleVersion version2) {
        List result2 = null;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            result2 = this.cachedGoogleMavenRepository.findCompileDependencies(groupId, artifactId, version2);
            this.refreshCacheInBackground(groupId, artifactId);
        } else {
            result2 = this.googleMavenRepository.findCompileDependencies(groupId, artifactId, version2);
        }
        return result2;
    }

    @Nullable
    public final File getArchiveForCoordinate(@NotNull GradleCoordinate gradleCoordinate, @NotNull File sdkLocation, @NotNull FileOp fileOp) {
        File artifactDirectory;
        String groupId = gradleCoordinate.getGroupId();
        String artifactId = gradleCoordinate.getArtifactId();
        SdkMavenRepository sdkMavenRepository = SdkMavenRepository.find((File)sdkLocation, (String)groupId, (String)artifactId, (FileOp)fileOp);
        if (sdkMavenRepository == null) {
            return null;
        }
        SdkMavenRepository repository = sdkMavenRepository;
        File file2 = repository.getRepositoryLocation(sdkLocation, true, fileOp);
        if (file2 == null) {
            return null;
        }
        File repositoryLocation = file2;
        File file3 = artifactDirectory = MavenRepositories.getArtifactDirectory((File)repositoryLocation, (GradleCoordinate)gradleCoordinate);
        if (file3 == null) {
            Intrinsics.throwNpe();
        }
        if (!fileOp.isDirectory(file3)) {
            return null;
        }
        for (GradleCoordinate.ArtifactType artifactType : ImmutableList.of((Object)GradleCoordinate.ArtifactType.JAR, (Object)GradleCoordinate.ArtifactType.AAR)) {
            File archive = new File(artifactDirectory, artifactId + '-' + gradleCoordinate.getRevision() + '.' + artifactType);
            if (!fileOp.isFile(archive)) continue;
            return archive;
        }
        return null;
    }

    @Nullable
    public final GradleCoordinate resolveDynamicCoordinate(@NotNull GradleCoordinate coordinate, @Nullable Project project, @Nullable AndroidSdkHandler sdkHandler) {
        AndroidSdkHandler androidSdkHandler = sdkHandler;
        if (androidSdkHandler == null) {
            androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        }
        String string = this.resolveDynamicCoordinateVersion(coordinate, project, androidSdkHandler);
        if (string == null) {
            return null;
        }
        String version2 = string;
        List revisions = GradleCoordinate.parseRevisionNumber((String)version2);
        Collection collection2 = revisions;
        boolean bl = false;
        if (!collection2.isEmpty()) {
            return new GradleCoordinate(coordinate.getGroupId(), coordinate.getArtifactId(), revisions, coordinate.getArtifactType());
        }
        return null;
    }

    @Nullable
    public final String resolveDynamicCoordinateVersion(@NotNull GradleCoordinate coordinate, @Nullable Project project, @Nullable AndroidSdkHandler sdkHandler) {
        GradleCoordinate found;
        GradleVersion versionFound;
        AndroidSdkHandler androidSdkHandler = sdkHandler;
        if (androidSdkHandler == null) {
            androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        }
        AndroidSdkHandler sdkHandler2 = androidSdkHandler;
        String revision = coordinate.getRevision();
        if (!StringsKt.endsWith$default((String)revision, (String)"+", (boolean)false, (int)2, null)) {
            return revision;
        }
        String string = revision;
        int n = 0;
        int n2 = revision.length() - 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String versionPrefix = string3;
        Predicate filter2 = new Predicate<GradleVersion>(versionPrefix){
            final /* synthetic */ String $versionPrefix;

            public final boolean test(@NotNull GradleVersion version2) {
                return StringsKt.startsWith$default((String)version2.toString(), (String)this.$versionPrefix, (boolean)false, (int)2, null);
            }
            {
                this.$versionPrefix = string;
            }
        };
        String groupId = coordinate.getGroupId();
        String artifactId = coordinate.getArtifactId();
        GoogleMavenRepository bestAvailableGoogleMavenRepo = null;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            bestAvailableGoogleMavenRepo = this.cachedGoogleMavenRepository;
            this.refreshCacheInBackground(groupId, artifactId);
        } else {
            bestAvailableGoogleMavenRepo = this.googleMavenRepository;
        }
        GradleVersion stable = bestAvailableGoogleMavenRepo.findVersion(groupId, artifactId, filter2, false);
        if (stable != null) {
            return stable.toString();
        }
        GradleVersion version2 = bestAvailableGoogleMavenRepo.findVersion(groupId, artifactId, filter2, true);
        if (version2 != null) {
            return version2.toString();
        }
        File sdkLocation = sdkHandler2.getLocation();
        if (sdkLocation != null) {
            String libraryCoordinate = this.getLibraryRevision(groupId, artifactId, filter2, false, sdkHandler2.getFileOp());
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
            libraryCoordinate = this.getLibraryRevision(groupId, artifactId, filter2, true, sdkHandler2.getFileOp());
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
        }
        if ((versionFound = GradleLocalCache.getInstance().findLatestArtifactVersion(coordinate, project, revision)) != null) {
            return versionFound.toString();
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        RemotePackage sdkPackage = SdkMavenRepository.findLatestRemoteVersion((GradleCoordinate)coordinate, (AndroidSdkHandler)sdkHandler2, (Predicate)filter2, (ProgressIndicator)((ProgressIndicator)progress));
        if (sdkPackage != null && (found = SdkMavenRepository.getCoordinateFromSdkPath((String)sdkPackage.getPath())) != null) {
            return found.getRevision();
        }
        if (project == null) {
            return null;
        }
        LintClient client = (LintClient)LintIdeSupport.createClient$default((LintIdeSupport)LintIdeSupport.Companion.get(), (Project)project, null, (int)2, null);
        Object object = GradleDetector.Companion.getLatestVersionFromRemoteRepo(client, coordinate, filter2, coordinate.isPreview());
        if (object == null || (object = object.toString()) == null) {
            return null;
        }
        Object latest = object;
        if (StringsKt.startsWith$default((String)latest, (String)versionPrefix, (boolean)false, (int)2, null)) {
            return latest;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GradleCoordinate> resolveDynamicSdkDependencies(@NotNull Multimap<String, GradleCoordinate> dependencies2, @Nullable String supportLibVersionFilter, @NotNull FileOp fileOp) {
        boolean bl = false;
        List result2 = new ArrayList();
        String string = RepositoryUrlManagerKt.access$findExistingExplicitVersion(dependencies2.values());
        if (string == null) {
            string = supportLibVersionFilter;
        }
        String supportFilter = string;
        for (String key : dependencies2.keySet()) {
            void revision;
            Object object = CollectionsKt.maxWith((Iterable)dependencies2.get((Object)key), (Comparator)GradleCoordinate.COMPARE_PLUS_LOWER);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            GradleCoordinate highest = (GradleCoordinate)object;
            if (!this.forceRepositoryChecksInTests && ApplicationManager.getApplication().isUnitTestMode()) {
                result2.add(highest);
                continue;
            }
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = highest.getRevision();
            String string2 = (String)revision.element;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.endsWith$default((String)string2, (String)"+", (boolean)false, (int)2, null)) {
                String libraryCoordinate;
                GradleCoordinate available;
                String string3;
                void v3 = revision;
                if (((String)revision.element).length() > 1) {
                    string3 = StringsKt.dropLast((String)((String)revision.element), (int)1);
                } else {
                    String string4 = supportFilter;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String string5 = string4;
                    void var15_18 = v3;
                    boolean bl4 = false;
                    boolean bl5 = Intrinsics.areEqual((Object)"com.android.support", (Object)highest.getGroupId()) || Intrinsics.areEqual((Object)"androidx.core", (Object)highest.getGroupId());
                    v3 = var15_18;
                    string3 = bl5 ? string4 : null;
                }
                v3.element = string3;
                Predicate filter2 = (String)revision.element != null ? (Predicate)new Predicate<GradleVersion>((Ref.ObjectRef)revision){
                    final /* synthetic */ Ref.ObjectRef $revision;

                    public final boolean test(@NotNull GradleVersion version2) {
                        return StringsKt.startsWith$default((String)version2.toString(), (String)((String)this.$revision.element), (boolean)false, (int)2, null);
                    }
                    {
                        this.$revision = objectRef;
                    }
                } : null;
                String version2 = null;
                if (filter2 != null) {
                    version2 = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), filter2, false, fileOp);
                }
                if (version2 == null && filter2 != null) {
                    version2 = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), filter2, true, fileOp);
                }
                if (version2 == null) {
                    version2 = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), null, false, fileOp);
                }
                if (version2 == null) {
                    version2 = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), null, true, fileOp);
                }
                if (version2 != null && (available = GradleCoordinate.parseCoordinateString((String)(libraryCoordinate = highest.getId() + ":" + version2))) != null && GradleCoordinate.COMPARE_PLUS_LOWER.compare(available, highest) >= 0) {
                    highest = available;
                }
            }
            result2.add(highest);
        }
        return result2;
    }

    private final void refreshCacheInBackground(String groupId, String artifactId) {
        String searchKey = groupId + ':' + artifactId;
        if (this.pendingNetworkRequests.add(searchKey)) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, groupId, artifactId, searchKey){
                final /* synthetic */ RepositoryUrlManager this$0;
                final /* synthetic */ String $groupId;
                final /* synthetic */ String $artifactId;
                final /* synthetic */ String $searchKey;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    try {
                        RepositoryUrlManager.access$getGoogleMavenRepository$p(this.this$0).findVersion(this.$groupId, this.$artifactId, (Function1)refreshCacheInBackground.1.INSTANCE, true);
                    }
                    finally {
                        RepositoryUrlManager.access$getPendingNetworkRequests$p(this.this$0).remove(this.$searchKey);
                    }
                }
                {
                    this.this$0 = repositoryUrlManager2;
                    this.$groupId = string;
                    this.$artifactId = string2;
                    this.$searchKey = string3;
                }
            });
        }
    }

    @NonInjectable
    @VisibleForTesting
    public RepositoryUrlManager(@NotNull GoogleMavenRepository googleMavenRepository, @NotNull GoogleMavenRepository cachedGoogleMavenRepository, boolean forceRepositoryChecksInTests, boolean useEmbeddedStudioRepo) {
        this.googleMavenRepository = googleMavenRepository;
        this.cachedGoogleMavenRepository = cachedGoogleMavenRepository;
        this.forceRepositoryChecksInTests = forceRepositoryChecksInTests;
        this.useEmbeddedStudioRepo = useEmbeddedStudioRepo;
        this.pendingNetworkRequests = ConcurrentHashMap.newKeySet();
    }

    public /* synthetic */ RepositoryUrlManager(GoogleMavenRepository googleMavenRepository, GoogleMavenRepository googleMavenRepository2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        this(googleMavenRepository, googleMavenRepository2, bl, bl2);
    }

    public RepositoryUrlManager() {
        this(IdeGoogleMavenRepository.INSTANCE, OfflineIdeGoogleMavenRepository.INSTANCE, false, false, 8, null);
    }

    public static final /* synthetic */ GoogleMavenRepository access$getGoogleMavenRepository$p(RepositoryUrlManager $this) {
        return $this.googleMavenRepository;
    }

    public static final /* synthetic */ Set access$getPendingNetworkRequests$p(RepositoryUrlManager $this) {
        return $this.pendingNetworkRequests;
    }

    @JvmStatic
    @NotNull
    public static final RepositoryUrlManager get() {
        return Companion.get();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/gradle/repositories/RepositoryUrlManager$Companion;", "", "()V", "get", "Lcom/android/tools/idea/gradle/repositories/RepositoryUrlManager;", "intellij.android.core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final RepositoryUrlManager get() {
            return (RepositoryUrlManager)ServiceManager.getService(RepositoryUrlManager.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

