/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.adtui.HtmlLabel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.PropertyBasedDoNotAskOption;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.project.upgrade.RecommendedUpgradeReminder;
import com.android.tools.idea.gradle.project.upgrade.UpgradeDialogMetricUtilsKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradlePluginUpgradeDialogStats;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecommendedPluginVersionUpgradeDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleVersion myCurrentPluginVersion;
    @NotNull
    private final GradleVersion myRecommendedPluginVersion;
    @NotNull
    private final RecommendedUpgradeReminder myUpgradeReminder;
    @NotNull
    private final PropertyBasedDoNotAskOption myDoNotAskOption;
    private JPanel myCenterPanel;
    private JEditorPane myMessagePane;
    private JButton[] myButtons;

    @VisibleForTesting
    RecommendedPluginVersionUpgradeDialog(@NotNull Project project, @NotNull GradleVersion current, @NotNull GradleVersion recommended, @NotNull RecommendedUpgradeReminder upgradeReminder) {
        super(project);
        this.myProject = project;
        this.myCurrentPluginVersion = current;
        this.myRecommendedPluginVersion = recommended;
        this.myUpgradeReminder = upgradeReminder;
        this.$$$setupUI$$$();
        if (((Boolean)StudioFlags.AGP_UPGRADE_ASSISTANT.get()).booleanValue()) {
            this.setTitle("Android Gradle Plugin Upgrade Assistant");
        } else {
            this.setTitle("Android Gradle Plugin Update Recommended");
        }
        this.myDoNotAskOption = new PropertyBasedDoNotAskOption(project, upgradeReminder.getDoNotAskForProjectPropertyString()){

            @Override
            @NotNull
            public String getDoNotShowMessage() {
                return "Don't remind me again for this project";
            }

            @Override
            public void setToBeShown(boolean toBeShown, int exitCode) {
                String valueToSave = "";
                if (!toBeShown) {
                    valueToSave = RecommendedPluginVersionUpgradeDialog.this.myCurrentPluginVersion.toString();
                }
                RecommendedPluginVersionUpgradeDialog.this.myUpgradeReminder.setDoNotAskForVersion(valueToSave);
            }
        };
        this.init();
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myMessagePane);
        String msg = "";
        String url = GradlePluginUpgrade.releaseNotesUrl(recommended);
        if (((Boolean)StudioFlags.AGP_UPGRADE_ASSISTANT.get()).booleanValue()) {
            msg = msg + "<p>To take advantage of the latest features, improvements, and security fixes, we strongly recommend that you upgrade the Android Gradle Plugin in this project (" + this.myProject.getName() + ") from the current version " + current + " to version " + recommended + ". <a href='" + url + "'>Release notes</a></p>";
        } else {
            msg = msg + "To take advantage of the latest features, improvements, and security fixes, we strongly recommend that you update the Android Gradle plugin in this project (" + this.myProject.getName() + ") from the current version " + current + " to version " + recommended + " and Gradle to version " + "6.7.1" + ". <a href='" + url + "'>Release notes</a>";
            if (current.compareTo("3.2.0") < 0) {
                msg = msg + "<br/><br/>Android plugin 3.2.0 and higher now support building the <i>Android App Bundle</i>\u2014a new upload format that defers APK generation and signing to compatible app stores, such as Google Play. With app bundles, you no longer have to build, sign, and manage multiple APKs, and users get smaller, more optimized downloads. <a href='http://d.android.com/r/studio-ui/dynamic-delivery/overview'>Learn more</a>";
            }
        }
        this.myMessagePane.setText(msg);
        this.myMessagePane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
    }

    @NotNull
    protected JComponent createSouthPanel() {
        Action[] actions2 = this.createActions();
        ArrayList buttons = Lists.newArrayList();
        JPanel panel2 = new JPanel(new BorderLayout());
        if (actions2.length > 0) {
            JPanel buttonsPanel = this.createButtons(actions2, buttons);
            panel2.add((Component)buttonsPanel, "Center");
            this.myButtons = buttons.toArray(new JButton[0]);
        }
        if (this.getStyle() == DialogWrapper.DialogStyle.COMPACT) {
            CustomLineBorder line2 = new CustomLineBorder(OnePixelDivider.BACKGROUND, 1, 0, 0, 0);
            panel2.setBorder(new CompoundBorder((Border)line2, (Border)JBUI.Borders.empty((int)8, (int)12)));
        } else {
            panel2.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        }
        return panel2;
    }

    @NotNull
    protected Action[] createActions() {
        if (SystemInfo.isMac) {
            return new Action[]{new DoNotAskAction(), new RemindMeTomorrowAction(), this.getOKAction()};
        }
        return new Action[]{this.getOKAction(), new RemindMeTomorrowAction(), new DoNotAskAction()};
    }

    @NotNull
    protected Action getOKAction() {
        Action action2 = super.getOKAction();
        if (((Boolean)StudioFlags.AGP_UPGRADE_ASSISTANT.get()).booleanValue()) {
            action2.putValue("Name", "Begin Upgrade");
        } else {
            action2.putValue("Name", "Update");
        }
        return action2;
    }

    public void doCancelAction() {
        UpgradeDialogMetricUtilsKt.recordUpgradeDialogEvent(this.myProject, this.myCurrentPluginVersion, this.myRecommendedPluginVersion, GradlePluginUpgradeDialogStats.UserAction.CANCEL);
        this.close(1);
    }

    protected void doOKAction() {
        UpgradeDialogMetricUtilsKt.recordUpgradeDialogEvent(this.myProject, this.myCurrentPluginVersion, this.myRecommendedPluginVersion, GradlePluginUpgradeDialogStats.UserAction.OK);
        super.doOKAction();
    }

    @NotNull
    private JPanel createButtons(@NotNull Action[] actions2, @NotNull List<JButton> buttons) {
        JPanel buttonsPanel = new JPanel(new FlowLayout(4));
        for (Action action2 : actions2) {
            JButton button2 = this.createJButtonForAction(action2);
            Object value2 = action2.getValue("MnemonicKey");
            if (value2 instanceof Integer) {
                int mnemonic = (Integer)value2;
                button2.setMnemonic(mnemonic);
            }
            if (action2.getValue("FocusedAction") != null) {
                this.myPreferredFocusedComponent = button2;
            }
            buttons.add(button2);
            buttonsPanel.add(button2);
        }
        return buttonsPanel;
    }

    protected void dispose() {
        super.dispose();
        if (this.myButtons != null) {
            for (JButton button2 : this.myButtons) {
                button2.setAction(null);
            }
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JEditorPane jEditorPane;
        JPanel jPanel;
        this.myCenterPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMessagePane = jEditorPane = new JEditorPane();
        jPanel.add((Component)jEditorPane, new GridConstraints(0, 0, 1, 1, 1, 1, 6, 6, null, new Dimension(470, 130), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myCenterPanel;
    }

    @VisibleForTesting
    class RemindMeTomorrowAction
    extends DialogWrapper.DialogWrapperAction {
        RemindMeTomorrowAction() {
            super((DialogWrapper)RecommendedPluginVersionUpgradeDialog.this, "Remind me tomorrow");
        }

        protected void doAction(ActionEvent e) {
            RecommendedPluginVersionUpgradeDialog.this.myUpgradeReminder.updateLastTimestamp();
            UpgradeDialogMetricUtilsKt.recordUpgradeDialogEvent(RecommendedPluginVersionUpgradeDialog.this.myProject, RecommendedPluginVersionUpgradeDialog.this.myCurrentPluginVersion, RecommendedPluginVersionUpgradeDialog.this.myRecommendedPluginVersion, GradlePluginUpgradeDialogStats.UserAction.REMIND_ME_TOMORROW);
            RecommendedPluginVersionUpgradeDialog.this.close(1);
        }
    }

    private class DoNotAskAction
    extends DialogWrapper.DialogWrapperAction {
        protected DoNotAskAction() {
            super((DialogWrapper)RecommendedPluginVersionUpgradeDialog.this, RecommendedPluginVersionUpgradeDialog.this.myDoNotAskOption.getDoNotShowMessage());
        }

        protected void doAction(ActionEvent e) {
            RecommendedPluginVersionUpgradeDialog.this.myDoNotAskOption.setToBeShown(false, 1);
            UpgradeDialogMetricUtilsKt.recordUpgradeDialogEvent(RecommendedPluginVersionUpgradeDialog.this.myProject, RecommendedPluginVersionUpgradeDialog.this.myCurrentPluginVersion, RecommendedPluginVersionUpgradeDialog.this.myRecommendedPluginVersion, GradlePluginUpgradeDialogStats.UserAction.DO_NOT_ASK_AGAIN);
            RecommendedPluginVersionUpgradeDialog.this.close(1);
        }
    }

    public static class Factory {
        @NotNull
        public RecommendedPluginVersionUpgradeDialog create(@NotNull Project project, @NotNull GradleVersion current, @NotNull GradleVersion recommended) {
            return new RecommendedPluginVersionUpgradeDialog(project, current, recommended, new RecommendedUpgradeReminder(project));
        }
    }
}

