/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.TimeBasedReminder;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessorCannotUpgradeDialog;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessorKt;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessorWithJava8SpecialCaseDialog;
import com.android.tools.idea.gradle.project.upgrade.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.project.upgrade.ForcedPluginPreviewVersionUpgradeDialog;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.project.upgrade.Java8DefaultRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.ProjectUpgradeNotification;
import com.android.tools.idea.gradle.project.upgrade.RecommendedPluginVersionUpgradeDialog;
import com.android.tools.idea.gradle.project.upgrade.RecommendedUpgradeReminder;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.google.wireless.android.sdk.stats.UpgradeAssistantEventInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\"\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u0007\u001a0\u0010\u0012\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0014\u001a\u00020\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0007\u001a\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0000\u001a\u001a\u0010\u001b\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020\u0010H\u0007\u001a$\u0010\u001b\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u001d\u001a\u00020\u0010\u001a&\u0010\u001e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u001d\u001a\u00020\u0010H\u0007\u001a\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010H\u0007\u001a\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0007\u001a\u000e\u0010#\u001a\u0004\u0018\u00010$*\u00020\nH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"AGP_UPGRADE_NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "getAGP_UPGRADE_NOTIFICATION_GROUP", "()Lcom/intellij/notification/NotificationGroup;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "displayForceUpdatesDisabledMessage", "", "project", "Lcom/intellij/openapi/project/Project;", "expireProjectUpgradeNotifications", "isCleanEnoughProject", "", "performForcedPluginUpgrade", "currentPluginVersion", "Lcom/android/ide/common/repository/GradleVersion;", "newPluginVersion", "performRecommendedPluginUpgrade", "currentVersion", "recommendedVersion", "dialogFactory", "Lcom/android/tools/idea/gradle/project/upgrade/RecommendedPluginVersionUpgradeDialog$Factory;", "recommendPluginUpgrade", "releaseNotesUrl", "", "v", "shouldForcePluginUpgrade", "current", "recommended", "shouldRecommendPluginUpgrade", "shouldRecommendUpgrade", "showAndGetAgpUpgradeDialog", "processor", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessor;", "findPluginInfo", "Lcom/android/tools/idea/gradle/plugin/AndroidPluginInfo;", "intellij.android.core"})
@JvmName(name="GradlePluginUpgrade")
public final class GradlePluginUpgrade {
    private static final Logger LOG = Logger.getInstance((String)((Boolean)StudioFlags.AGP_UPGRADE_ASSISTANT.get() != false ? "Upgrade Assistant" : "AndroidGradlePluginUpdates"));
    @NotNull
    private static final NotificationGroup AGP_UPGRADE_NOTIFICATION_GROUP = new NotificationGroup("Android Gradle Upgrade Notification", NotificationDisplayType.STICKY_BALLOON, true, null, null, 24, null);

    @NotNull
    public static final NotificationGroup getAGP_UPGRADE_NOTIFICATION_GROUP() {
        return AGP_UPGRADE_NOTIFICATION_GROUP;
    }

    @Slow
    @JvmOverloads
    public static final boolean shouldRecommendPluginUpgrade(@NotNull Project project, @Nullable GradleVersion current, @NotNull GradleVersion recommended) {
        if (SystemProperties.getBooleanProperty((String)"studio.skip.agp.upgrade", (boolean)false)) {
            return false;
        }
        if (!TimeBasedReminder.shouldAsk$default(new RecommendedUpgradeReminder(project), 0L, 1, null)) {
            return false;
        }
        if (current == null) {
            return false;
        }
        return GradlePluginUpgrade.shouldRecommendUpgrade(current, recommended);
    }

    public static /* synthetic */ boolean shouldRecommendPluginUpgrade$default(Project project, GradleVersion gradleVersion2, GradleVersion gradleVersion3, int n, Object object) {
        if ((n & 2) != 0) {
            AndroidPluginInfo androidPluginInfo = GradlePluginUpgrade.findPluginInfo(project);
            Object object2 = gradleVersion2 = androidPluginInfo != null ? androidPluginInfo.getPluginVersion() : null;
        }
        if ((n & 4) != 0) {
            gradleVersion3 = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
        }
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade(project, gradleVersion2, gradleVersion3);
    }

    @Slow
    @JvmOverloads
    public static final boolean shouldRecommendPluginUpgrade(@NotNull Project project, @Nullable GradleVersion current) {
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade$default(project, current, null, 4, null);
    }

    @Slow
    @JvmOverloads
    public static final boolean shouldRecommendPluginUpgrade(@NotNull Project project) {
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade$default(project, null, null, 6, null);
    }

    public static final void recommendPluginUpgrade(@NotNull Project project) {
        ProjectUpgradeNotification[] existing2;
        ProjectUpgradeNotification[] projectUpgradeNotificationArray = existing2 = (ProjectUpgradeNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectUpgradeNotification.class, project);
        boolean bl = false;
        if (projectUpgradeNotificationArray.length == 0) {
            NotificationListener listener2 = new NotificationListener(project){
                final /* synthetic */ Project $project;

                public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent $noName_1) {
                    notification.expire();
                    if (((Boolean)StudioFlags.AGP_UPGRADE_ASSISTANT.get()).booleanValue()) {
                        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
                            final /* synthetic */ recommendPluginUpgrade.listener.1 this$0;

                            public final void run() {
                                GradlePluginUpgrade.performRecommendedPluginUpgrade$default(this.this$0.$project, null, null, null, 14, null);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    } else if (GradlePluginUpgrade.performRecommendedPluginUpgrade$default(this.$project, null, null, null, 14, null)) {
                        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_AGP_VERSION_UPDATED);
                        GradleSyncInvoker.getInstance().requestProjectSync(this.$project, request);
                    }
                }
                {
                    this.$project = project;
                }
            };
            ProjectUpgradeNotification notification = new ProjectUpgradeNotification("Plugin Update Recommended", IdeBundle.message((String)"updates.ready.message", (Object[])new Object[]{"Android Gradle Plugin"}), listener2);
            notification.notify(project);
        }
    }

    @Slow
    @JvmOverloads
    public static final boolean performRecommendedPluginUpgrade(@NotNull Project project, @Nullable GradleVersion currentVersion, @NotNull GradleVersion recommendedVersion, @NotNull RecommendedPluginVersionUpgradeDialog.Factory dialogFactory) {
        if (currentVersion == null) {
            return false;
        }
        LOG.info("Gradle model version: " + currentVersion + ", recommended version for IDE: " + recommendedVersion + ", current, recommended");
        boolean userAccepted2 = (Boolean)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.NON_MODAL, (Function0)((Function0)new Function0<Boolean>(dialogFactory, project, currentVersion, recommendedVersion){
            final /* synthetic */ RecommendedPluginVersionUpgradeDialog.Factory $dialogFactory;
            final /* synthetic */ Project $project;
            final /* synthetic */ GradleVersion $currentVersion;
            final /* synthetic */ GradleVersion $recommendedVersion;

            public final boolean invoke() {
                RecommendedPluginVersionUpgradeDialog updateDialog = this.$dialogFactory.create(this.$project, this.$currentVersion, this.$recommendedVersion);
                return updateDialog.showAndGet();
            }
            {
                this.$dialogFactory = factory2;
                this.$project = project;
                this.$currentVersion = gradleVersion2;
                this.$recommendedVersion = gradleVersion3;
                super(0);
            }
        }));
        if (userAccepted2) {
            GradleVersion latestGradleVersion;
            if (((Boolean)StudioFlags.AGP_UPGRADE_ASSISTANT.get()).booleanValue()) {
                AgpUpgradeRefactoringProcessorKt.showAndInvokeAgpUpgradeRefactoringProcessor(project, currentVersion, recommendedVersion);
                return false;
            }
            AndroidPluginVersionUpdater updater = AndroidPluginVersionUpdater.getInstance(project);
            AndroidPluginVersionUpdater.UpdateResult updateResult = updater.updatePluginVersion(recommendedVersion, latestGradleVersion = GradleVersion.parse((String)"6.7.1"), currentVersion);
            if (updateResult.versionUpdateSuccess()) {
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean performRecommendedPluginUpgrade$default(Project project, GradleVersion gradleVersion2, GradleVersion gradleVersion3, RecommendedPluginVersionUpgradeDialog.Factory factory2, int n, Object object) {
        if ((n & 2) != 0) {
            AndroidPluginInfo androidPluginInfo = GradlePluginUpgrade.findPluginInfo(project);
            Object object2 = gradleVersion2 = androidPluginInfo != null ? androidPluginInfo.getPluginVersion() : null;
        }
        if ((n & 4) != 0) {
            gradleVersion3 = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
        }
        if ((n & 8) != 0) {
            factory2 = new RecommendedPluginVersionUpgradeDialog.Factory();
        }
        return GradlePluginUpgrade.performRecommendedPluginUpgrade(project, gradleVersion2, gradleVersion3, factory2);
    }

    @Slow
    @JvmOverloads
    public static final boolean performRecommendedPluginUpgrade(@NotNull Project project, @Nullable GradleVersion currentVersion, @NotNull GradleVersion recommendedVersion) {
        return GradlePluginUpgrade.performRecommendedPluginUpgrade$default(project, currentVersion, recommendedVersion, null, 8, null);
    }

    @Slow
    @JvmOverloads
    public static final boolean performRecommendedPluginUpgrade(@NotNull Project project, @Nullable GradleVersion currentVersion) {
        return GradlePluginUpgrade.performRecommendedPluginUpgrade$default(project, currentVersion, null, null, 12, null);
    }

    @Slow
    @JvmOverloads
    public static final boolean performRecommendedPluginUpgrade(@NotNull Project project) {
        return GradlePluginUpgrade.performRecommendedPluginUpgrade$default(project, null, null, null, 14, null);
    }

    public static final boolean isCleanEnoughProject(@NotNull Project project) {
        Module[] $this$forEach$iv = ModuleManager.getInstance((Project)project).getModules();
        boolean $i$f$forEach = false;
        Module[] moduleArray = $this$forEach$iv;
        int n = moduleArray.length;
        for (int j = 0; j < n; ++j) {
            GradleFacet gradleFacet;
            Module element$iv;
            Module module2 = element$iv = moduleArray[j];
            boolean bl = false;
            if (GradleFacet.getInstance(module2) == null) {
                continue;
            }
            GradleModuleModel gradleModuleModel = gradleFacet.getGradleModuleModel();
            if (gradleModuleModel == null || (gradleModuleModel = gradleModuleModel.getBuildFile()) == null) {
                continue;
            }
            GradleModuleModel buildFile = gradleModuleModel;
            FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus((VirtualFile)buildFile);
            if (Intrinsics.areEqual((Object)fileStatus, (Object)FileStatus.NOT_CHANGED)) continue;
            return false;
        }
        return true;
    }

    @Slow
    public static final boolean showAndGetAgpUpgradeDialog(@NotNull AgpUpgradeRefactoringProcessor processor) {
        boolean hasChangesInBuildFiles;
        Object v0;
        block3: {
            Iterable $this$firstIsInstanceOrNull$iv = processor.getComponentRefactoringProcessors();
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof Java8DefaultRefactoringProcessor)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Java8DefaultRefactoringProcessor java8Processor = v0;
        if (java8Processor == null) {
            LOG.error("no Java8Default processor found in AGP Upgrade Processor");
        }
        processor.ensureParsedModels();
        boolean bl = hasChangesInBuildFiles = !GradlePluginUpgrade.isCleanEnoughProject(processor.getProject());
        if (hasChangesInBuildFiles) {
            LOG.warn("changes found in project build files");
        }
        boolean runProcessor2 = (Boolean)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.NON_MODAL, (Function0)((Function0)new Function0<Boolean>(processor, java8Processor, hasChangesInBuildFiles){
            final /* synthetic */ AgpUpgradeRefactoringProcessor $processor;
            final /* synthetic */ Java8DefaultRefactoringProcessor $java8Processor;
            final /* synthetic */ boolean $hasChangesInBuildFiles;

            public final boolean invoke() {
                if (this.$processor.getClasspathRefactoringProcessor().isAlwaysNoOpForProject()) {
                    AgpUpgradeRefactoringProcessorKt.trackProcessorUsage$default(this.$processor, UpgradeAssistantEventInfo.UpgradeAssistantEventKind.FAILURE_PREDICTED, null, 2, null);
                    GradlePluginUpgrade.access$getLOG$p().warn("cannot upgrade: classpath processor is always a no-op");
                    AgpUpgradeRefactoringProcessorCannotUpgradeDialog dialog2 = new AgpUpgradeRefactoringProcessorCannotUpgradeDialog(this.$processor);
                    dialog2.show();
                    return false;
                }
                Java8DefaultRefactoringProcessor java8DefaultRefactoringProcessor = this.$java8Processor;
                if (java8DefaultRefactoringProcessor == null) {
                    Intrinsics.throwNpe();
                }
                AgpUpgradeRefactoringProcessorWithJava8SpecialCaseDialog dialog3 = new AgpUpgradeRefactoringProcessorWithJava8SpecialCaseDialog(this.$processor, java8DefaultRefactoringProcessor, this.$hasChangesInBuildFiles);
                return dialog3.showAndGet();
            }
            {
                this.$processor = agpUpgradeRefactoringProcessor;
                this.$java8Processor = java8DefaultRefactoringProcessor;
                this.$hasChangesInBuildFiles = bl;
                super(0);
            }
        }));
        return runProcessor2;
    }

    @VisibleForTesting
    public static final boolean shouldRecommendUpgrade(@NotNull GradleVersion current, @NotNull GradleVersion recommended) {
        if (recommended.isSnapshot() && current.compareIgnoringQualifiers(recommended) == 0) {
            return false;
        }
        if (current.isPreview() && recommended.isPreview() && !recommended.isSnapshot()) {
            return false;
        }
        if (!current.isPreview() && recommended.isPreview() && current.compareIgnoringQualifiers(recommended) < 0) {
            return true;
        }
        return current.compareTo(recommended) < 0;
    }

    public static final void expireProjectUpgradeNotifications(@Nullable Project project) {
        Notification[] $this$forEach$iv = NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectUpgradeNotification.class, project);
        boolean $i$f$forEach = false;
        for (Notification element$iv : $this$forEach$iv) {
            ProjectUpgradeNotification it = (ProjectUpgradeNotification)element$iv;
            boolean bl = false;
            it.expire();
        }
    }

    public static final boolean shouldForcePluginUpgrade(@Nullable Project project, @Nullable GradleVersion current, @NotNull GradleVersion recommended) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        if (SystemProperties.getBooleanProperty((String)"studio.skip.agp.upgrade", (boolean)false)) {
            return false;
        }
        if (((Boolean)StudioFlags.DISABLE_FORCED_UPGRADES.get()).booleanValue()) {
            return false;
        }
        return GradlePluginUpgrade.shouldForcePluginUpgrade(current, recommended);
    }

    public static /* synthetic */ boolean shouldForcePluginUpgrade$default(Project project, GradleVersion gradleVersion2, GradleVersion gradleVersion3, int n, Object object) {
        if ((n & 4) != 0) {
            gradleVersion3 = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
        }
        return GradlePluginUpgrade.shouldForcePluginUpgrade(project, gradleVersion2, gradleVersion3);
    }

    @VisibleForTesting
    public static final boolean shouldForcePluginUpgrade(@Nullable GradleVersion current, @NotNull GradleVersion recommended) {
        GradleVersion gradleVersion2 = current;
        if ((gradleVersion2 != null ? gradleVersion2.getPreviewType() : null) == null) {
            return false;
        }
        if (recommended.isSnapshot() && current.compareIgnoringQualifiers(recommended) == 0) {
            return false;
        }
        if (recommended.isAtLeast(2, 4, 0, "alpha", 8, false)) {
            if (current.compareTo(recommended) >= 0) {
                return false;
            }
            if (Intrinsics.areEqual((Object)current.getPreviewType(), (Object)"rc") && recommended.getPreviewType() != null && current.getMajor() == recommended.getMajor() && current.getMinor() == recommended.getMinor() - 1) {
                return false;
            }
            boolean isOlderPluginAllowed = current.isPreview() && current.getMajor() == 2 && current.getMinor() == 4 && current.compareTo(recommended) < 0;
            return !isOlderPluginAllowed;
        }
        return current.compareTo(recommended) < 0;
    }

    @Slow
    public static final boolean performForcedPluginUpgrade(@NotNull Project project, @NotNull GradleVersion currentPluginVersion, @NotNull GradleVersion newPluginVersion) {
        boolean upgradeAccepted2 = (Boolean)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.NON_MODAL, (Function0)((Function0)new Function0<Boolean>(project, currentPluginVersion){
            final /* synthetic */ Project $project;
            final /* synthetic */ GradleVersion $currentPluginVersion;

            public final boolean invoke() {
                return new ForcedPluginPreviewVersionUpgradeDialog(this.$project, this.$currentPluginVersion).showAndGet();
            }
            {
                this.$project = project;
                this.$currentPluginVersion = gradleVersion2;
                super(0);
            }
        }));
        if (upgradeAccepted2) {
            if (((Boolean)StudioFlags.AGP_UPGRADE_ASSISTANT.get()).booleanValue()) {
                AgpUpgradeRefactoringProcessor processor = new AgpUpgradeRefactoringProcessor(project, currentPluginVersion, newPluginVersion);
                boolean runProcessor2 = GradlePluginUpgrade.showAndGetAgpUpgradeDialog(processor);
                if (runProcessor2) {
                    DumbService.getInstance((Project)project).smartInvokeLater(new Runnable(processor){
                        final /* synthetic */ AgpUpgradeRefactoringProcessor $processor;

                        public final void run() {
                            this.$processor.run();
                        }
                        {
                            this.$processor = agpUpgradeRefactoringProcessor;
                        }
                    });
                }
                return false;
            }
        } else {
            SyncMessage syncMessage = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, "The project is using an incompatible version of the Android Gradle plugin.", "Please update your project to use version " + newPluginVersion + '.');
            String pluginName = "com.android.tools.build:gradle";
            syncMessage.add(new SearchInBuildFilesHyperlink(pluginName));
            GradleSyncMessages.getInstance(project).report(syncMessage);
            return false;
        }
        AndroidPluginVersionUpdater versionUpdater = AndroidPluginVersionUpdater.getInstance(project);
        versionUpdater.updatePluginVersion(newPluginVersion, GradleVersion.parse((String)"6.7.1"), currentPluginVersion);
        return true;
    }

    public static /* synthetic */ boolean performForcedPluginUpgrade$default(Project project, GradleVersion gradleVersion2, GradleVersion gradleVersion3, int n, Object object) {
        if ((n & 4) != 0) {
            gradleVersion3 = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
        }
        return GradlePluginUpgrade.performForcedPluginUpgrade(project, gradleVersion2, gradleVersion3);
    }

    public static final void displayForceUpdatesDisabledMessage(@NotNull Project project) {
        String msg = "Forced upgrades are disabled, errors seen may be due to incompatibilities between the Android Gradle Plugin and the version of Android Studio.\nTo re-enable forced updates please go to 'Tools > Internal Actions > Edit Studio Flags' and set " + '\'' + StudioFlags.DISABLE_FORCED_UPGRADES.getDisplayName() + "' to 'Off'.";
        Notification notification = AGP_UPGRADE_NOTIFICATION_GROUP.createNotification(msg, com.intellij.openapi.ui.MessageType.WARNING);
        notification.notify(project);
    }

    private static final AndroidPluginInfo findPluginInfo(Project $this$findPluginInfo) {
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find($this$findPluginInfo);
        if (pluginInfo == null) {
            LOG.warn("Unable to obtain application's Android Project");
            return null;
        }
        return pluginInfo;
    }

    @NotNull
    public static final String releaseNotesUrl(@NotNull GradleVersion v) {
        return v.isPreview() ? "https://developer.android.com/studio/preview/features#android_gradle_plugin_" + v.getMajor() + v.getMinor() : "https://developer.android.com/studio/releases/gradle-plugin#" + v.getMajor() + '-' + v.getMinor() + "-0";
    }

    public static final /* synthetic */ AndroidPluginInfo access$findPluginInfo(Project $this$access_u24findPluginInfo) {
        return GradlePluginUpgrade.findPluginInfo($this$access_u24findPluginInfo);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

