/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.gradle.project.sync.setup.module.common.RootSourceFolder;
import com.android.tools.idea.gradle.util.ContentEntries;
import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class ContentEntriesSetup {
    @NotNull
    protected final ModifiableRootModel myModuleModel;
    @NotNull
    private final List<RootSourceFolder> myOrphans = new ArrayList<RootSourceFolder>();

    protected ContentEntriesSetup(@NotNull ModifiableRootModel moduleModel) {
        this.myModuleModel = moduleModel;
    }

    public static void removeExistingContentEntries(@NotNull ModifiableRootModel rootModel) {
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            rootModel.removeContentEntry(contentEntry);
        }
    }

    public abstract void execute(@NotNull List<ContentEntry> var1);

    protected void addSourceFolder(@NotNull File folderPath, @NotNull Collection<ContentEntry> contentEntries, @NotNull JpsModuleSourceRootType type, boolean generated) {
        ContentEntry parent = ContentEntries.findParentContentEntry(folderPath, contentEntries.stream());
        if (parent == null) {
            this.myOrphans.add(new RootSourceFolder(folderPath, type, generated));
            return;
        }
        ContentEntriesSetup.addSourceFolder(parent, folderPath, type, generated);
    }

    private static void addSourceFolder(@NotNull ContentEntry contentEntry, @NotNull File folderPath, @NotNull JpsModuleSourceRootType type, boolean generated) {
        String url = FilePaths.pathToIdeaUrl((File)folderPath);
        SourceFolder sourceFolder = contentEntry.addSourceFolder(url, type);
        if (generated) {
            JpsModuleSourceRoot sourceRoot = sourceFolder.getJpsElement();
            JpsElement properties2 = sourceRoot.getProperties();
            if (properties2 instanceof JavaSourceRootProperties) {
                ((JavaSourceRootProperties)properties2).setForGeneratedSources(true);
            } else if (properties2 instanceof JavaResourceRootProperties) {
                ((JavaResourceRootProperties)properties2).setForGeneratedSources(true);
            }
        }
    }

    protected boolean addExcludedFolder(@NotNull ContentEntry contentEntry, @NotNull File folderPath) {
        if (!ContentEntries.isPathInContentEntry(folderPath, contentEntry)) {
            return false;
        }
        contentEntry.addExcludeFolder(FilePaths.pathToIdeaUrl((File)folderPath));
        return true;
    }

    protected void addOrphans() {
        for (RootSourceFolder orphan : this.myOrphans) {
            File path2 = orphan.getPath();
            ContentEntry contentEntry = this.myModuleModel.addContentEntry(FilePaths.pathToIdeaUrl((File)path2));
            ContentEntriesSetup.addSourceFolder(contentEntry, path2, orphan.getType(), orphan.isGenerated());
        }
    }

    @NotNull
    protected Module getModule() {
        return this.myModuleModel.getModule();
    }
}

