/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.ide.common.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueQuickFix;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporterUtils;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.AndroidGradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.ui.QuickFixNotificationListener;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleDeduplicatingSyncIssueReporter
extends BaseSyncIssuesReporter {
    @Override
    final void report(@NotNull IdeSyncIssue syncIssue, @NotNull Module module2, @Nullable VirtualFile buildFile, @NotNull SyncIssueUsageReporter usageReporter) {
        this.reportAll((List<IdeSyncIssue>)ImmutableList.of((Object)syncIssue), (Map<IdeSyncIssue, Module>)ImmutableMap.of((Object)syncIssue, (Object)module2), (Map<Module, VirtualFile>)(buildFile == null ? ImmutableMap.of() : ImmutableMap.of((Object)module2, (Object)buildFile)), usageReporter);
    }

    @Override
    final void reportAll(@NotNull List<IdeSyncIssue> syncIssues2, @NotNull Map<IdeSyncIssue, Module> moduleMap, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull SyncIssueUsageReporter usageReporter) {
        LinkedHashMap<Object, List> groupedIssues = new LinkedHashMap<Object, List>();
        for (IdeSyncIssue issue2 : syncIssues2) {
            groupedIssues.computeIfAbsent(this.getDeduplicationKey(issue2), config -> new ArrayList()).add(issue2);
        }
        for (List entry : groupedIssues.values()) {
            IdeSyncIssue issue3;
            Module module2;
            if (entry.isEmpty() || (module2 = moduleMap.get(issue3 = (IdeSyncIssue)entry.get(0))) == null) continue;
            List<Module> affectedModules = entry.stream().map(moduleMap::get).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(Module::getName)).collect(Collectors.toList());
            boolean isError = entry.stream().anyMatch(i2 -> i2.getSeverity() == 2);
            this.createNotificationDataAndReport(module2.getProject(), entry, affectedModules, buildFileMap, isError, usageReporter);
        }
    }

    private void createNotificationDataAndReport(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, boolean isError, @NotNull SyncIssueUsageReporter usageReporter) {
        MessageType type;
        GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
        MessageType messageType = type = isError ? MessageType.WARNING : MessageType.INFO;
        assert (!syncIssues2.isEmpty());
        NotificationData notification = this.setupNotificationData(project, syncIssues2, affectedModules, buildFileMap, type);
        StringBuilder builder2 = new StringBuilder();
        List<NotificationHyperlink> customLinks = this.getCustomLinks(project, syncIssues2, affectedModules, buildFileMap);
        messages.updateNotification(notification, notification.getMessage(), customLinks);
        SyncIssueUsageReporterUtils.collect(usageReporter, syncIssues2.get(0).getType(), customLinks);
        String message2 = notification.getMessage().trim();
        ArrayList<AndroidSyncIssueQuickFix> buildIssueLinks = new ArrayList<AndroidSyncIssueQuickFix>();
        buildIssueLinks.addAll(ContainerUtil.map(customLinks, it -> new AndroidSyncIssueQuickFix((NotificationHyperlink)it)));
        if (this.shouldIncludeModuleLinks() && !affectedModules.isEmpty()) {
            builder2.append("\nAffected Modules: ");
            Iterator<Module> it2 = affectedModules.iterator();
            while (it2.hasNext()) {
                Module m = it2.next();
                if (m == null) continue;
                NotificationHyperlink link = this.doCreateModuleLink(project, notification, builder2, m, syncIssues2, buildFileMap.get(m));
                if (link != null) {
                    buildIssueLinks.add(new AndroidSyncIssueQuickFix(link));
                }
                if (!it2.hasNext()) continue;
                builder2.append(", ");
            }
        }
        message2 = message2 + builder2.toString();
        notification.setMessage(message2);
        messages.report(notification, buildIssueLinks);
    }

    private NotificationHyperlink doCreateModuleLink(@NotNull Project project, @NotNull NotificationData notification, @NotNull StringBuilder builder2, @NotNull Module module2, @NotNull List<IdeSyncIssue> syncIssues2, @Nullable VirtualFile buildFile) {
        if (buildFile == null) {
            builder2.append(AndroidGradleUtil.getDisplayNameForModule(module2));
            return null;
        }
        OpenFileHyperlink link = this.createModuleLink(project, module2, syncIssues2, buildFile);
        builder2.append(link.toHtml());
        notification.setListener(link.getUrl(), (NotificationListener)new QuickFixNotificationListener(project, link));
        return link;
    }

    @NotNull
    protected OpenFileHyperlink createModuleLink(@NotNull Project project, @NotNull Module module2, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull VirtualFile buildFile) {
        return new OpenFileHyperlink(buildFile.getPath(), AndroidGradleUtil.getDisplayNameForModule(module2), -1, -1);
    }

    @NotNull
    protected Object getDeduplicationKey(@NotNull IdeSyncIssue issue2) {
        return issue2.getData() == null ? issue2 : issue2.getData();
    }

    protected boolean shouldIncludeModuleLinks() {
        return true;
    }

    @NotNull
    protected List<NotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        return ImmutableList.of();
    }

    @NotNull
    protected NotificationData setupNotificationData(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull MessageType type) {
        VirtualFile file2;
        assert (!syncIssues2.isEmpty());
        GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
        PositionInFile position = null;
        if (affectedModules.size() == 1 && (file2 = buildFileMap.get(affectedModules.get(0))) != null) {
            position = new PositionInFile(file2);
        }
        NotificationData data = messages.createNotification("Gradle Sync Issues", syncIssues2.get(0).getMessage(), type.convertToCategory(), position);
        if (position != null) {
            data.setNavigatable((Navigatable)new OpenFileDescriptor(project, position.file, position.line, position.column));
        }
        return data;
    }

    public static int getLineNumberForElement(@NotNull Project project, @Nullable PsiElement element2) {
        return (Integer)ApplicationManager.getApplication().runReadAction(() -> {
            Document document;
            if (element2 != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(element2.getContainingFile())) != null) {
                return document.getLineNumber(element2.getTextOffset());
            }
            return -1;
        });
    }
}

