/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.issues;

import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.ConfirmSHA256FromGradleWrapperQuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.InvalidGradleWrapperException;
import com.android.tools.idea.gradle.project.sync.idea.issues.RemoveSHA256FromGradleWrapperQuickFix;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.build.issue.quickfix.OpenFileQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/gradle/project/sync/idea/issues/GradleWrapperImportChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "intellij.android.core"})
final class GradleWrapperImportChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        if (!(issueData.getError() instanceof InvalidGradleWrapperException)) {
            return null;
        }
        Throwable throwable = issueData.getError();
        if (throwable == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.gradle.project.sync.idea.issues.InvalidGradleWrapperException");
        }
        GradleWrapper wrapper = ((InvalidGradleWrapperException)throwable).getWrapper();
        BuildIssueUtilKt.updateUsageTracker(issueData.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.JDK8_REQUIRED);
        String message2 = StringsKt.trimIndent((String)("\n      It is not fully supported to define distributionSha256Sum in " + GradleWrapper.GRADLEW_PROPERTIES_PATH + ".\n      Using an incorrect value may freeze or crash Android Studio.\n      Please manually verify or remove this property from all of included projects if applicable.\n      For more details, see https://github.com/gradle/gradle/issues/9361.\n    "));
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message2, null, 2, null);
        boolean bl = false;
        boolean bl2 = false;
        BuildIssueComposer $this$apply = buildIssueComposer;
        boolean bl3 = false;
        try {
            String distUrl = wrapper.getDistributionUrl();
            String distSHA = wrapper.getDistributionSha256Sum();
            CharSequence charSequence = distUrl;
            boolean bl4 = false;
            boolean bl5 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                charSequence = distSHA;
                bl4 = false;
                bl5 = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    $this$apply.addQuickFix(new ConfirmSHA256FromGradleWrapperQuickFix(distSHA, distUrl));
                }
            }
            $this$apply.addQuickFix(new RemoveSHA256FromGradleWrapperQuickFix());
            $this$apply.addQuickFix("Open Gradle wrapper properties", (BuildIssueQuickFix)new OpenFileQuickFix(wrapper.getPropertiesFilePath().toPath(), null));
        }
        catch (IOException e) {
            Logger.getInstance(GradleWrapperImportChecker.class).warn((Throwable)e);
        }
        return buildIssueComposer.composeBuildIssue();
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        return GradleIssueChecker.DefaultImpls.consumeBuildOutputFailureMessage((GradleIssueChecker)this, (String)message2, (String)failureCause, (String)stacktrace, (FilePosition)location, (Object)parentEventId, messageConsumer);
    }
}

