/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.NdkModuleSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NdkModuleModelDataService
extends ModuleModelDataService<NdkModuleModel> {
    @NotNull
    private final ModuleSetupContext.Factory myModuleSetupContextFactory;
    @NotNull
    private final NdkModuleSetup myModuleSetup;

    public NdkModuleModelDataService() {
        this(new ModuleSetupContext.Factory(), new NdkModuleSetup());
    }

    @VisibleForTesting
    NdkModuleModelDataService(@NotNull ModuleSetupContext.Factory moduleSetupContextFactory, @NotNull NdkModuleSetup moduleSetup) {
        this.myModuleSetupContextFactory = moduleSetupContextFactory;
        this.myModuleSetup = moduleSetup;
    }

    @NotNull
    public Key<NdkModuleModel> getTargetDataKey() {
        return AndroidProjectKeys.NDK_MODEL;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<NdkModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, NdkModuleModel> modelsByModuleName) {
        for (Module module2 : modelsProvider.getModules()) {
            NdkModuleModel ndkModuleModel = modelsByModuleName.get(module2.getName());
            if (ndkModuleModel != null) {
                ModuleSetupContext context = this.myModuleSetupContextFactory.create(module2, modelsProvider);
                this.myModuleSetup.setUpModule(context, ndkModuleModel);
                continue;
            }
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module2);
            Facets.removeAllFacets(facetModel, NdkFacet.getFacetTypeId());
        }
    }
}

