/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaModuleModelDataService
extends ModuleModelDataService<JavaModuleModel> {
    @NotNull
    private final ModuleSetupContext.Factory myModuleSetupContextFactory;
    @NotNull
    private final JavaModuleSetup myModuleSetup;

    public JavaModuleModelDataService() {
        this(new ModuleSetupContext.Factory(), new JavaModuleSetup());
    }

    @VisibleForTesting
    JavaModuleModelDataService(@NotNull ModuleSetupContext.Factory moduleSetupContextFactory, @NotNull JavaModuleSetup moduleSetup) {
        this.myModuleSetupContextFactory = moduleSetupContextFactory;
        this.myModuleSetup = moduleSetup;
    }

    @NotNull
    public Key<JavaModuleModel> getTargetDataKey() {
        return AndroidProjectKeys.JAVA_MODULE_MODEL;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<JavaModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, JavaModuleModel> modelsByModuleName) {
        for (Module module2 : modelsProvider.getModules()) {
            JavaModuleModel javaModuleModel = modelsByModuleName.get(module2.getName());
            if (javaModuleModel != null) {
                ModuleSetupContext context = this.myModuleSetupContextFactory.create(module2, modelsProvider);
                this.myModuleSetup.setUpModule(context, javaModuleModel);
                continue;
            }
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module2);
            Facets.removeAllFacets(facetModel, JavaFacet.getFacetTypeId());
        }
    }
}

