/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class DataNodeCaches {
    @NotNull
    private final Project myProject;

    @NotNull
    public static DataNodeCaches getInstance(@NotNull Project project) {
        return (DataNodeCaches)ServiceManager.getService((Project)project, DataNodeCaches.class);
    }

    public DataNodeCaches(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    public DataNode<ProjectData> getCachedProjectData() {
        ExternalProjectInfo projectInfo = this.getExternalProjectInfo();
        return projectInfo != null ? projectInfo.getExternalProjectStructure() : null;
    }

    @Nullable
    private ExternalProjectInfo getExternalProjectInfo() {
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        String projectPath = Projects.getBaseDirPath((Project)this.myProject).getPath();
        return dataManager.getExternalProjectData(this.myProject, GradleConstants.SYSTEM_ID, projectPath);
    }

    public void clearCaches() {
        ExternalProjectInfo projectInfo = this.getExternalProjectInfo();
        if (projectInfo == null) {
            return;
        }
        DataNode cache = projectInfo.getExternalProjectStructure();
        if (cache == null) {
            return;
        }
        DataNodeCaches.clearCaches((DataNode<ProjectData>)cache);
        ProjectDataManagerImpl.getInstance().updateExternalProjectData(this.myProject, projectInfo);
        this.myProject.save();
    }

    private static void clearCaches(@NotNull DataNode<ProjectData> cache) {
        DataNodeCaches.clearCachesOfType(cache, AndroidProjectKeys.GRADLE_MODULE_MODEL);
        DataNodeCaches.clearCachesOfType(cache, AndroidProjectKeys.ANDROID_MODEL);
        DataNodeCaches.clearCachesOfType(cache, AndroidProjectKeys.JAVA_MODULE_MODEL);
        DataNodeCaches.clearCachesOfType(cache, AndroidProjectKeys.NDK_MODEL);
    }

    private static <T> void clearCachesOfType(@NotNull DataNode<ProjectData> cache, @NotNull Key<T> type) {
        for (DataNode dataNode : ExternalSystemApiUtil.findAllRecursively(cache, type)) {
            dataNode.clear(true);
        }
    }
}

