/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.issues.processor.AddRepoProcessor;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddGoogleMavenRepositoryHyperlink
extends NotificationHyperlink {
    @NotNull
    private final List<VirtualFile> myBuildFiles;
    private final boolean mySyncAfterFix;

    public AddGoogleMavenRepositoryHyperlink(@NotNull Project project) {
        this(AddGoogleMavenRepositoryHyperlink.getBuildFileForPlugin(project), true);
    }

    public AddGoogleMavenRepositoryHyperlink(@NotNull List<VirtualFile> buildFiles) {
        this(buildFiles, true);
    }

    @VisibleForTesting
    public AddGoogleMavenRepositoryHyperlink(@NotNull List<VirtualFile> buildFiles, boolean syncAfterFix) {
        super("add.google.maven.repository", AddGoogleMavenRepositoryHyperlink.getText(buildFiles.isEmpty(), syncAfterFix));
        this.myBuildFiles = buildFiles;
        this.mySyncAfterFix = syncAfterFix;
    }

    @Override
    protected void execute(@NotNull Project project) {
        List<VirtualFile> files2 = this.myBuildFiles;
        if (files2.isEmpty()) {
            files2.addAll(AddGoogleMavenRepositoryHyperlink.getBuildFileForPlugin(project));
        }
        if (!this.myBuildFiles.isEmpty()) {
            AddRepoProcessor processor = new AddRepoProcessor(project, this.myBuildFiles, AddRepoProcessor.Repository.GOOGLE, this.mySyncAfterFix);
            processor.setPreviewUsages(true);
            processor.run();
        }
    }

    @NotNull
    private static String getText(boolean buildFileFound, boolean syncAfterFix) {
        String text2 = "Add Google Maven repository";
        if (buildFileFound) {
            text2 = text2 + " (if needed)";
        }
        if (syncAfterFix) {
            text2 = text2 + " and sync project";
        }
        return text2;
    }

    @NotNull
    public List<VirtualFile> getBuildFiles() {
        return this.myBuildFiles;
    }

    @NotNull
    public static List<VirtualFile> getBuildFileForPlugin(@NotNull Project project) {
        VirtualFile buildFile;
        AndroidPluginInfo result2 = AndroidPluginInfo.findFromBuildFiles(project);
        if (result2 != null && (buildFile = result2.getPluginBuildFile()) != null) {
            return ImmutableList.of((Object)buildFile);
        }
        buildFile = GradleUtil.getGradleBuildFile(Projects.getBaseDirPath((Project)project));
        return buildFile == null ? ImmutableList.of() : ImmutableList.of((Object)buildFile);
    }
}

