/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.importing.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.idea.GradleSyncExecutor;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSyncInvoker {
    private static final Logger LOG = Logger.getInstance(GradleSyncInvoker.class);

    @NotNull
    public static GradleSyncInvoker getInstance() {
        return (GradleSyncInvoker)ServiceManager.getService(GradleSyncInvoker.class);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger) {
        this.requestProjectSync(project, trigger, null);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger, @Nullable GradleSyncListener listener2) {
        Request request = new Request(trigger);
        this.requestProjectSync(project, request, listener2);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull Request request) {
        this.requestProjectSync(project, request, null);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener2) {
        if (GradleSyncState.getInstance(project).isSyncInProgress()) {
            return;
        }
        if (GradleSyncInvoker.isBuildInProgress(project)) {
            GradleProjects.setSyncRequestedDuringBuild(project, true);
            return;
        }
        Runnable syncTask = () -> {
            ExternalSystemUtil.ensureToolWindowContentInitialized((Project)project, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
            if (GradleSyncInvoker.prepareProject(project, listener2)) {
                GradleSyncInvoker.sync(project, request, listener2);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            application.invokeAndWait(syncTask);
        } else if (request.runInBackground) {
            ApplicationManager.getApplication().invokeLater(syncTask);
        } else {
            ApplicationManager.getApplication().invokeAndWait(syncTask);
        }
    }

    private static boolean isBuildInProgress(@NotNull Project project) {
        StatusBarEx statusBar;
        IdeFrame frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(project);
        StatusBarEx statusBarEx = statusBar = frame == null ? null : (StatusBarEx)frame.getStatusBar();
        if (statusBar == null) {
            return false;
        }
        for (Pair backgroundProcess : statusBar.getBackgroundProcesses()) {
            ProgressIndicator second;
            TaskInfo task2 = (TaskInfo)backgroundProcess.getFirst();
            if (!(task2 instanceof GradleTasksExecutor) || !(second = (ProgressIndicator)backgroundProcess.getSecond()).isRunning()) continue;
            return true;
        }
        return false;
    }

    private static boolean prepareProject(@NotNull Project project, @Nullable GradleSyncListener listener2) {
        GradleProjectInfo projectInfo = GradleProjectInfo.getInstance(project);
        if (AndroidProjectInfo.getInstance(project).requiresAndroidModel() || projectInfo.hasTopLevelGradleFile()) {
            boolean isImportedProject = projectInfo.isImportedProject();
            if (!isImportedProject) {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
            return true;
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> {
            String msg = String.format("The project '%s' is not a Gradle-based project", project.getName());
            LOG.error(msg);
            AndroidNotification.getInstance(project).showBalloon("Project Sync", msg, NotificationType.ERROR, new OpenMigrationToGradleUrlHyperlink());
            if (listener2 != null) {
                listener2.syncFailed(project, msg);
            }
        });
        return false;
    }

    @WorkerThread
    private static void sync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener2) {
        UIUtil.invokeAndWaitIfNeeded(() -> GradleSyncMessages.getInstance(project).removeAllMessages());
        new GradleSyncExecutor(project).sync(request, listener2);
    }

    @WorkerThread
    public void fetchAndMergeNativeVariants(@NotNull Project project, @NotNull @NotNull Set<@NotNull String> requestedAbis) {
        new GradleSyncExecutor(project).fetchAndMergeNativeVariants(requestedAbis);
    }

    @WorkerThread
    @NotNull
    public List<GradleModuleModels> fetchGradleModels(@NotNull Project project) {
        return new GradleSyncExecutor(project).fetchGradleModels();
    }

    public static class FakeInvoker
    extends GradleSyncInvoker {
        @Override
        public void requestProjectSync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener2) {
            if (listener2 != null) {
                listener2.syncSkipped(project);
            }
        }
    }

    public static class Request {
        public final GradleSyncStats.Trigger trigger;
        public boolean runInBackground = true;
        public boolean forceFullVariantsSync;
        public boolean skipPreSyncChecks;

        @VisibleForTesting
        @NotNull
        public static Request testRequest() {
            return new Request(GradleSyncStats.Trigger.TRIGGER_TEST_REQUESTED);
        }

        public Request(@NotNull GradleSyncStats.Trigger trigger) {
            this.trigger = trigger;
        }

        @NotNull
        public ProgressExecutionMode getProgressExecutionMode() {
            return this.runInBackground ? ProgressExecutionMode.IN_BACKGROUND_ASYNC : ProgressExecutionMode.MODAL_SYNC;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.trigger == request.trigger && this.runInBackground == request.runInBackground && this.forceFullVariantsSync == request.forceFullVariantsSync && this.skipPreSyncChecks == request.skipPreSyncChecks;
        }

        public int hashCode() {
            return Objects.hash(this.trigger, this.runInBackground, this.forceFullVariantsSync, this.skipPreSyncChecks);
        }

        public String toString() {
            return "RequestSettings{trigger=" + this.trigger + ", runInBackground=" + this.runInBackground + ", forceFullVariantsSync=" + this.forceFullVariantsSync + ", skipPreSyncChecks=" + this.skipPreSyncChecks + '}';
        }
    }
}

