/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;

public class JavaModuleModel
implements ModuleModel {
    private static final long serialVersionUID = 4L;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final Collection<JavaModuleContentRoot> myContentRoots;
    @NotNull
    private final Collection<JavaModuleDependency> myJavaModuleDependencies;
    @NotNull
    private final Collection<JarLibraryDependency> myJarLibraryDependencies;
    @NotNull
    private final Map<String, Set<File>> myArtifactsByConfiguration;
    @NotNull
    private final List<String> myConfigurations;
    @Nullable
    private final ExtIdeaCompilerOutput myCompilerOutput;
    @Nullable
    private final File myBuildFolderPath;
    @Nullable
    private final String myLanguageLevel;
    private final boolean myBuildable;

    @Nullable
    public static JavaModuleModel get(@NotNull Module module2) {
        JavaFacet facet2 = JavaFacet.getInstance(module2);
        return facet2 != null ? JavaModuleModel.get(facet2) : null;
    }

    @Nullable
    public static JavaModuleModel get(@NotNull JavaFacet javaFacet) {
        return javaFacet.getJavaModuleModel();
    }

    public static JavaModuleModel create(@NotNull String moduleName2, @NotNull Collection<JavaModuleContentRoot> contentRoots, @NotNull Collection<JavaModuleDependency> javaModuleDependencies, @NotNull Collection<JarLibraryDependency> jarLibraryDependencies, @NotNull Map<String, Set<File>> artifactsByConfiguration, @Nullable ExtIdeaCompilerOutput compilerOutput, @Nullable File buildFolderPath, @Nullable String languageLevel, boolean buildable) {
        ArrayList<String> configurationsCopy = new ArrayList<String>(artifactsByConfiguration.keySet());
        Collections.sort(configurationsCopy);
        return new JavaModuleModel(moduleName2, contentRoots, javaModuleDependencies, jarLibraryDependencies, artifactsByConfiguration, configurationsCopy, compilerOutput, buildFolderPath, languageLevel, buildable);
    }

    @PropertyMapping(value={"myModuleName", "myContentRoots", "myJavaModuleDependencies", "myJarLibraryDependencies", "myArtifactsByConfiguration", "myConfigurations", "myCompilerOutput", "myBuildFolderPath", "myLanguageLevel", "myBuildable"})
    public JavaModuleModel(@NotNull String moduleName2, @NotNull Collection<JavaModuleContentRoot> contentRoots, @NotNull Collection<JavaModuleDependency> javaModuleDependencies, @NotNull Collection<JarLibraryDependency> jarLibraryDependencies, @NotNull Map<String, Set<File>> artifactsByConfiguration, @NotNull List<String> configurations, @Nullable ExtIdeaCompilerOutput compilerOutput, @Nullable File buildFolderPath, @Nullable String languageLevel, boolean buildable) {
        this.myModuleName = moduleName2;
        this.myContentRoots = contentRoots;
        this.myJavaModuleDependencies = javaModuleDependencies;
        this.myJarLibraryDependencies = jarLibraryDependencies;
        this.myArtifactsByConfiguration = artifactsByConfiguration;
        this.myConfigurations = configurations;
        this.myCompilerOutput = compilerOutput;
        this.myBuildFolderPath = buildFolderPath;
        this.myLanguageLevel = languageLevel;
        this.myBuildable = buildable;
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public Collection<JavaModuleContentRoot> getContentRoots() {
        return this.myContentRoots;
    }

    public boolean containsSourceFile(@NotNull File file2) {
        for (JavaModuleContentRoot contentRoot : this.getContentRoots()) {
            if (contentRoot == null || !JavaModuleModel.containsFile(contentRoot, file2)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFile(@NotNull JavaModuleContentRoot contentRoot, @NotNull File file2) {
        return JavaModuleModel.containsFile(contentRoot.getSourceDirPaths(), file2) || JavaModuleModel.containsFile(contentRoot.getTestDirPaths(), file2) || JavaModuleModel.containsFile(contentRoot.getResourceDirPaths(), file2) || JavaModuleModel.containsFile(contentRoot.getGenSourceDirPaths(), file2) || JavaModuleModel.containsFile(contentRoot.getGenTestDirPaths(), file2) || JavaModuleModel.containsFile(contentRoot.getTestResourceDirPaths(), file2);
    }

    private static boolean containsFile(@NotNull Collection<File> folderPaths, @NotNull File file2) {
        for (File path2 : folderPaths) {
            if (!FileUtil.isAncestor((File)path2, (File)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Map<String, Set<File>> getArtifactsByConfiguration() {
        return this.myArtifactsByConfiguration;
    }

    @Nullable
    public ExtIdeaCompilerOutput getCompilerOutput() {
        return this.myCompilerOutput;
    }

    @Nullable
    public File getBuildFolderPath() {
        return this.myBuildFolderPath;
    }

    @NotNull
    public Collection<JavaModuleDependency> getJavaModuleDependencies() {
        return this.myJavaModuleDependencies;
    }

    @NotNull
    public Collection<JarLibraryDependency> getJarLibraryDependencies() {
        return this.myJarLibraryDependencies;
    }

    public boolean isBuildable() {
        return this.myBuildable;
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        if (this.myLanguageLevel != null) {
            return LanguageLevel.parse((String)this.myLanguageLevel);
        }
        return null;
    }

    @NotNull
    public List<String> getConfigurations() {
        return this.myConfigurations;
    }
}

