/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.tools.idea.gradle.model.java.IdeaJarLibraryDependencyFactory;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.service.project.CommonGradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.tooling.internal.IdeaCompilerOutputImpl;

public class IdeaJavaModuleModelFactory {
    @NotNull
    private final IdeaJarLibraryDependencyFactory myIdeaJarLibraryDependencyFactory;

    public IdeaJavaModuleModelFactory() {
        this(new IdeaJarLibraryDependencyFactory());
    }

    @VisibleForTesting
    IdeaJavaModuleModelFactory(@NotNull IdeaJarLibraryDependencyFactory ideaJarLibraryDependencyFactory) {
        this.myIdeaJarLibraryDependencyFactory = ideaJarLibraryDependencyFactory;
    }

    @NotNull
    public JavaModuleModel create(@NotNull IdeaModule ideaModule, @Nullable ExternalProject externalProject, boolean isBuildable) {
        Pair<Collection<JavaModuleDependency>, Collection<JarLibraryDependency>> dependencies2 = this.getDependencies(ideaModule);
        return JavaModuleModel.create(ideaModule.getName(), IdeaJavaModuleModelFactory.getContentRoots(ideaModule), (Collection)dependencies2.first, (Collection)dependencies2.second, IdeaJavaModuleModelFactory.getArtifactsByConfiguration(externalProject), IdeaJavaModuleModelFactory.getCompilerOutput(externalProject), ideaModule.getGradleProject().getBuildDirectory(), IdeaJavaModuleModelFactory.getLanguageLevel(externalProject), isBuildable);
    }

    @NotNull
    private static ExtIdeaCompilerOutput getCompilerOutputCopy(@NotNull ExternalProject externalProject) {
        IdeaCompilerOutputImpl clone = new IdeaCompilerOutputImpl();
        clone.setMainClassesDir(CommonGradleProjectResolverExtension.getGradleOutputDir((ExternalProject)externalProject, (String)"main", (ExternalSystemSourceType)ExternalSystemSourceType.SOURCE));
        clone.setMainResourcesDir(CommonGradleProjectResolverExtension.getGradleOutputDir((ExternalProject)externalProject, (String)"main", (ExternalSystemSourceType)ExternalSystemSourceType.RESOURCE));
        clone.setTestClassesDir(CommonGradleProjectResolverExtension.getGradleOutputDir((ExternalProject)externalProject, (String)"test", (ExternalSystemSourceType)ExternalSystemSourceType.TEST));
        clone.setTestResourcesDir(CommonGradleProjectResolverExtension.getGradleOutputDir((ExternalProject)externalProject, (String)"test", (ExternalSystemSourceType)ExternalSystemSourceType.TEST_RESOURCE));
        return clone;
    }

    @Nullable
    private static ExtIdeaCompilerOutput getCompilerOutput(@Nullable ExternalProject externalProject) {
        return externalProject != null ? IdeaJavaModuleModelFactory.getCompilerOutputCopy(externalProject) : null;
    }

    @NotNull
    private static Collection<JavaModuleContentRoot> getContentRoots(@NotNull IdeaModule ideaModule) {
        DomainObjectSet contentRoots = ideaModule.getContentRoots();
        ArrayList<JavaModuleContentRoot> javaModuleContentRoots = new ArrayList<JavaModuleContentRoot>();
        if (contentRoots != null) {
            for (IdeaContentRoot contentRoot : contentRoots) {
                if (contentRoot == null) continue;
                javaModuleContentRoots.add(JavaModuleContentRoot.copy(contentRoot));
            }
        }
        return javaModuleContentRoots;
    }

    @NotNull
    private static Map<String, Set<File>> getArtifactsByConfiguration(@Nullable ExternalProject externalProject) {
        return externalProject != null ? externalProject.getArtifactsByConfiguration() : Collections.emptyMap();
    }

    @NotNull
    private Pair<Collection<JavaModuleDependency>, Collection<JarLibraryDependency>> getDependencies(@NotNull IdeaModule ideaModule) {
        List dependencies2 = ideaModule.getDependencies().getAll();
        ArrayList<JavaModuleDependency> javaModuleDependencies = new ArrayList<JavaModuleDependency>();
        ArrayList<JarLibraryDependency> jarLibraryDependencies = new ArrayList<JarLibraryDependency>();
        if (dependencies2 != null) {
            for (IdeaDependency dependency : dependencies2) {
                JavaModuleDependency moduleDependency;
                if (dependency instanceof IdeaSingleEntryLibraryDependency) {
                    JarLibraryDependency libraryDependency = this.myIdeaJarLibraryDependencyFactory.create((IdeaSingleEntryLibraryDependency)dependency);
                    if (libraryDependency == null) continue;
                    jarLibraryDependencies.add(libraryDependency);
                    continue;
                }
                if (!(dependency instanceof IdeaModuleDependency) || StringUtil.equalsIgnoreCase((CharSequence)dependency.getScope().getScope(), (CharSequence)"RUNTIME") || (moduleDependency = JavaModuleDependency.copy(ideaModule.getProject(), (IdeaModuleDependency)dependency)) == null) continue;
                javaModuleDependencies.add(moduleDependency);
            }
        }
        return Pair.create(javaModuleDependencies, jarLibraryDependencies);
    }

    @Nullable
    private static String getLanguageLevel(@Nullable ExternalProject externalProject) {
        if (externalProject == null) {
            return null;
        }
        ExternalSourceSet mainSourceSet = (ExternalSourceSet)externalProject.getSourceSets().get("main");
        return mainSourceSet == null ? null : mainSourceSet.getSourceCompatibility();
    }
}

