/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.ide.common.build.GenericBuiltArtifacts;
import com.android.ide.common.gradle.model.GradleModelConverterUtil;
import com.android.ide.common.gradle.model.IdeAaptOptions;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeApiVersion;
import com.android.ide.common.gradle.model.IdeBuildTypeContainer;
import com.android.ide.common.gradle.model.IdeDependencies;
import com.android.ide.common.gradle.model.IdeJavaCompileOptions;
import com.android.ide.common.gradle.model.IdeProductFlavor;
import com.android.ide.common.gradle.model.IdeProductFlavorContainer;
import com.android.ide.common.gradle.model.IdeSourceProvider;
import com.android.ide.common.gradle.model.IdeTestOptions;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.repository.GradleVersion;
import com.android.projectmodel.DynamicResourceValue;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.AndroidGradleClassJarProvider;
import com.android.tools.idea.gradle.project.model.AndroidModelFeatures;
import com.android.tools.idea.gradle.project.model.AndroidModelSourceProviderUtils;
import com.android.tools.idea.gradle.project.model.ClassFileUtil;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.util.GenericBuiltArtifactsWithTimestamp;
import com.android.tools.idea.gradle.util.GradleBuildOutputUtil;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LastBuildOrSyncService;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ClassJarProvider;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Desugaring;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleModel
implements AndroidModel,
ModuleModel {
    public static final String UNINITIALIZED_APPLICATION_ID = "uninitialized.application.id";
    private static final AndroidVersion NOT_SPECIFIED = new AndroidVersion(0, null);
    private static final String ourAndroidSyncVersion = "2020-09-17/1";
    @Nullable
    private transient Module myModule;
    @NotNull
    private ProjectSystemId myProjectSystemId;
    @NotNull
    private String myAndroidSyncVersion;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private final IdeAndroidProject myAndroidProject;
    @NotNull
    private final Map<String, IdeVariant> myCachedVariantsByName;
    @NotNull
    private transient AndroidModelFeatures myFeatures;
    @Nullable
    private transient GradleVersion myModelVersion;
    @NotNull
    private String mySelectedVariantName;
    @Nullable
    private Boolean myOverridesManifestPackage;
    @Nullable
    private transient AndroidVersion myMinSdkVersion;
    @NotNull
    private final transient Map<String, IdeBuildTypeContainer> myBuildTypesByName;
    @NotNull
    private final transient Map<String, IdeProductFlavorContainer> myProductFlavorsByName;
    @NotNull
    private final transient Map<String, GenericBuiltArtifactsWithTimestamp> myGenericBuiltArtifactsMap;

    @Nullable
    public static AndroidModuleModel get(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 != null ? AndroidModuleModel.get(facet2) : null;
    }

    @Nullable
    public static AndroidModuleModel get(@NotNull AndroidFacet androidFacet) {
        AndroidModel androidModel = AndroidModel.get(androidFacet);
        return androidModel instanceof AndroidModuleModel ? (AndroidModuleModel)androidModel : null;
    }

    public static AndroidModuleModel create(@NotNull String moduleName2, @NotNull File rootDirPath, @NotNull IdeAndroidProject androidProject, @NotNull Collection<IdeVariant> cachedVariants, @NotNull String variantName) {
        return new AndroidModuleModel(ourAndroidSyncVersion, moduleName2, rootDirPath, androidProject, cachedVariants.stream().collect(Collectors.toMap(it -> it.getName(), it -> it)), variantName);
    }

    @PropertyMapping(value={"myAndroidSyncVersion", "myModuleName", "myRootDirPath", "myAndroidProject", "myCachedVariantsByName", "mySelectedVariantName"})
    @VisibleForTesting
    AndroidModuleModel(@NotNull String androidSyncVersion, @NotNull String moduleName2, @NotNull File rootDirPath, @NotNull IdeAndroidProject androidProject, @NotNull Map<String, IdeVariant> cachedVariantsByName, @NotNull String variantName) {
        if (!androidSyncVersion.equals(ourAndroidSyncVersion)) {
            throw new IllegalArgumentException(String.format("Attempting to deserialize a model of incompatible version (%s)", androidSyncVersion));
        }
        this.myAndroidSyncVersion = ourAndroidSyncVersion;
        this.myProjectSystemId = GradleUtil.GRADLE_SYSTEM_ID;
        this.myModuleName = moduleName2;
        this.myRootDirPath = rootDirPath;
        this.myAndroidProject = androidProject;
        this.myCachedVariantsByName = cachedVariantsByName;
        this.mySelectedVariantName = this.findVariantToSelect(variantName);
        this.parseAndSetModelVersion();
        this.myFeatures = new AndroidModelFeatures(this.myModelVersion);
        this.myBuildTypesByName = this.myAndroidProject.getBuildTypes().stream().collect(Collectors.toMap(it -> it.getBuildType().getName(), it -> it));
        this.myProductFlavorsByName = this.myAndroidProject.getProductFlavors().stream().collect(Collectors.toMap(it -> it.getProductFlavor().getName(), it -> it));
        this.myGenericBuiltArtifactsMap = new HashMap<String, GenericBuiltArtifactsWithTimestamp>();
    }

    public void setModule(@NotNull Module module2) {
        this.myModule = module2;
    }

    @NotNull
    public IdeDependencies getSelectedMainCompileLevel2Dependencies() {
        IdeAndroidArtifact mainArtifact = this.getMainArtifact();
        return mainArtifact.getLevel2Dependencies();
    }

    @Nullable
    public IdeDependencies getSelectedAndroidTestCompileDependencies() {
        IdeAndroidArtifact androidTestArtifact = this.getSelectedVariant().getAndroidTestArtifact();
        if (androidTestArtifact == null) {
            return null;
        }
        return androidTestArtifact.getLevel2Dependencies();
    }

    @NotNull
    public AndroidModelFeatures getFeatures() {
        return this.myFeatures;
    }

    @Nullable
    public GradleVersion getModelVersion() {
        return this.myModelVersion;
    }

    @NotNull
    public IdeAndroidArtifact getMainArtifact() {
        return this.getSelectedVariant().getMainArtifact();
    }

    @NotNull
    public IdeSourceProvider getDefaultSourceProvider() {
        return this.getAndroidProject().getDefaultConfig().getSourceProvider();
    }

    @NotNull
    public List<IdeSourceProvider> getActiveSourceProviders() {
        return AndroidModelSourceProviderUtils.collectMainSourceProviders(this, this.getSelectedVariant());
    }

    @NotNull
    public List<IdeSourceProvider> getUnitTestSourceProviders() {
        return AndroidModelSourceProviderUtils.collectUnitTestSourceProviders(this, this.getSelectedVariant());
    }

    @NotNull
    public List<IdeSourceProvider> getAndroidTestSourceProviders() {
        return AndroidModelSourceProviderUtils.collectAndroidTestSourceProviders(this, this.getSelectedVariant());
    }

    @NotNull
    public List<IdeSourceProvider> getTestSourceProviders(@NotNull String artifactName) {
        switch (artifactName) {
            case "_android_test_": {
                return AndroidModelSourceProviderUtils.collectAndroidTestSourceProviders(this, this.getSelectedVariant());
            }
            case "_unit_test_": {
                return AndroidModelSourceProviderUtils.collectUnitTestSourceProviders(this, this.getSelectedVariant());
            }
        }
        return ImmutableList.of();
    }

    public boolean variantExists(@NotNull String variantName) {
        return this.myCachedVariantsByName.containsKey(variantName);
    }

    @NotNull
    public List<IdeSourceProvider> getAllSourceProviders() {
        return AndroidModelSourceProviderUtils.collectAllSourceProviders(this);
    }

    @NotNull
    public List<IdeSourceProvider> getAllUnitTestSourceProviders() {
        return AndroidModelSourceProviderUtils.collectAllUnitTestSourceProviders(this);
    }

    @NotNull
    public List<IdeSourceProvider> getAllAndroidTestSourceProviders() {
        return AndroidModelSourceProviderUtils.collectAllAndroidTestSourceProviders(this);
    }

    @Override
    @NotNull
    public String getApplicationId() {
        if (this.myFeatures.isBuildOutputFileSupported()) {
            return this.getApplicationIdUsingCache(this.mySelectedVariantName);
        }
        return this.getSelectedVariant().getMainArtifact().getApplicationId();
    }

    @Override
    @NotNull
    public Set<String> getAllApplicationIds() {
        HashSet<String> ids2 = new HashSet<String>();
        for (IdeVariant variant2 : this.getVariants()) {
            String applicationId2 = this.getApplicationIdUsingCache(variant2.getName());
            if (applicationId2 == UNINITIALIZED_APPLICATION_ID) continue;
            ids2.add(applicationId2);
        }
        return ids2;
    }

    @Override
    public Boolean isDebuggable() {
        IdeBuildTypeContainer buildTypeContainer = this.findBuildType(this.getSelectedVariant().getBuildType());
        if (buildTypeContainer != null) {
            return buildTypeContainer.getBuildType().isDebuggable();
        }
        return null;
    }

    @Override
    @Nullable
    public AndroidVersion getMinSdkVersion() {
        if (this.myMinSdkVersion == null) {
            IdeApiVersion minSdkVersion2 = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
            if (minSdkVersion2 != null && minSdkVersion2.getCodename() != null) {
                IdeApiVersion defaultConfigVersion = this.getAndroidProject().getDefaultConfig().getProductFlavor().getMinSdkVersion();
                if (defaultConfigVersion != null) {
                    minSdkVersion2 = defaultConfigVersion;
                }
                List flavors = this.getSelectedVariant().getProductFlavors();
                for (String flavor : flavors) {
                    IdeProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                    assert (productFlavor != null);
                    IdeApiVersion flavorVersion = productFlavor.getProductFlavor().getMinSdkVersion();
                    if (flavorVersion == null) continue;
                    minSdkVersion2 = flavorVersion;
                    break;
                }
            }
            this.myMinSdkVersion = minSdkVersion2 != null ? AndroidModelSourceProviderUtils.convertVersion(minSdkVersion2, null) : NOT_SPECIFIED;
        }
        return this.myMinSdkVersion != NOT_SPECIFIED ? this.myMinSdkVersion : null;
    }

    @Override
    @Nullable
    public AndroidVersion getRuntimeMinSdkVersion() {
        IdeApiVersion minSdkVersion2 = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
        return minSdkVersion2 != null ? AndroidModelSourceProviderUtils.convertVersion(minSdkVersion2, null) : null;
    }

    @Override
    @Nullable
    public AndroidVersion getTargetSdkVersion() {
        IdeApiVersion targetSdkVersion2 = this.getSelectedVariant().getMergedFlavor().getTargetSdkVersion();
        return targetSdkVersion2 != null ? AndroidModelSourceProviderUtils.convertVersion(targetSdkVersion2, null) : null;
    }

    @Override
    @Nullable
    public Integer getVersionCode() {
        IdeVariant variant2 = this.getSelectedVariant();
        IdeProductFlavor flavor = variant2.getMergedFlavor();
        return flavor.getVersionCode();
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        return this.myProjectSystemId;
    }

    @Nullable
    public IdeBuildTypeContainer findBuildType(@NotNull String name) {
        return this.myBuildTypesByName.get(name);
    }

    @NotNull
    public Set<String> getBuildTypes() {
        return this.myBuildTypesByName.keySet();
    }

    @NotNull
    public Set<String> getProductFlavors() {
        return this.myProductFlavorsByName.keySet();
    }

    @Nullable
    public IdeProductFlavorContainer findProductFlavor(@NotNull String name) {
        return this.myProductFlavorsByName.get(name);
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public File getRootDirPath() {
        return this.myRootDirPath;
    }

    @Override
    public boolean isGenerated(@NotNull VirtualFile file2) {
        VirtualFile buildFolder = VfsUtil.findFileByIoFile((File)this.myAndroidProject.getBuildFolder(), (boolean)false);
        return buildFolder != null && VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file2, (boolean)false);
    }

    @NotNull
    public IdeAndroidProject getAndroidProject() {
        return this.myAndroidProject;
    }

    @NotNull
    public IdeVariant getSelectedVariant() {
        IdeVariant selected = this.myCachedVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        return selected;
    }

    public String getSelectedVariantName() {
        return this.mySelectedVariantName;
    }

    @NotNull
    public ImmutableList<IdeVariant> getVariants() {
        return ImmutableList.copyOf(this.myCachedVariantsByName.values());
    }

    @Nullable
    public IdeVariant findVariantByName(@NotNull String variantName) {
        return this.myCachedVariantsByName.get(variantName);
    }

    public void setSelectedVariantName(@NotNull String name) {
        this.mySelectedVariantName = this.findVariantToSelect(name);
        this.myOverridesManifestPackage = null;
        this.myMinSdkVersion = null;
    }

    @VisibleForTesting
    @NotNull
    String findVariantToSelect(@NotNull String variantName) {
        String newVariantName;
        if (this.myCachedVariantsByName.containsKey(variantName)) {
            newVariantName = variantName;
        } else {
            ArrayList<String> sorted2 = new ArrayList<String>(this.myCachedVariantsByName.keySet());
            Collections.sort(sorted2);
            assert (!this.myCachedVariantsByName.isEmpty()) : "There is no variant model in AndroidModuleModel!";
            newVariantName = (String)sorted2.get(0);
        }
        return newVariantName;
    }

    @NotNull
    public Collection<String> getBuildTypeNames() {
        return this.myBuildTypesByName.keySet();
    }

    @NotNull
    public Collection<String> getProductFlavorNames() {
        return this.myProductFlavorsByName.keySet();
    }

    @NotNull
    public Collection<String> getVariantNames() {
        Set<String> names = this.myAndroidProject.getVariantNames();
        return names != null ? names : this.myCachedVariantsByName.keySet();
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        IdeJavaCompileOptions compileOptions = this.myAndroidProject.getJavaCompileOptions();
        String sourceCompatibility2 = compileOptions.getSourceCompatibility();
        return LanguageLevel.parse((String)sourceCompatibility2);
    }

    @Override
    public boolean overridesManifestPackage() {
        if (this.myOverridesManifestPackage == null) {
            this.myOverridesManifestPackage = this.getAndroidProject().getDefaultConfig().getProductFlavor().getApplicationId() != null;
            IdeVariant variant2 = this.getSelectedVariant();
            List flavors = variant2.getProductFlavors();
            for (String flavor : flavors) {
                IdeProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                assert (productFlavor != null);
                if (productFlavor.getProductFlavor().getApplicationId() == null) continue;
                this.myOverridesManifestPackage = true;
                break;
            }
        }
        return this.myOverridesManifestPackage;
    }

    @Nullable
    public IdeAndroidArtifact getArtifactForAndroidTest() {
        return this.getAndroidProject().getProjectType() == 2 ? this.getSelectedVariant().getMainArtifact() : this.getSelectedVariant().getAndroidTestArtifact();
    }

    @Nullable
    public IdeTestOptions.Execution getTestExecutionStrategy() {
        IdeTestOptions testOptions;
        IdeAndroidArtifact artifact = this.getArtifactForAndroidTest();
        if (artifact != null && (testOptions = artifact.getTestOptions()) != null) {
            return testOptions.getExecution();
        }
        return null;
    }

    private void parseAndSetModelVersion() {
        this.myModelVersion = GradleVersion.tryParse((String)this.myAndroidProject.getModelVersion());
    }

    @Deprecated
    @NotNull
    public List<IdeSourceProvider> getFlavorSourceProviders() {
        IdeVariant selectedVariant = this.getSelectedVariant();
        List productFlavors = selectedVariant.getProductFlavors();
        ArrayList<IdeSourceProvider> providers2 = new ArrayList<IdeSourceProvider>();
        for (String flavor : productFlavors) {
            IdeProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers2.add(productFlavor.getSourceProvider());
        }
        return providers2;
    }

    public void syncSelectedVariantAndTestArtifact(@NotNull AndroidFacet facet2) {
        IdeVariant variant2 = this.getSelectedVariant();
        AndroidFacetProperties state = facet2.getProperties();
        state.SELECTED_BUILD_VARIANT = variant2.getName();
        IdeAndroidArtifact mainArtifact = variant2.getMainArtifact();
        AndroidModuleModel.updateGradleTaskNames(state, mainArtifact);
    }

    private static void updateGradleTaskNames(@NotNull AndroidFacetProperties state, @NotNull IdeAndroidArtifact mainArtifact) {
        state.ASSEMBLE_TASK_NAME = mainArtifact.getAssembleTaskName();
        state.COMPILE_JAVA_TASK_NAME = mainArtifact.getCompileTaskName();
        state.AFTER_SYNC_TASK_NAMES = new HashSet(mainArtifact.getIdeSetupTaskNames());
        state.ASSEMBLE_TEST_TASK_NAME = "";
        state.COMPILE_JAVA_TEST_TASK_NAME = "";
    }

    @Override
    @NotNull
    public ClassJarProvider getClassJarProvider() {
        return new AndroidGradleClassJarProvider();
    }

    @Override
    public boolean isClassFileOutOfDate(@NotNull Module module2, @NotNull String fqcn, @NotNull VirtualFile classFile) {
        return ClassFileUtil.isClassSourceFileNewerThanClassClassFile(module2, fqcn, classFile);
    }

    @Override
    @NotNull
    public Namespacing getNamespacing() {
        IdeAaptOptions.Namespacing namespacing = this.myAndroidProject.getAaptOptions().getNamespacing();
        switch (namespacing) {
            case DISABLED: {
                return Namespacing.DISABLED;
            }
            case REQUIRED: {
                return Namespacing.REQUIRED;
            }
        }
        throw new IllegalStateException("Unknown namespacing option: " + namespacing);
    }

    @Override
    @NotNull
    public Set<Desugaring> getDesugaring() {
        GradleVersion version2 = this.getModelVersion();
        if (version2 == null) {
            return Desugaring.NONE;
        }
        return LintClient.getGradleDesugaring((GradleVersion)version2, (LanguageLevel)this.getJavaLanguageLevel(), (boolean)this.myAndroidProject.getJavaCompileOptions().isCoreLibraryDesugaringEnabled());
    }

    @Override
    @NotNull
    public Map<String, DynamicResourceValue> getResValues() {
        return GradleModelConverterUtil.classFieldsToDynamicResourceValues((Map)this.getSelectedVariant().getMainArtifact().getResValues());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String getApplicationIdUsingCache(@NotNull String variantName) {
        Map<String, GenericBuiltArtifactsWithTimestamp> map2 = this.myGenericBuiltArtifactsMap;
        synchronized (map2) {
            GenericBuiltArtifacts artifacts;
            GenericBuiltArtifactsWithTimestamp artifactsWithTimestamp = this.myGenericBuiltArtifactsMap.get(variantName);
            long lastSyncOrBuild = Long.MAX_VALUE;
            if (this.myModule != null) {
                lastSyncOrBuild = ((LastBuildOrSyncService)ServiceManager.getService((Project)this.myModule.getProject(), LastBuildOrSyncService.class)).getLastBuildOrSyncTimeStamp();
            } else {
                Logger.getInstance(AndroidModuleModel.class).warn("No module set on model named: " + this.myModuleName);
            }
            if (artifactsWithTimestamp == null || lastSyncOrBuild >= artifactsWithTimestamp.getTimeStamp()) {
                artifactsWithTimestamp = new GenericBuiltArtifactsWithTimestamp(GradleBuildOutputUtil.getGenericBuiltArtifact(this, variantName), System.currentTimeMillis());
                this.myGenericBuiltArtifactsMap.put(variantName, artifactsWithTimestamp);
            }
            if ((artifacts = artifactsWithTimestamp.getGenericBuiltArtifacts()) == null) {
                return UNINITIALIZED_APPLICATION_ID;
            }
            return artifacts.getApplicationId();
        }
    }
}

