/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.ide.common.repository.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModelFeatures {
    @Nullable
    private final GradleVersion myModelVersion;
    private final boolean myIssueReportingSupported;
    private final boolean myShadersSupported;
    private final boolean myTestedTargetVariantsSupported;
    private final boolean myProductFlavorVersionSuffixSupported;
    private final boolean myExternalBuildSupported;
    private final boolean myConstraintLayoutSdkLocationSupported;
    private final boolean myLayoutRenderingIssuePresent;
    private final boolean myBuildOutputFileSupported;
    private final boolean myPostBuildSyncSupported;
    private final boolean myExportDependencies;
    private final boolean myVfsRefreshRequired;
    private final boolean mySingleVariantSyncSupported;

    public AndroidModelFeatures(@Nullable GradleVersion modelVersion) {
        boolean isPre3dot0Version;
        this.myModelVersion = modelVersion;
        this.myIssueReportingSupported = this.modelVersionIsAtLeast("1.1.0");
        this.myShadersSupported = this.modelVersionIsAtLeast("2.1.0");
        this.myConstraintLayoutSdkLocationSupported = this.myModelVersion != null && this.myModelVersion.compareTo("2.1.0") > 0;
        this.myProductFlavorVersionSuffixSupported = this.myExternalBuildSupported = this.modelVersionIsAtLeast("2.2.0");
        this.myTestedTargetVariantsSupported = this.myExternalBuildSupported;
        this.myBuildOutputFileSupported = this.modelVersionIsAtLeast("4.1.0");
        if (modelVersion != null) {
            this.myLayoutRenderingIssuePresent = modelVersion.getMajor() == 1 && modelVersion.getMinor() == 2 && modelVersion.getMicro() <= 2;
            this.myPostBuildSyncSupported = this.modelVersionIsAtLeast("3.0.0") && !this.modelVersionIsAtLeast("4.1.0");
        } else {
            this.myLayoutRenderingIssuePresent = false;
            this.myPostBuildSyncSupported = false;
        }
        this.myExportDependencies = isPre3dot0Version = !this.modelVersionIsAtLeast("3.0.0");
        this.myVfsRefreshRequired = isPre3dot0Version;
        this.mySingleVariantSyncSupported = this.modelVersionIsAtLeast("3.3.0");
    }

    private boolean modelVersionIsAtLeast(@NotNull String revision) {
        return this.myModelVersion != null && this.myModelVersion.compareIgnoringQualifiers(revision) >= 0;
    }

    public boolean isIssueReportingSupported() {
        return this.myIssueReportingSupported;
    }

    public boolean isShadersSupported() {
        return this.myShadersSupported;
    }

    public boolean isTestedTargetVariantsSupported() {
        return this.myTestedTargetVariantsSupported;
    }

    public boolean isProductFlavorVersionSuffixSupported() {
        return this.myProductFlavorVersionSuffixSupported;
    }

    public boolean isExternalBuildSupported() {
        return this.myExternalBuildSupported;
    }

    public boolean isConstraintLayoutSdkLocationSupported() {
        return this.myConstraintLayoutSdkLocationSupported;
    }

    public boolean isLayoutRenderingIssuePresent() {
        return this.myLayoutRenderingIssuePresent;
    }

    public boolean isPostBuildSyncSupported() {
        return this.myPostBuildSyncSupported;
    }

    public boolean isBuildOutputFileSupported() {
        return this.myBuildOutputFileSupported;
    }

    public boolean shouldExportDependencies() {
        return this.myExportDependencies;
    }

    public boolean isVfsRefreshAfterBuildRequired() {
        return this.myVfsRefreshRequired;
    }

    public boolean isSingleVariantSyncSupported() {
        return this.mySingleVariantSyncSupported;
    }
}

