/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.importing.ProjectFolder;
import com.android.tools.idea.gradle.project.importing.TopLevelModuleFactory;
import com.android.tools.idea.gradle.project.sync.SdkSync;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.util.ToolWindows;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;

public class GradleProjectImporter {
    public static final ProjectType ANDROID_PROJECT_TYPE = new ProjectType("Android");
    @NonNls
    private static final String SHOW_UNLINKED_GRADLE_POPUP = "show.inlinked.gradle.project.popup";
    @NotNull
    private final SdkSync mySdkSync;
    @NotNull
    private final ProjectFolder.Factory myProjectFolderFactory;
    @NotNull
    private final TopLevelModuleFactory myTopLevelModuleFactory;

    @NotNull
    public static GradleProjectImporter getInstance() {
        return (GradleProjectImporter)ServiceManager.getService(GradleProjectImporter.class);
    }

    public GradleProjectImporter() {
        this(SdkSync.getInstance(), new TopLevelModuleFactory(), new ProjectFolder.Factory());
    }

    @NonInjectable
    @VisibleForTesting
    GradleProjectImporter(@NotNull SdkSync sdkSync, @NotNull TopLevelModuleFactory topLevelModuleFactory, @NotNull ProjectFolder.Factory projectFolderFactory) {
        this.mySdkSync = sdkSync;
        this.myTopLevelModuleFactory = topLevelModuleFactory;
        this.myProjectFolderFactory = projectFolderFactory;
    }

    @Nullable
    public Project importAndOpenProjectCore(@Nullable Project projectToClose, boolean forceOpenInNewFrame, @NotNull VirtualFile projectFolder) {
        Project newProject;
        File projectFolderPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectFolder);
        try {
            this.setUpLocalProperties(projectFolderPath);
            String projectName = projectFolder.getName();
            newProject = this.createProject(projectName, projectFolderPath);
            this.importProjectNoSync(new Request(newProject));
            PlatformProjectOpenProcessor.openExistingProject((Path)projectFolderPath.toPath(), (Path)projectFolderPath.toPath(), (OpenProjectTask)new OpenProjectTask(forceOpenInNewFrame, projectToClose, false, false, newProject, null, true, null, null, -1, -1, true, false, true, null, false, false, null, null, null));
        }
        catch (Throwable e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
            }
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            this.getLogger().error(e);
            newProject = null;
        }
        return newProject;
    }

    private void setUpLocalProperties(@NotNull File projectFolderPath) throws IOException {
        try {
            LocalProperties localProperties = new LocalProperties(projectFolderPath);
            if (IdeInfo.getInstance().isAndroidStudio()) {
                this.mySdkSync.syncIdeAndProjectAndroidSdks(localProperties);
            }
        }
        catch (IOException e) {
            this.getLogger().info("Failed to sync SDKs", (Throwable)e);
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            throw e;
        }
    }

    @NotNull
    private Logger getLogger() {
        return Logger.getInstance(this.getClass());
    }

    public void importProjectNoSync(@NotNull Request request) throws IOException {
        File projectFolderPath = Projects.getBaseDirPath((Project)request.project).getAbsoluteFile();
        ProjectFolder projectFolder = this.myProjectFolderFactory.create(projectFolderPath);
        projectFolder.createTopLevelBuildFile();
        projectFolder.createIdeaProjectFolder();
        Project newProject = request.project;
        GradleProjectInfo projectInfo = GradleProjectInfo.getInstance(newProject);
        projectInfo.setNewProject(request.isNewProject);
        projectInfo.setImportedProject(true);
        GradleProjectImporter.silenceUnlinkedGradleProjectNotificationIfNecessary(newProject);
        WriteAction.runAndWait(() -> {
            LanguageLevelProjectExtension extension;
            Sdk jdk = IdeSdks.getInstance().getJdk();
            if (jdk != null) {
                ProjectRootManager.getInstance((Project)newProject).setProjectSdk(jdk);
            }
            if (request.javaLanguageLevel != null && (extension = LanguageLevelProjectExtension.getInstance((Project)newProject)) != null) {
                extension.setLanguageLevel(request.javaLanguageLevel);
            }
            File compilerOutputFolderPath = new File(Projects.getBaseDirPath((Project)newProject), FileUtil.join((String[])new String[]{"build", "classes"}));
            String compilerOutputFolderUrl = FilePaths.pathToIdeaUrl((File)compilerOutputFolderPath);
            CompilerProjectExtension compilerProjectExt = CompilerProjectExtension.getInstance((Project)newProject);
            assert (compilerProjectExt != null);
            compilerProjectExt.setCompilerOutputUrl(compilerOutputFolderUrl);
            ProjectTypeService.setProjectType((Project)newProject, (ProjectType)ANDROID_PROJECT_TYPE);
            this.myTopLevelModuleFactory.createTopLevelModule(newProject);
        });
        ExternalSystemUtil.invokeLater((Project)newProject, () -> ToolWindows.activateProjectView(newProject));
    }

    @NotNull
    public Project createProject(@NotNull String projectName, @NotNull File projectFolderPath) {
        try (AccessToken ignored = GradleProjectInfo.beginInitializingGradleProjectAt(projectFolderPath);){
            ProjectManager projectManager = ProjectManager.getInstance();
            Project newProject = projectManager.createProject(projectName, projectFolderPath.getPath());
            if (newProject == null) {
                throw new NullPointerException("Failed to create a new project");
            }
            GradleProjectImporter.configureNewProject(newProject);
            Project project = newProject;
            return project;
        }
    }

    @VisibleForTesting
    public static void configureNewProject(Project newProject) {
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)newProject);
        String externalProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)newProject.getBasePath());
        if (!gradleSettings.getLinkedProjectsSettings().isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                throw new IllegalStateException("configureNewProject should be used with new projects only");
            }
            for (GradleProjectSettings setting : gradleSettings.getLinkedProjectsSettings()) {
                gradleSettings.unlinkExternalProject(setting.getExternalProjectPath());
            }
        }
        GradleProjectSettings projectSettings = new GradleProjectSettings();
        GradleProjectImportUtil.setupGradleSettings((GradleSettings)gradleSettings);
        GradleProjectImportUtil.setupGradleProjectSettings((GradleProjectSettings)projectSettings, (Path)new File(externalProjectPath).toPath());
        GradleJvmResolutionUtil.setupGradleJvm((Project)newProject, (GradleProjectSettings)projectSettings, (GradleVersion)projectSettings.resolveGradleVersion());
        projectSettings.setGradleJvm("#USE_PROJECT_JDK");
        gradleSettings.setStoreProjectFilesExternally(false);
        ExternalSystemApiUtil.getSettings((Project)newProject, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)projectSettings);
    }

    private static void silenceUnlinkedGradleProjectNotificationIfNecessary(Project newProject) {
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)newProject);
        if (gradleSettings.getLinkedProjectsSettings().isEmpty()) {
            PropertiesComponent.getInstance((Project)newProject).setValue(SHOW_UNLINKED_GRADLE_POPUP, false, true);
        }
    }

    public static class Request {
        @NotNull
        public final Project project;
        @Nullable
        public LanguageLevel javaLanguageLevel;
        public boolean isNewProject;

        public Request(@NotNull Project project) {
            this.project = project;
        }
    }
}

