/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker.messages;

import com.android.tools.idea.gradle.project.build.invoker.messages.GradleBuildTreeStructure;
import com.android.tools.idea.gradle.project.build.invoker.messages.GradleBuildTreeViewConfiguration;
import com.android.tools.idea.gradle.project.build.invoker.messages.MessageTreeRenderer;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.ErrorViewTreeBuilder;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.MultilineTreeCellRenderer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Container;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildTreeViewPanel
extends NewErrorTreeViewPanel {
    private final GradleBuildTreeStructure myTreeStructure;
    private final ErrorViewTreeBuilder myBuilder;
    private final GradleBuildTreeViewConfiguration myConfiguration;
    private volatile boolean myDisposed;

    public GradleBuildTreeViewPanel(@NotNull Project project) {
        super(project, null);
        this.myConfiguration = GradleBuildTreeViewConfiguration.getInstance(project);
        this.myTreeStructure = new GradleBuildTreeStructure(this.myProject, this.myConfiguration);
        DefaultTreeModel model2 = (DefaultTreeModel)this.myTree.getModel();
        this.myBuilder = new ErrorViewTreeBuilder((JTree)this.myTree, model2, (AbstractTreeStructure)this.myTreeStructure);
        super.dispose();
        JScrollPane scrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)this.myTree);
        assert (scrollPane != null);
        this.myTree.getParent().remove((Component)this.myTree);
        Container parent = scrollPane.getParent();
        assert (parent instanceof JPanel);
        parent.remove(scrollPane);
        scrollPane = MultilineTreeCellRenderer.installRenderer((JTree)this.myTree, (MultilineTreeCellRenderer)new MessageTreeRenderer());
        parent.add((Component)scrollPane, "Center");
        new TreeSpeedSearch(this.myTree, (Convertor)new Convertor<TreePath, String>(){

            public String convert(TreePath treePath) {
                ErrorTreeElement e;
                Object[] text2;
                Object data;
                Object last = treePath.getLastPathComponent();
                if (last instanceof DefaultMutableTreeNode && (data = ((DefaultMutableTreeNode)last).getUserObject()) instanceof ErrorTreeNodeDescriptor && (text2 = (e = ((ErrorTreeNodeDescriptor)data).getElement()).getText()) != null) {
                    return Joiner.on((char)' ').join(text2);
                }
                return "";
            }
        });
    }

    @Nullable
    private GradleBuildTreeViewConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    protected boolean canHideWarnings() {
        return false;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myTreeStructure.clear();
        Disposer.dispose((Disposable)this.myBuilder);
    }

    public void updateTree() {
        if (!this.myDisposed) {
            this.myBuilder.updateTree();
        }
    }

    public void reload() {
        this.myBuilder.updateTree();
    }

    public void addMessage(int type, @NotNull String[] text2, @Nullable VirtualFile underFileGroup, @Nullable VirtualFile file2, int line2, int column, @Nullable Object data) {
        if (this.myDisposed) {
            return;
        }
        ErrorTreeElementKind kind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type);
        this.myTreeStructure.addMessage(kind, text2, underFileGroup, file2, line2, column, data);
        this.myBuilder.updateTree();
    }

    public void addMessage(int type, @NotNull String[] text2, @Nullable String groupName, @NotNull Navigatable navigatable, @Nullable String exportTextPrefix, @Nullable String rendererTextPrefix, @Nullable Object data) {
        VirtualFile file2;
        if (this.myDisposed) {
            return;
        }
        VirtualFile virtualFile = file2 = data instanceof VirtualFile ? (VirtualFile)data : null;
        if (file2 == null && navigatable instanceof OpenFileDescriptor) {
            file2 = ((OpenFileDescriptor)navigatable).getFile();
        }
        ErrorTreeElementKind kind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type);
        this.myTreeStructure.addNavigatableMessage(groupName, navigatable, kind, text2, data, Strings.nullToEmpty((String)exportTextPrefix), Strings.nullToEmpty((String)rendererTextPrefix), file2);
        this.myBuilder.updateTree();
    }

    public GradleBuildTreeStructure getErrorViewStructure() {
        return this.myTreeStructure;
    }

    public void selectFirstMessage() {
        ErrorTreeElement firstError = this.myTreeStructure.getFirstMessage(ErrorTreeElementKind.ERROR);
        if (firstError != null) {
            this.selectElement(firstError, new Runnable(){

                @Override
                public void run() {
                    if (GradleBuildTreeViewPanel.this.shouldShowFirstErrorInEditor() && !ApplicationManager.getApplication().isUnitTestMode()) {
                        GradleBuildTreeViewPanel.this.navigateToSource(false);
                    }
                }
            });
        } else {
            TreeUtil.promiseSelectFirst((JTree)this.myTree);
        }
    }

    protected boolean shouldShowFirstErrorInEditor() {
        return true;
    }

    private void selectElement(@NotNull ErrorTreeElement element2, @Nullable Runnable onDone) {
        this.myBuilder.select((Object)element2, onDone);
    }

    private void navigateToSource(boolean focusEditor) {
        NavigatableMessageElement element2 = this.getSelectedMessageElement();
        if (element2 == null) {
            return;
        }
        Navigatable navigatable = element2.getNavigatable();
        if (navigatable.canNavigate()) {
            navigatable.navigate(focusEditor);
        }
    }

    @Nullable
    private NavigatableMessageElement getSelectedMessageElement() {
        ErrorTreeElement selectedElement = this.getSelectedErrorTreeElement();
        return selectedElement instanceof NavigatableMessageElement ? (NavigatableMessageElement)selectedElement : null;
    }

    private class FilterMessagesByKindAction
    extends ToggleAction {
        @NotNull
        private final ErrorTreeElementKind myElementKind;

        FilterMessagesByKindAction(ErrorTreeElementKind elementKind) {
            super(StringUtil.capitalize((String)elementKind.toString().toLowerCase(Locale.getDefault())));
            this.myElementKind = elementKind;
        }

        public boolean isSelected(AnActionEvent e) {
            GradleBuildTreeViewConfiguration configuration = GradleBuildTreeViewPanel.this.getConfiguration();
            if (configuration == null) {
                return false;
            }
            return configuration.canShow(this.myElementKind);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            GradleBuildTreeViewPanel.this.myConfiguration.update(this.myElementKind, state);
            GradleBuildTreeViewPanel.this.myBuilder.updateTree();
        }
    }
}

