/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleTaskFinder;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.util.BuildMode;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectTaskRunner
extends ProjectTaskRunner {
    public void run(@NotNull Project project, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback2, @NotNull Collection<? extends ProjectTask> tasks) {
        Map moduleBuildTasksMap = StreamEx.of(tasks).select(ModuleBuildTask.class).partitioningBy(task2 -> task2.isIncrementalBuild());
        MergedProjectTaskNotification aggregatedCallback = callback2 == null ? null : new MergedProjectTaskNotification(callback2, 2);
        this.executeTasks(project, BuildMode.REBUILD, (List)moduleBuildTasksMap.get(Boolean.FALSE), aggregatedCallback);
        this.executeTasks(project, BuildMode.COMPILE_JAVA, (List)moduleBuildTasksMap.get(Boolean.TRUE), aggregatedCallback);
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        Module module2;
        return projectTask instanceof ModuleBuildTask && (GradleFacet.getInstance(module2 = ((ModuleBuildTask)projectTask).getModule()) != null || JavaFacet.getInstance(module2) != null);
    }

    private void executeTasks(@NotNull Project project, @NotNull BuildMode buildMode, List<ModuleBuildTask> moduleBuildTasks, @Nullable ProjectTaskNotification callback2) {
        Module[] modules = (Module[])moduleBuildTasks.stream().map(task2 -> task2.getModule()).toArray(Module[]::new);
        if (modules.length == 0) {
            if (callback2 != null) {
                callback2.finished(new ProjectTaskResult(false, 0, 0));
            }
            return;
        }
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)modules[0]);
        if (rootProjectPath == null) {
            if (callback2 != null) {
                callback2.finished(new ProjectTaskResult(false, 1, 0));
            }
            return;
        }
        File projectPath = new File(rootProjectPath);
        String projectName = projectPath.isFile() ? projectPath.getParentFile().getName() : projectPath.getName();
        String executionName = "Build " + projectName;
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(modules, buildMode, TestCompileType.ALL);
        GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(project);
        Set rootPaths = tasks.keys().elementSet();
        if (rootPaths.isEmpty()) {
            if (callback2 != null) {
                callback2.finished(new ProjectTaskResult(false, 1, 0));
            }
            return;
        }
        final MergedProjectTaskNotification aggregatedCallback = callback2 == null ? null : new MergedProjectTaskNotification(callback2, rootPaths.size());
        for (Path projectRootPath : rootPaths) {
            GradleBuildInvoker.Request request = new GradleBuildInvoker.Request(project, projectRootPath.toFile(), tasks.get((Object)projectRootPath));
            BuildSettings.getInstance(project).setBuildMode(buildMode);
            request.waitForCompletion();
            ExternalSystemTaskNotificationListener buildTaskListener = gradleBuildInvoker.createBuildTaskListener(request, executionName);
            Object listenerDelegate = aggregatedCallback == null ? buildTaskListener : new ExternalSystemTaskNotificationListenerAdapter(buildTaskListener){

                public void onSuccess(@NotNull ExternalSystemTaskId id) {
                    super.onSuccess(id);
                    aggregatedCallback.finished(new ProjectTaskResult(false, 0, 0));
                }

                public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                    super.onFailure(id, e);
                    aggregatedCallback.finished(new ProjectTaskResult(false, 1, 0));
                }

                public void onCancel(@NotNull ExternalSystemTaskId id) {
                    super.onCancel(id);
                    aggregatedCallback.finished(new ProjectTaskResult(true, 0, 0));
                }
            };
            request.setTaskListener((ExternalSystemTaskNotificationListener)listenerDelegate);
            gradleBuildInvoker.executeTasks(request);
        }
    }

    private static class MergedProjectTaskNotification
    implements ProjectTaskNotification {
        private final ProjectTaskNotification myCallback;
        private final AtomicInteger myResultsCounter = new AtomicInteger(0);
        private final int myExpectedResults;
        private boolean myAborted;
        private int myErrors;
        private int myWarnings;

        MergedProjectTaskNotification(ProjectTaskNotification callback2, int expectedResults) {
            this.myCallback = callback2;
            this.myExpectedResults = expectedResults;
        }

        public void finished(@NotNull ProjectTaskResult executionResult) {
            int finished2 = this.myResultsCounter.incrementAndGet();
            if (executionResult.isAborted()) {
                this.myAborted = true;
            }
            this.myErrors += executionResult.getErrors();
            this.myWarnings += executionResult.getWarnings();
            if (finished2 == this.myExpectedResults) {
                this.myCallback.finished(new ProjectTaskResult(this.myAborted, this.myErrors, this.myWarnings));
            }
        }
    }
}

