/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectImportUtil {
    private static final Logger LOG = Logger.getInstance(ProjectImportUtil.class);
    private static final String[] GRADLE_SUPPORTED_FILES = new String[]{"build.gradle", "build.gradle.kts", "settings.gradle", "settings.gradle.kts"};

    private ProjectImportUtil() {
    }

    public static VirtualFile findGradleTarget(@NotNull VirtualFile file2) {
        return ProjectImportUtil.findMatch(file2, GRADLE_SUPPORTED_FILES);
    }

    @Nullable
    public static VirtualFile findMatch(@NotNull VirtualFile location, String ... validNames) {
        if (location.isDirectory()) {
            for (VirtualFile child : location.getChildren()) {
                for (String name : validNames) {
                    if (!name.equals(child.getName())) continue;
                    return child;
                }
            }
        } else {
            for (String name : validNames) {
                if (!name.equals(location.getName())) continue;
                return location;
            }
        }
        return null;
    }
}

