/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleDslWriter;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.configurations.ConfigurationsDslElement;
import com.android.tools.idea.gradle.dsl.parser.crashlytics.CrashlyticsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.ElementState;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementEnum;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslGlobalValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslParser;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslWriter;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.kotlin.KotlinDslParser;
import com.android.tools.idea.gradle.dsl.parser.kotlin.KotlinDslWriter;
import com.android.tools.idea.gradle.dsl.parser.plugins.PluginsDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public abstract class GradleDslFile
extends GradlePropertiesDslElement {
    @NotNull
    private final GradlePropertiesDslElement.ElementList myGlobalProperties = new GradlePropertiesDslElement.ElementList();
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<GradleDslFile> myChildModuleDslFiles = Sets.newHashSet();
    @NotNull
    private final GradleDslWriter myGradleDslWriter;
    @NotNull
    private final GradleDslParser myGradleDslParser;
    @Nullable
    private GradleDslFile myParentModuleDslFile;
    @Nullable
    private GradleDslFile mySiblingDslFile;
    @Nullable
    private ApplyDslElement myApplyDslElement;
    @NotNull
    private final BuildModelContext myBuildModelContext;
    public static final ImmutableMap<String, PropertiesElementDescription> CHILD_PROPERTIES_ELEMENTS_MAP = (ImmutableMap)Stream.of({"android", AndroidDslElement.ANDROID}, {"buildscript", BuildScriptDslElement.BUILDSCRIPT}, {"configurations", ConfigurationsDslElement.CONFIGURATIONS}, {"crashlytics", CrashlyticsDslElement.CRASHLYTICS}, {"dependencies", DependenciesDslElement.DEPENDENCIES}, {"ext", ExtDslElement.EXT}, {"java", JavaDslElement.JAVA}, {"repositories", RepositoriesDslElement.REPOSITORIES}, {"subprojects", SubProjectsDslElement.SUBPROJECTS}, {"plugins", PluginsDslElement.PLUGINS}).collect(ImmutableMap.toImmutableMap(data -> (String)data[0], data -> (PropertiesElementDescription)data[1]));

    @Override
    @NotNull
    protected ImmutableMap<String, PropertiesElementDescription> getChildPropertiesElementsDescriptionMap() {
        return CHILD_PROPERTIES_ELEMENTS_MAP;
    }

    protected GradleDslFile(@NotNull VirtualFile file2, @NotNull Project project, @NotNull String moduleName2, @NotNull BuildModelContext context) {
        super(null, null, GradleNameElement.fake(moduleName2));
        this.myFile = file2;
        this.myProject = project;
        this.myBuildModelContext = context;
        Application application = ApplicationManager.getApplication();
        PsiFile psiFile2 = (PsiFile)application.runReadAction(() -> PsiManager.getInstance((Project)this.myProject).findFile(this.myFile));
        if (psiFile2 instanceof GroovyFile) {
            GroovyFile groovyPsiFile = (GroovyFile)psiFile2;
            this.myGradleDslParser = new GroovyDslParser(groovyPsiFile, this);
            this.myGradleDslWriter = new GroovyDslWriter();
            this.setPsiElement((PsiElement)groovyPsiFile);
        } else if (psiFile2 instanceof KtFile) {
            KtFile ktFile = (KtFile)psiFile2;
            this.myGradleDslParser = new KotlinDslParser(ktFile, this);
            this.myGradleDslWriter = new KotlinDslWriter();
            this.setPsiElement((PsiElement)ktFile);
        } else {
            this.myGradleDslParser = new GradleDslParser.Adapter();
            this.myGradleDslWriter = new GradleDslWriter.Adapter();
        }
        this.populateGlobalProperties();
    }

    private void populateGlobalProperties() {
        GradleDslGlobalValue rootDir = new GradleDslGlobalValue((GradleDslElement)this, Projects.getBaseDirPath((Project)this.myProject).getPath(), "rootDir");
        this.myGlobalProperties.addElement(rootDir, ElementState.DEFAULT, false);
        GradleDslGlobalValue projectDir = new GradleDslGlobalValue((GradleDslElement)this, this.getDirectoryPath().getPath(), "projectDir");
        this.myGlobalProperties.addElement(projectDir, ElementState.DEFAULT, false);
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        Arrays.asList("1_1", "1_2", "1_3", "1_4", "1_5", "1_6", "1_7", "1_8", "1_9", "1_10", "11", "12", "13", "HIGHER").forEach(s -> builder2.put((Object)("VERSION_" + s), (Object)("JavaVersion.VERSION_" + s)));
        ImmutableMap javaVersionValues = builder2.build();
        GradleDslElementEnum javaVersion = new GradleDslElementEnum((GradleDslElement)this, GradleNameElement.fake("JavaVersion"), (Map<String, String>)javaVersionValues);
        this.myGlobalProperties.addElement(javaVersion, ElementState.DEFAULT, false);
    }

    @Override
    protected GradleDslElement getElementWhere(@NotNull Predicate<GradlePropertiesDslElement.ElementList.ElementItem> predicate2) {
        GradleDslElement result2 = super.getElementWhere(predicate2);
        if (result2 == null) {
            result2 = this.myGlobalProperties.getElementWhere(predicate2);
        }
        return result2;
    }

    @Override
    protected GradleDslElement getElementBeforeChildWhere(Predicate<GradlePropertiesDslElement.ElementList.ElementItem> predicate2, @NotNull GradleDslElement element2, boolean includeSelf) {
        GradleDslElement result2 = super.getElementBeforeChildWhere(predicate2, element2, includeSelf);
        if (result2 == null) {
            result2 = this.myGlobalProperties.getElementBeforeChildWhere(predicate2, element2, includeSelf);
        }
        return result2;
    }

    public void reparse() {
        this.clear();
        this.parse();
    }

    public void parse() {
        this.myGradleDslParser.parse();
        this.getContext().getDependencyManager().resolveAllIn(this, true);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public File getDirectoryPath() {
        return VfsUtilCore.virtualToIoFile((VirtualFile)this.getFile().getParent());
    }

    @NotNull
    public List<GradleDslFile> getApplyDslElement() {
        return this.myApplyDslElement == null ? ImmutableList.of() : this.myApplyDslElement.getAppliedDslFiles();
    }

    public void setParentModuleDslFile(@NotNull GradleDslFile parentModuleDslFile) {
        this.myParentModuleDslFile = parentModuleDslFile;
        this.myParentModuleDslFile.myChildModuleDslFiles.add(this);
    }

    @Nullable
    public GradleDslFile getParentModuleDslFile() {
        return this.myParentModuleDslFile;
    }

    @NotNull
    public Collection<GradleDslFile> getChildModuleDslFiles() {
        return this.myChildModuleDslFiles;
    }

    public void setSiblingDslFile(@NotNull GradleDslFile siblingDslFile) {
        this.mySiblingDslFile = siblingDslFile;
    }

    @Nullable
    public GradleDslFile getSiblingDslFile() {
        return this.mySiblingDslFile;
    }

    @NotNull
    public GradleDslWriter getWriter() {
        return this.myGradleDslWriter;
    }

    @NotNull
    public GradleDslParser getParser() {
        return this.myGradleDslParser;
    }

    @NotNull
    public BuildModelContext getContext() {
        return this.myBuildModelContext;
    }

    @Override
    protected void apply() {
        if (this.myApplyDslElement != null) {
            for (GradleDslFile file2 : this.myApplyDslElement.getAppliedDslFiles()) {
                file2.apply();
            }
        }
        super.apply();
    }

    public void registerApplyElement(@NotNull ApplyDslElement applyElement) {
        this.myApplyDslElement = applyElement;
    }

    @NotNull
    public List<BuildModelNotification> getPublicNotifications() {
        return this.myBuildModelContext.getPublicNotifications(this);
    }

    public void saveAllChanges() {
        PsiElement element2 = this.getPsiElement();
        if (element2 == null) {
            return;
        }
        assert (element2 instanceof PsiFile);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Document document = psiDocumentManager.getDocument((PsiFile)element2);
        if (document == null) {
            return;
        }
        if (psiDocumentManager.isDocumentBlockedByPsi(document)) {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        }
        FileDocumentManager.getInstance().saveDocument(document);
        if (!psiDocumentManager.isCommitted(document)) {
            psiDocumentManager.commitDocument(document);
        }
    }

    @Nullable
    public VirtualFile tryToFindSettingsFile() {
        if (this instanceof GradleSettingsFile) {
            return this.getFile();
        }
        for (VirtualFile buildFileParent = this.getFile().getParent(); buildFileParent != null; buildFileParent = buildFileParent.getParent()) {
            VirtualFile maybeSettingsFile = this.myBuildModelContext.getGradleSettingsFile(VfsUtilCore.virtualToIoFile((VirtualFile)buildFileParent));
            if (maybeSettingsFile == null) continue;
            return maybeSettingsFile;
        }
        return null;
    }
}

