/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.ElementState;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslBlockElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ElementSort;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradlePropertiesDslElement
extends GradleDslElementImpl {
    @NotNull
    private static final Predicate<ElementList.ElementItem> VARIABLE_FILTER = e -> ((ElementList.ElementItem)e).myElement.getElementType() == PropertyType.VARIABLE;
    @NotNull
    private static final Predicate<ElementList.ElementItem> PROPERTY_FILTER = VARIABLE_FILTER.negate();
    @NotNull
    private static final Predicate<ElementList.ElementItem> ANY_FILTER = e -> true;
    @NotNull
    private final ElementList myProperties = new ElementList();
    @NotNull
    private static final ImmutableMap<String, PropertiesElementDescription> NO_CHILD_PROPERTIES_ELEMENTS = ImmutableMap.of();

    protected GradlePropertiesDslElement(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name) {
        super(parent, psiElement, name);
    }

    private void addPropertyInternal(@NotNull GradleDslElement element2, @NotNull ElementState state) {
        if (this instanceof ExtDslElement && state == ElementState.TO_BE_ADDED) {
            int index2 = this.reorderAndMaybeGetNewIndex(element2);
            this.myProperties.addElementAtIndex(element2, state, index2, false);
        } else {
            this.myProperties.addElement(element2, state, state == ElementState.EXISTING);
        }
        if (state == ElementState.TO_BE_ADDED) {
            this.updateDependenciesOnAddElement(element2);
            element2.setModified();
        }
    }

    public void addParsedPropertyAsFirstElement(@NotNull GradleDslElement extElement) {
        this.myProperties.addElementAtIndex(extElement, ElementState.EXISTING, 0, true);
    }

    private void addPropertyInternal(int index2, @NotNull GradleDslElement element2, @NotNull ElementState state) {
        this.myProperties.addElementAtIndex(element2, state, index2, state == ElementState.EXISTING);
        if (state == ElementState.TO_BE_ADDED) {
            this.updateDependenciesOnAddElement(element2);
            element2.setModified();
        }
    }

    private void addAppliedProperty(@NotNull GradleDslElement element2) {
        element2.addHolder(this);
        this.addPropertyInternal(element2, ElementState.APPLIED);
    }

    public void addDefaultProperty(@NotNull GradleDslElement element2) {
        element2.setElementType(PropertyType.REGULAR);
        this.addPropertyInternal(element2, ElementState.DEFAULT);
    }

    private void removePropertyInternal(@NotNull String property2) {
        List elements = this.myProperties.removeAll(e -> ((ElementList.ElementItem)e).myElement.getName().equals(property2));
        elements.forEach(e -> {
            e.setModified();
            this.updateDependenciesOnRemoveElement((GradleDslElement)e);
        });
        this.setModified();
    }

    private ElementState removePropertyInternal(@NotNull GradleDslElement element2) {
        element2.setModified();
        ElementState state = this.myProperties.remove(element2);
        this.updateDependenciesOnRemoveElement(element2);
        return state;
    }

    private ElementState replacePropertyInternal(@NotNull GradleDslElement element2, @NotNull GradleDslElement newElement) {
        element2.setModified();
        this.updateDependenciesOnReplaceElement(element2, newElement);
        newElement.setModified();
        ElementState oldState = this.myProperties.replaceElement(element2, newElement);
        this.reorderAndMaybeGetNewIndex(newElement);
        return oldState;
    }

    private void hidePropertyInternal(@NotNull String property2) {
        this.myProperties.hideAll(e -> ((ElementList.ElementItem)e).myElement.getName().equals(property2));
    }

    public void addAppliedModelProperties(@NotNull GradleDslFile file2) {
        this.mergePropertiesFrom(file2);
    }

    private void mergePropertiesFrom(@NotNull GradlePropertiesDslElement other) {
        Map<String, GradleDslElement> ourProperties = this.getPropertyElements();
        for (Map.Entry<String, GradleDslElement> entry : other.getPropertyElements().entrySet()) {
            GradlePropertiesDslElement createdElement;
            GradleDslElement newProperty = entry.getValue();
            if (newProperty instanceof ApplyDslElement) continue;
            if (ourProperties.containsKey(entry.getKey())) {
                GradleDslElement existingProperty = this.getElementWhere(entry.getKey(), PROPERTY_FILTER);
                if (newProperty instanceof GradleDslBlockElement && existingProperty instanceof GradleDslBlockElement) {
                    ((GradlePropertiesDslElement)existingProperty).mergePropertiesFrom((GradlePropertiesDslElement)newProperty);
                    continue;
                }
            } else if (PropertyUtil.isPropertiesElementOrMap(newProperty) && (createdElement = this.getDslFile().getParser().getPropertiesElement(Arrays.asList(entry.getKey().split("\\.")), this, null)) != null) {
                createdElement.mergePropertiesFrom((GradlePropertiesDslElement)newProperty);
                continue;
            }
            this.addAppliedProperty(entry.getValue());
        }
    }

    public void setParsedElement(@NotNull GradleDslElement element2) {
        element2.setParent(this);
        this.addPropertyInternal(element2, ElementState.EXISTING);
    }

    public void addParsedElement(@NotNull GradleDslElement element2) {
        element2.setParent(this);
        this.addPropertyInternal(element2, ElementState.EXISTING);
    }

    protected void addParsedResettingElement(@NotNull GradleDslElement element2, @NotNull String propertyToReset) {
        element2.setParent(this);
        this.addPropertyInternal(element2, ElementState.EXISTING);
        this.hidePropertyInternal(propertyToReset);
    }

    protected void addAsParsedDslExpressionList(@NotNull String property2, @NotNull GradleDslSimpleExpression expression2) {
        PsiElement psiElement = expression2.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList literalList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(property2), true);
        if (expression2 instanceof GradleDslMethodCall) {
            literalList.setPsiElement(((GradleDslMethodCall)expression2).getArgumentListPsiElement());
            for (GradleDslElement gradleDslElement : ((GradleDslMethodCall)expression2).getArguments()) {
                if (!(gradleDslElement instanceof GradleDslSimpleExpression)) continue;
                literalList.addParsedExpression((GradleDslSimpleExpression)gradleDslElement);
            }
        } else {
            literalList.addParsedExpression(expression2);
        }
        this.addPropertyInternal(literalList, ElementState.EXISTING);
    }

    @Nullable
    private static PsiElement mungeElementsForAddToParsedExpressionList(@NotNull GradleDslElement dslElement, @NotNull List<GradleDslElement> newDslElements) {
        PsiElement psiElement = dslElement.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        if (dslElement instanceof GradleDslMethodCall) {
            List<GradleDslExpression> args = ((GradleDslMethodCall)dslElement).getArguments();
            if (!args.isEmpty()) {
                if (args.size() == 1 && args.get(0) instanceof GradleDslExpressionList) {
                    newDslElements.addAll(((GradleDslExpressionList)args.get(0)).getExpressions());
                    PsiElement newElement = args.get(0).getPsiElement();
                    return newElement != null ? newElement : psiElement;
                }
                newDslElements.addAll(args);
                return psiElement;
            }
            return psiElement;
        }
        if (dslElement instanceof GradleDslSimpleExpression) {
            newDslElements.add(dslElement);
            return psiElement;
        }
        if (dslElement instanceof GradleDslExpressionList) {
            newDslElements.addAll(((GradleDslExpressionList)dslElement).getExpressions());
            return psiElement;
        }
        return null;
    }

    public void addToParsedExpressionList(@NotNull String property2, @NotNull GradleDslElement element2) {
        ArrayList<GradleDslElement> newElements = new ArrayList<GradleDslElement>();
        PsiElement psiElement = GradlePropertiesDslElement.mungeElementsForAddToParsedExpressionList(element2, newElements);
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(property2), false);
            this.addPropertyInternal(gradleDslExpressionList, ElementState.EXISTING);
        } else {
            gradleDslExpressionList.setPsiElement(psiElement);
        }
        newElements.forEach(gradleDslExpressionList::addParsedElement);
    }

    public void addToParsedExpressionList(@NotNull ModelPropertyDescription property2, @NotNull GradleDslElement element2) {
        ArrayList<GradleDslElement> newElements = new ArrayList<GradleDslElement>();
        PsiElement psiElement = GradlePropertiesDslElement.mungeElementsForAddToParsedExpressionList(element2, newElements);
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(property2.name), false);
            gradleDslExpressionList.setModelEffect(new ModelEffectDescription(property2, ModelSemanticsDescription.CREATE_WITH_VALUE));
            this.addPropertyInternal(gradleDslExpressionList, ElementState.EXISTING);
        } else {
            gradleDslExpressionList.setPsiElement(psiElement);
        }
        newElements.forEach(gradleDslExpressionList::addParsedElement);
    }

    @NotNull
    protected ImmutableMap<String, PropertiesElementDescription> getChildPropertiesElementsDescriptionMap() {
        return NO_CHILD_PROPERTIES_ELEMENTS;
    }

    @Nullable
    public PropertiesElementDescription getChildPropertiesElementDescription(String name) {
        return (PropertiesElementDescription)this.getChildPropertiesElementsDescriptionMap().get((Object)name);
    }

    @NotNull
    public Set<String> getProperties() {
        return this.getPropertyElements().keySet();
    }

    @NotNull
    public Map<String, GradleDslElement> getPropertyElements() {
        return this.getElementsWhere(PROPERTY_FILTER);
    }

    @NotNull
    public <T extends GradleDslElement> List<T> getPropertyElements(@NotNull String name, @NotNull Class<T> clazz) {
        return this.myProperties.getElementsWhere(GradlePropertiesDslElement.PROPERTY_FILTER).stream().filter(e -> clazz.isAssignableFrom(e.getClass()) && e.getName().equals(name)).map(e -> (GradleDslElement)clazz.cast(e)).collect(Collectors.toList());
    }

    @NotNull
    public List<GradleDslElement> getAllPropertyElements() {
        return this.myProperties.getElementsWhere(GradlePropertiesDslElement.PROPERTY_FILTER);
    }

    @NotNull
    public Map<String, GradleDslElement> getVariableElements() {
        return this.getElementsWhere(VARIABLE_FILTER);
    }

    @NotNull
    public Map<String, GradleDslElement> getElements() {
        return this.getElementsWhere(ANY_FILTER);
    }

    @NotNull
    public List<GradleDslElement> getAllElements() {
        return this.myProperties.getElementsWhere(GradlePropertiesDslElement.ANY_FILTER);
    }

    @NotNull
    private Map<String, GradleDslElement> getElementsWhere(@NotNull Predicate<ElementList.ElementItem> predicate2) {
        LinkedHashMap<String, GradleDslElement> results = new LinkedHashMap<String, GradleDslElement>();
        List elements = this.myProperties.getElementsWhere(predicate2);
        for (GradleDslElement element2 : elements) {
            if (element2 == null) continue;
            results.put(element2.getName(), element2);
        }
        return results;
    }

    private GradleDslElement getElementWhere(@NotNull String name, @NotNull Predicate<ElementList.ElementItem> predicate2) {
        return this.getElementWhere(e -> predicate2.test((ElementList.ElementItem)e) && ((ElementList.ElementItem)e).myElement.getName().equals(name));
    }

    private GradleDslElement getElementWhere(@NotNull ModelPropertyDescription property2, @NotNull Predicate<ElementList.ElementItem> predicate2) {
        return this.getElementWhere(e -> predicate2.test((ElementList.ElementItem)e) && property2.equals(((ElementList.ElementItem)e).myElement.getModelProperty()));
    }

    protected GradleDslElement getElementWhere(@NotNull Predicate<ElementList.ElementItem> predicate2) {
        return this.myProperties.getElementWhere(predicate2);
    }

    private GradleDslElement getElementBeforeChildWhere(@NotNull String name, Predicate<ElementList.ElementItem> predicate2, @NotNull GradleDslElement element2, boolean includeSelf) {
        return this.getElementBeforeChildWhere(e -> predicate2.test((ElementList.ElementItem)e) && ((ElementList.ElementItem)e).myElement.getName().equals(name), element2, includeSelf);
    }

    protected GradleDslElement getElementBeforeChildWhere(Predicate<ElementList.ElementItem> predicate2, @NotNull GradleDslElement element2, boolean includeSelf) {
        return this.myProperties.getElementBeforeChildWhere(predicate2, element2, includeSelf);
    }

    @Nullable
    public GradleDslElement getVariableElement(@NotNull String property2) {
        return this.getElementWhere(property2, VARIABLE_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull String property2) {
        return this.getElementWhere(property2, PROPERTY_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull ModelPropertyDescription property2) {
        return this.getElementWhere(property2, PROPERTY_FILTER);
    }

    @Nullable
    public GradleDslElement getElement(@NotNull String property2) {
        return this.getElementWhere(property2, ANY_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElementBefore(@Nullable GradleDslElement element2, @NotNull String property2, boolean includeSelf) {
        if (element2 == null) {
            return this.getElementWhere(property2, PROPERTY_FILTER);
        }
        return this.getElementBeforeChildWhere(property2, PROPERTY_FILTER, element2, includeSelf);
    }

    @Nullable
    GradleDslElement getElementBefore(@Nullable GradleDslElement element2, @NotNull String property2, boolean includeSelf) {
        if (element2 == null) {
            return this.getElementWhere(property2, ANY_FILTER);
        }
        return this.getElementBeforeChildWhere(property2, ANY_FILTER, element2, includeSelf);
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull String property2, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement = this.getPropertyElement(property2);
        return (T)(clazz.isInstance(propertyElement) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull ModelPropertyDescription property2, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement = this.getPropertyElement(property2);
        return (T)(clazz.isInstance(propertyElement) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    @Nullable
    public <T extends GradlePropertiesDslElement> T getPropertyElement(@NotNull PropertiesElementDescription<T> description2) {
        assert (description2.name != null);
        return (T)((GradlePropertiesDslElement)this.getPropertyElement(description2.name, description2.clazz));
    }

    @NotNull
    public <T extends GradlePropertiesDslElement> T ensurePropertyElement(@NotNull PropertiesElementDescription<T> description2) {
        return this.ensurePropertyElementAt(description2, null);
    }

    @NotNull
    public <T extends GradlePropertiesDslElement, U> T ensurePropertyElementBefore(@NotNull PropertiesElementDescription<T> description2, Class<U> before) {
        Integer at = null;
        List<GradleDslElement> elements = this.getAllElements();
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            if (!before.isInstance(elements.get(i2))) continue;
            at = i2;
            break;
        }
        return this.ensurePropertyElementAt(description2, at);
    }

    @NotNull
    public <T extends GradlePropertiesDslElement> T ensureNamedPropertyElement(PropertiesElementDescription<T> description2, GradleNameElement name) {
        GradlePropertiesDslElement propertyElement = (GradlePropertiesDslElement)this.getPropertyElement(name.name(), description2.clazz);
        if (propertyElement != null) {
            return (T)propertyElement;
        }
        assert (description2.name == null);
        Object newElement = description2.constructor.construct(this, name);
        this.setNewElement((GradleDslElement)newElement);
        return newElement;
    }

    @NotNull
    public <T extends GradlePropertiesDslElement> T ensurePropertyElementAt(PropertiesElementDescription<T> description2, Integer at) {
        T propertyElement = this.getPropertyElement(description2);
        if (propertyElement != null) {
            return propertyElement;
        }
        assert (description2.name != null);
        Object newElement = description2.constructor.construct(this, GradleNameElement.create(description2.name));
        if (at != null) {
            this.addNewElementAt(at, (GradleDslElement)newElement);
        } else {
            this.setNewElement((GradleDslElement)newElement);
        }
        return newElement;
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull List<String> properties2, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement = this.myProperties.getElementWhere(e -> properties2.contains(((ElementList.ElementItem)e).myElement.getName()));
        return (T)(clazz.isInstance(propertyElement) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    @NotNull
    public <T extends GradleDslElement> List<T> getPropertyElements(@NotNull Class<T> clazz) {
        return this.myProperties.getElementsWhere(GradlePropertiesDslElement.PROPERTY_FILTER).stream().filter(e -> clazz.isAssignableFrom(e.getClass())).map(e -> (GradleDslElement)clazz.cast(e)).collect(Collectors.toList());
    }

    @NotNull
    public List<GradleDslElement> getPropertyElementsByName(@NotNull String propertyName) {
        return this.myProperties.getElementsWhere(e -> ((ElementList.ElementItem)e).myElement.getName().equals(propertyName) && GradlePropertiesDslElement.PROPERTY_FILTER.test((ElementList.ElementItem)e));
    }

    @NotNull
    public List<GradleDslElement> getOriginalElements() {
        return this.myProperties.myElements.stream().filter(e -> ((ElementList.ElementItem)e).myExistsOnFile).map(e -> ((ElementList.ElementItem)e).myElement).collect(Collectors.toList());
    }

    @Nullable
    public GradleDslElement getOriginalElementForNameAndType(@NotNull String name, @NotNull PropertyType type) {
        return this.myProperties.myElements.stream().filter(e -> ((ElementList.ElementItem)e).myElement.getName().equals(name) && ((ElementList.ElementItem)e).myExistsOnFile && ((ElementList.ElementItem)e).myElement.getElementType() == type).map(e -> ((ElementList.ElementItem)e).myElement).reduce((a, b) -> b).orElse(null);
    }

    @NotNull
    public List<GradleDslElement> getCurrentElements() {
        Predicate<ElementList.ElementItem> currentElementFilter = e -> ((ElementList.ElementItem)e).myElementState == ElementState.TO_BE_ADDED || ((ElementList.ElementItem)e).myElementState == ElementState.EXISTING || ((ElementList.ElementItem)e).myElementState == ElementState.DEFAULT && ((ElementList.ElementItem)e).myElement instanceof GradlePropertiesDslElement && !((GradlePropertiesDslElement)((ElementList.ElementItem)e).myElement).getCurrentElements().isEmpty();
        return this.myProperties.myElements.stream().filter(currentElementFilter).map(e -> ((ElementList.ElementItem)e).myElement).collect(Collectors.toList());
    }

    @NotNull
    public GradleDslElement setNewElement(@NotNull GradleDslElement newElement) {
        newElement.setParent(this);
        this.addPropertyInternal(newElement, ElementState.TO_BE_ADDED);
        this.setModified();
        return newElement;
    }

    public void addNewElementAt(int index2, @NotNull GradleDslElement newElement) {
        newElement.setParent(this);
        this.addPropertyInternal(index2, newElement, ElementState.TO_BE_ADDED);
        this.setModified();
    }

    public <T> void addNewElementBeforeAllOfClass(@NotNull GradleDslElement newElement, @NotNull Class<T> clazz) {
        List<GradleDslElement> elements = this.getAllElements();
        int index2 = elements.size() - 1;
        for (int i2 = 0; i2 < elements.size() - 1; ++i2) {
            if (!clazz.isInstance(elements.get(i2))) continue;
            index2 = i2;
        }
        this.addNewElementAt(index2, newElement);
    }

    @VisibleForTesting
    public void moveElementTo(int index2, @NotNull GradleDslElement newElement) {
        assert (newElement.getParent() == this);
        this.myProperties.moveElementToIndex(newElement, index2);
    }

    @NotNull
    public GradleDslElement replaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        newElement.setParent(this);
        ArrayList<GradlePropertiesDslElement> holders = new ArrayList<GradlePropertiesDslElement>();
        holders.add(this);
        holders.addAll(oldElement.getHolders());
        for (GradlePropertiesDslElement holder : holders) {
            holder.replacePropertyInternal(oldElement, newElement);
        }
        return newElement;
    }

    @Nullable
    public <T> T getLiteral(@NotNull String property2, @NotNull Class<T> clazz) {
        GradleDslSimpleExpression expression2 = this.getPropertyElement(property2, GradleDslSimpleExpression.class);
        if (expression2 == null) {
            return null;
        }
        return expression2.getValue(clazz);
    }

    @NotNull
    public GradleDslElement setNewLiteral(@NotNull String property2, @NotNull Object value2) {
        return this.setNewLiteralImpl(property2, value2);
    }

    @NotNull
    private GradleDslElement setNewLiteralImpl(@NotNull String property2, @NotNull Object value2) {
        GradleDslLiteral literalElement = this.getPropertyElement(property2, GradleDslLiteral.class);
        if (literalElement == null) {
            literalElement = new GradleDslLiteral(this, GradleNameElement.create(property2));
            this.addPropertyInternal(literalElement, ElementState.TO_BE_ADDED);
        }
        literalElement.setValue(value2);
        return literalElement;
    }

    public void removeProperty(@NotNull String property2) {
        this.removePropertyInternal(property2);
    }

    public void removeProperty(@NotNull GradleDslElement element2) {
        this.removePropertyInternal(element2);
    }

    @Override
    @Nullable
    public GradleDslElement requestAnchor(@NotNull GradleDslElement element2) {
        GradleDslElement lastElement = null;
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            GradleDslElement currentElement;
            if (item.myElement == element2) {
                return lastElement;
            }
            if (!Arrays.asList(ElementState.EXISTING, ElementState.TO_BE_ADDED, ElementState.MOVED).contains((Object)item.myElementState) || (currentElement = item.myElement) instanceof ProjectPropertiesDslElement && ((ProjectPropertiesDslElement)currentElement).getAllPropertyElements().isEmpty()) continue;
            if (item.myElement instanceof ApplyDslElement) {
                lastElement = item.myElement.requestAnchor(element2);
                continue;
            }
            lastElement = item.myElement;
        }
        return lastElement;
    }

    @Override
    @NotNull
    public Collection<GradleDslElement> getChildren() {
        return this.getAllElements();
    }

    @Override
    @NotNull
    public List<GradleDslElement> getContainedElements(boolean includeProperties) {
        ArrayList<GradleDslElement> result2 = new ArrayList<GradleDslElement>();
        if (includeProperties) {
            result2.addAll(this.getElementsWhere(e -> ((ElementList.ElementItem)e).myElementState != ElementState.APPLIED && !((ElementList.ElementItem)e).isDefaultElement()).values());
        } else {
            result2.addAll(this.getVariableElements().values());
        }
        List<GradlePropertiesDslElement> holders = this.getPropertyElements(GradlePropertiesDslElement.class).stream().filter(e -> !(e instanceof GradleDslExpression)).collect(Collectors.toList());
        holders.forEach(e -> result2.addAll(e.getContainedElements(includeProperties)));
        return result2;
    }

    @Override
    protected void apply() {
        this.getDslFile().getWriter().applyDslPropertiesElement(this);
        this.myProperties.removeElements(GradleDslElement::delete);
        this.myProperties.createElements(e -> e.create() != null);
        this.myProperties.applyElements(e -> {
            if (e.isModified()) {
                e.applyChanges();
            }
        });
        this.myProperties.forEach(item -> {
            if (((ElementList.ElementItem)item).myElementState == ElementState.MOVED) {
                ((ElementList.ElementItem)item).myElement.move();
            }
        });
    }

    @Override
    protected void reset() {
        this.myProperties.reset();
    }

    protected void clear() {
        this.myProperties.clear();
    }

    public int reorderAndMaybeGetNewIndex(@NotNull GradleDslElement element2) {
        int result2 = this.sortElementsAndMaybeGetNewIndex(element2);
        element2.resolve();
        return result2;
    }

    private int sortElementsAndMaybeGetNewIndex(@NotNull GradleDslElement element2) {
        List currentElements = this.myProperties.getElementsWhere(e -> ((ElementList.ElementItem)e).myElementState == ElementState.EXISTING || ((ElementList.ElementItem)e).myElementState == ElementState.TO_BE_ADDED);
        ArrayList<GradleDslElement> sortedElements = new ArrayList<GradleDslElement>();
        boolean result2 = ElementSort.create(this, element2).sort(currentElements, sortedElements);
        int resultIndex = this.myProperties.myElements.size();
        if (!result2) {
            this.notification(NotificationTypeReference.PROPERTY_PLACEMENT);
            return resultIndex;
        }
        int i2 = 0;
        int j = 0;
        while (i2 < currentElements.size() && j < sortedElements.size()) {
            if (currentElements.get(i2) == sortedElements.get(i2)) {
                ++i2;
                ++j;
                continue;
            }
            if (sortedElements.get(i2) == element2 && !currentElements.contains(element2)) {
                resultIndex = i2;
                ++j;
                continue;
            }
            this.moveElementTo(i2, (GradleDslElement)sortedElements.get(j));
            ++i2;
            ++j;
        }
        return resultIndex;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        return this.myProperties.getElementsWhere(e -> ((ElementList.ElementItem)e).myElementState != ElementState.APPLIED).stream().map(GradleDslElement::getDependencies).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @VisibleForTesting
    public boolean isApplied(@NotNull GradleDslElement element2) {
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            if (item.myElement != element2) continue;
            return item.myElementState == ElementState.APPLIED;
        }
        throw new IllegalStateException("Element not found in parent");
    }

    protected static class ElementList {
        @NotNull
        private final List<ElementItem> myElements = new ArrayList<ElementItem>();

        private void forEach(@NotNull Consumer<ElementItem> func) {
            this.myElements.forEach(func);
        }

        @NotNull
        private List<GradleDslElement> getElementsWhere(@NotNull Predicate<ElementItem> predicate2) {
            return this.myElements.stream().filter(e -> ((ElementItem)e).myElementState != ElementState.TO_BE_REMOVED && ((ElementItem)e).myElementState != ElementState.HIDDEN).filter(predicate2).map(e -> ((ElementItem)e).myElement).collect(Collectors.toList());
        }

        @Nullable
        public GradleDslElement getElementWhere(@NotNull Predicate<ElementItem> predicate2) {
            return this.myElements.stream().filter(e -> ((ElementItem)e).myElementState != ElementState.TO_BE_REMOVED && ((ElementItem)e).myElementState != ElementState.HIDDEN).filter(predicate2).map(e -> ((ElementItem)e).myElement).reduce((first, second) -> second).orElse(null);
        }

        @Nullable
        public GradleDslElement getElementBeforeChildWhere(@NotNull Predicate<ElementItem> predicate2, @NotNull GradleDslElement child, boolean includeSelf) {
            GradleDslElement lastElement = null;
            for (ElementItem i2 : this.myElements) {
                if (i2.myElementState == ElementState.TO_BE_REMOVED || i2.myElementState == ElementState.HIDDEN) continue;
                if (predicate2.test(i2) && (includeSelf || child != i2.myElement)) {
                    lastElement = i2.myElement;
                }
                if (i2.myElement != child) continue;
                return lastElement;
            }
            return lastElement;
        }

        public void addElement(@NotNull GradleDslElement newElement, @NotNull ElementState state, boolean onFile) {
            this.myElements.add(new ElementItem(newElement, state, onFile));
        }

        private void addElementAtIndex(@NotNull GradleDslElement newElement, @NotNull ElementState state, int index2, boolean onFile) {
            this.myElements.add(this.getRealIndex(index2, newElement), new ElementItem(newElement, state, onFile));
        }

        private void moveElementToIndex(@NotNull GradleDslElement element2, int index2) {
            ElementItem item = this.myElements.stream().filter(e -> ((ElementItem)e).myElement == element2).findFirst().orElse(null);
            if (item == null) {
                return;
            }
            this.myElements.remove(item);
            ElementList.moveElementTree(item);
            this.myElements.add(this.getRealIndex(index2, element2), item);
        }

        private int getRealIndex(int index2, @NotNull GradleDslElement element2) {
            if (index2 <= 0) {
                return 0;
            }
            for (int i2 = 0; i2 < this.myElements.size(); ++i2) {
                if (index2 == 0) {
                    return i2;
                }
                ElementItem item = this.myElements.get(i2);
                if (item.myElementState == ElementState.TO_BE_REMOVED || item.myElementState == ElementState.APPLIED || item.myElementState == ElementState.HIDDEN) continue;
                --index2;
            }
            return this.myElements.size();
        }

        @Nullable
        private ElementState remove(@NotNull GradleDslElement element2) {
            ElementItem item = this.myElements.stream().filter(e -> element2 == ((ElementItem)e).myElement).findFirst().orElse(null);
            if (item == null) {
                return null;
            }
            ElementState oldState = item.myElementState;
            item.myElementState = ElementState.TO_BE_REMOVED;
            return oldState;
        }

        @Nullable
        private ElementState replaceElement(@Nullable GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
            for (int i2 = 0; i2 < this.myElements.size(); ++i2) {
                ElementItem item = this.myElements.get(i2);
                if (oldElement != item.myElement) continue;
                ElementState oldState = item.myElementState;
                item.myElementState = ElementState.TO_BE_REMOVED;
                ElementState newState = ElementState.TO_BE_ADDED;
                if (oldState == ElementState.APPLIED || oldState == ElementState.HIDDEN) {
                    newState = oldState;
                }
                this.myElements.add(i2, new ElementItem(newElement, newState, false));
                return oldState;
            }
            return null;
        }

        @NotNull
        private List<GradleDslElement> removeAll(@NotNull Predicate<ElementItem> filter2) {
            List<ElementItem> toBeRemoved = this.myElements.stream().filter(filter2).collect(Collectors.toList());
            toBeRemoved.forEach((? super T e) -> ((ElementItem)e).myElementState = ElementState.TO_BE_REMOVED);
            return ContainerUtil.map(toBeRemoved, e -> ((ElementItem)e).myElement);
        }

        private void hideAll(@NotNull Predicate<ElementItem> filter2) {
            this.myElements.stream().filter(filter2).forEach((? super T e) -> ((ElementItem)e).myElementState = ElementState.HIDDEN);
        }

        private boolean isEmpty() {
            return this.myElements.isEmpty();
        }

        private void reset() {
            LinkedHashSet<String> seen = new LinkedHashSet<String>();
            Iterator<ElementItem> i2 = this.myElements.iterator();
            while (i2.hasNext()) {
                ElementItem item = i2.next();
                item.myElement.resetState();
                if (item.myElementState == ElementState.TO_BE_REMOVED) {
                    item.myElementState = ElementState.EXISTING;
                }
                if (item.myElementState == ElementState.EXISTING) {
                    seen.add(item.myElement.getName());
                }
                if (item.myElementState == ElementState.TO_BE_ADDED) {
                    i2.remove();
                }
                if (item.myElementState != ElementState.DEFAULT || !seen.contains(item.myElement.getName())) continue;
                i2.remove();
            }
        }

        private void removeElements(@NotNull Consumer<GradleDslElement> removeFunc) {
            Iterator<ElementItem> i2 = this.myElements.iterator();
            while (i2.hasNext()) {
                ElementItem item = i2.next();
                if (item.myElementState != ElementState.TO_BE_REMOVED) continue;
                removeFunc.accept(item.myElement);
                i2.remove();
            }
        }

        private void createElements(@NotNull Predicate<GradleDslElement> addFunc) {
            Iterator<ElementItem> i2 = this.myElements.iterator();
            while (i2.hasNext()) {
                ElementItem item = i2.next();
                if (item.myElementState == ElementState.DEFAULT && !item.isDefaultElement()) {
                    item.myElementState = ElementState.TO_BE_ADDED;
                }
                if (item.myElementState != ElementState.TO_BE_ADDED) continue;
                if (addFunc.test(item.myElement)) {
                    item.myElementState = ElementState.EXISTING;
                    continue;
                }
                i2.remove();
            }
        }

        private void applyElements(@NotNull Consumer<GradleDslElement> func) {
            this.myElements.stream().filter(e -> ((ElementItem)e).myElementState != ElementState.APPLIED).map(e -> ((ElementItem)e).myElement).forEach(func);
        }

        private void clear() {
            this.myElements.clear();
        }

        private static void moveElementTree(@NotNull ElementItem item) {
            if (item.myElementState != ElementState.TO_BE_ADDED) {
                item.myElementState = ElementState.MOVED;
            }
            item.myElement.setModified();
        }

        public static class ElementItem {
            @NotNull
            private GradleDslElement myElement;
            @NotNull
            private ElementState myElementState;
            private boolean myExistsOnFile;

            private ElementItem(@NotNull GradleDslElement element2, @NotNull ElementState state, boolean existsOnFile) {
                this.myElement = element2;
                this.myElementState = state;
                this.myExistsOnFile = existsOnFile;
            }

            private boolean isDefaultElement() {
                return this.myElementState == ElementState.DEFAULT && this.myElement.isInsignificantIfEmpty() && this.myElement instanceof GradlePropertiesDslElement && ((GradlePropertiesDslElement)this.myElement).getCurrentElements().isEmpty();
            }
        }
    }
}

