/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.ModificationAware;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleDslElementImpl
implements GradleDslElement,
ModificationAware {
    @NotNull
    private static final String SINGLE_QUOTES = "'";
    @NotNull
    private static final String DOUBLE_QUOTES = "\"";
    @NotNull
    protected GradleNameElement myName;
    @Nullable
    protected GradleDslElement myParent;
    @NotNull
    protected List<GradlePropertiesDslElement> myHolders = new ArrayList<GradlePropertiesDslElement>();
    @NotNull
    private final GradleDslFile myDslFile;
    @Nullable
    private PsiElement myPsiElement;
    @Nullable
    private GradleDslClosure myClosureElement;
    @Nullable
    private GradleDslClosure myUnsavedClosure;
    private long myLastCommittedModificationCount;
    private long myModificationCount;
    protected boolean myUseAssignment;
    @NotNull
    private PropertyType myElementType;
    @NotNull
    protected final List<GradleReferenceInjection> myDependencies = new ArrayList<GradleReferenceInjection>();
    @NotNull
    protected final List<GradleReferenceInjection> myDependents = new ArrayList<GradleReferenceInjection>();
    @Nullable
    private ModelEffectDescription myModelEffectDescription;

    protected GradleDslElementImpl(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name) {
        assert (parent != null || this instanceof GradleDslFile);
        this.myParent = parent;
        this.myPsiElement = psiElement;
        this.myName = name;
        this.myDslFile = parent == null ? (GradleDslFile)this : parent.getDslFile();
        this.myUseAssignment = false;
        this.myElementType = PropertyType.DERIVED;
    }

    @Override
    public void setParsedClosureElement(@NotNull GradleDslClosure closureElement) {
        this.myClosureElement = closureElement;
    }

    @Override
    public void setNewClosureElement(@Nullable GradleDslClosure closureElement) {
        this.myUnsavedClosure = closureElement;
        this.setModified();
    }

    @Override
    @Nullable
    public GradleDslClosure getUnsavedClosure() {
        return this.myUnsavedClosure;
    }

    @Override
    @Nullable
    public GradleDslClosure getClosureElement() {
        return this.myUnsavedClosure == null ? this.myClosureElement : this.myUnsavedClosure;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myModelEffectDescription == null ? this.myName.name() : this.myModelEffectDescription.property.name;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        if (this.myParent == null || this.myParent instanceof GradleDslFile) {
            return GradleNameElement.escape(this.getName());
        }
        String ourName = this.getName();
        return this.myParent.getQualifiedName() + (ourName.isEmpty() ? "" : "." + GradleNameElement.escape(ourName));
    }

    @Override
    @NotNull
    public String getFullName() {
        if (this.myModelEffectDescription == null) {
            return this.myName.fullName();
        }
        List<String> parts = this.myName.qualifyingParts();
        parts.add(this.getName());
        return GradleNameElement.createNameFromParts(parts);
    }

    @Override
    @NotNull
    public GradleNameElement getNameElement() {
        return this.myName;
    }

    @Override
    public void rename(@NotNull String newName2) {
        this.rename(Arrays.asList(newName2));
    }

    @Override
    public void rename(@NotNull List<String> hierarchicalName) {
        this.myName.rename(hierarchicalName);
        this.setModified();
        if (!(this instanceof GradleDslSimpleExpression)) {
            return;
        }
        List<GradleReferenceInjection> dependents = this.getDependents();
        this.unregisterAllDependants();
        this.reorder();
        dependents.forEach(e -> e.getOriginElement().resolve());
        this.getDslFile().getContext().getDependencyManager().resolveWith(this);
    }

    @Override
    @Nullable
    public GradleDslElement getParent() {
        return this.myParent;
    }

    @Override
    public void setParent(@NotNull GradleDslElement parent) {
        this.myParent = parent;
    }

    @Override
    @NotNull
    public List<GradlePropertiesDslElement> getHolders() {
        return this.myHolders;
    }

    @Override
    public void addHolder(@NotNull GradlePropertiesDslElement holder) {
        this.myHolders.add(holder);
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myPsiElement;
    }

    @Override
    public void setPsiElement(@Nullable PsiElement psiElement) {
        this.myPsiElement = psiElement;
    }

    @Override
    public boolean shouldUseAssignment() {
        return this.myUseAssignment;
    }

    @Override
    public void setUseAssignment(boolean useAssignment) {
        this.myUseAssignment = useAssignment;
    }

    @Override
    @NotNull
    public PropertyType getElementType() {
        return this.myElementType;
    }

    @Override
    public void setElementType(@NotNull PropertyType propertyType) {
        this.myElementType = propertyType;
    }

    @Override
    @NotNull
    public GradleDslFile getDslFile() {
        return this.myDslFile;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (GradleDslElement child : this.getChildren()) {
            resultBuilder.addAll(child.getResolvedVariables());
        }
        return resultBuilder.build();
    }

    @Override
    @Nullable
    public GradleDslElement requestAnchor(@NotNull GradleDslElement element2) {
        return null;
    }

    @Override
    @Nullable
    public GradleDslElement getAnchor() {
        return this.myParent == null ? null : this.myParent.requestAnchor(this);
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.myDslFile.getWriter().createDslElement(this);
    }

    @Override
    @Nullable
    public PsiElement move() {
        return this.myDslFile.getWriter().moveDslElement(this);
    }

    @Override
    public void delete() {
        for (GradleDslElement element2 : this.getChildren()) {
            element2.delete();
        }
        this.getDslFile().getWriter().deleteDslElement(this);
    }

    @Override
    public void setModified() {
        this.modify();
        if (this.myParent != null) {
            this.myParent.setModified();
        }
    }

    @Override
    public boolean isModified() {
        return this.getLastCommittedModificationCount() != this.getModificationCount();
    }

    @Override
    public boolean isBlockElement() {
        return false;
    }

    @Override
    public boolean isInsignificantIfEmpty() {
        return true;
    }

    @Override
    @NotNull
    public abstract Collection<GradleDslElement> getChildren();

    @Override
    public final void applyChanges() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.apply();
        this.commit();
    }

    protected abstract void apply();

    @Override
    public final void resetState() {
        this.reset();
        this.commit();
    }

    protected abstract void reset();

    @Override
    @NotNull
    public List<GradleDslElement> getContainedElements(boolean includeProperties) {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Map<String, GradleDslElement> getInScopeElements() {
        LinkedHashMap<String, GradleDslElement> results = new LinkedHashMap<String, GradleDslElement>();
        if (PropertyUtil.isNonExpressionPropertiesElement(this)) {
            GradlePropertiesDslElement thisElement = (GradlePropertiesDslElement)this;
            results.putAll(thisElement.getVariableElements());
        }
        GradleDslElement currentElement = this;
        while (currentElement != null && currentElement.getParent() != null) {
            if (!PropertyUtil.isNonExpressionPropertiesElement(currentElement = currentElement.getParent())) continue;
            GradlePropertiesDslElement element2 = (GradlePropertiesDslElement)currentElement;
            results.putAll(element2.getVariableElements());
        }
        if (currentElement instanceof GradleDslFile) {
            for (GradleDslFile file2 = (GradleDslFile)currentElement; file2 != null; file2 = file2.getParentModuleDslFile()) {
                ExtDslElement buildScriptExt;
                BuildScriptDslElement buildScriptElement;
                GradleDslFile propertiesFile;
                ExtDslElement ext = file2.getPropertyElement(ExtDslElement.EXT);
                if (ext != null) {
                    results.putAll(ext.getPropertyElements());
                }
                if ((propertiesFile = file2.getSiblingDslFile()) != null) {
                    Map<String, GradleDslElement> filteredProperties = propertiesFile.getPropertyElements().entrySet().stream().filter(entry -> !((String)entry.getKey()).contains(".")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    results.putAll(filteredProperties);
                }
                if ((buildScriptElement = file2.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT)) == null || (buildScriptExt = buildScriptElement.getPropertyElement(ExtDslElement.EXT)) == null) continue;
                results.putAll(buildScriptExt.getPropertyElements());
            }
        }
        return results;
    }

    @Override
    @NotNull
    public <T extends BuildModelNotification> T notification(@NotNull NotificationTypeReference<T> type) {
        return this.getDslFile().getContext().getNotificationForType(this.myDslFile, type);
    }

    @Override
    public void registerDependent(@NotNull GradleReferenceInjection injection) {
        assert (injection.isResolved() && injection.getToBeInjected() == this);
        this.myDependents.add(injection);
    }

    @Override
    public void unregisterDependent(@NotNull GradleReferenceInjection injection) {
        assert (injection.isResolved() && injection.getToBeInjected() == this);
        assert (this.myDependents.contains(injection));
        this.myDependents.remove(injection);
    }

    @Override
    public void unregisterAllDependants() {
        this.myDependents.forEach(e -> {
            e.resolveWith(null);
            this.getDslFile().getContext().getDependencyManager().registerUnresolvedReference((GradleReferenceInjection)e);
        });
        this.myDependents.clear();
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependents() {
        return new ArrayList<GradleReferenceInjection>(this.myDependents);
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        return new ArrayList<GradleReferenceInjection>(this.myDependencies);
    }

    @Override
    public void updateDependenciesOnAddElement(@NotNull GradleDslElement newElement) {
        newElement.resolve();
        newElement.getDslFile().getContext().getDependencyManager().resolveWith(newElement);
    }

    @Override
    public void updateDependenciesOnReplaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        List<GradleReferenceInjection> injections = oldElement.getDependents();
        oldElement.unregisterAllDependants();
        injections.forEach(e -> e.resolveWith(newElement));
        injections.forEach(newElement::registerDependent);
        oldElement.getResolvedVariables().forEach(e -> {
            GradleDslElement toBeInjected = e.getToBeInjected();
            if (toBeInjected != null) {
                toBeInjected.unregisterDependent((GradleReferenceInjection)e);
            }
        });
    }

    @Override
    public void updateDependenciesOnRemoveElement(@NotNull GradleDslElement oldElement) {
        List<GradleReferenceInjection> dependents = oldElement.getDependents();
        oldElement.unregisterAllDependants();
        dependents.forEach(e -> e.getOriginElement().resolve());
        oldElement.getResolvedVariables().forEach(e -> {
            GradleDslElement toBeInjected = e.getToBeInjected();
            if (toBeInjected != null) {
                toBeInjected.unregisterDependent((GradleReferenceInjection)e);
            }
        });
    }

    @Override
    public void resolve() {
    }

    protected void reorder() {
        if (this.myParent instanceof ExtDslElement) {
            ((ExtDslElement)this.myParent).reorderAndMaybeGetNewIndex(this);
        }
    }

    @Override
    public long getModificationCount() {
        return this.myModificationCount;
    }

    public long getLastCommittedModificationCount() {
        return this.myLastCommittedModificationCount;
    }

    @Override
    public void modify() {
        ++this.myModificationCount;
        this.myDependents.forEach(e -> e.getOriginElement().modify());
    }

    public void commit() {
        this.myLastCommittedModificationCount = this.myModificationCount;
    }

    @Nullable
    public static String getPsiText(@NotNull PsiElement psiElement) {
        return (String)ApplicationManager.getApplication().runReadAction(() -> psiElement.getText());
    }

    @Override
    public boolean isNewEmptyBlockElement() {
        if (this.myPsiElement != null) {
            return false;
        }
        if (!this.isBlockElement() || !this.isInsignificantIfEmpty()) {
            return false;
        }
        List<GradleDslElement> children = this.getContainedElements(true);
        if (children.isEmpty()) {
            return true;
        }
        for (GradleDslElement child : children) {
            if (child.isNewEmptyBlockElement()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ImmutableMap<Pair<String, Integer>, ModelEffectDescription> getExternalToModelMap(@NotNull GradleDslNameConverter converter) {
        return ImmutableMap.of();
    }

    @Override
    @Nullable
    public ModelEffectDescription getModelEffect() {
        return this.myModelEffectDescription;
    }

    @Override
    public void setModelEffect(@Nullable ModelEffectDescription effect) {
        this.myModelEffectDescription = effect;
    }

    @Override
    @Nullable
    public ModelPropertyDescription getModelProperty() {
        return this.myModelEffectDescription == null ? null : this.myModelEffectDescription.property;
    }

    @Nullable
    public static GradleDslElement dereference(@NotNull GradleDslElement element2, @NotNull String index2) {
        if (element2 instanceof GradleDslExpressionList) {
            int offset2;
            try {
                offset2 = Integer.parseInt(index2);
            }
            catch (NumberFormatException e) {
                return null;
            }
            GradleDslExpressionList list = (GradleDslExpressionList)element2;
            if (list.getExpressions().size() <= offset2) {
                return null;
            }
            return list.getExpressions().get(offset2);
        }
        if (element2 instanceof GradleDslExpressionMap) {
            GradleDslExpressionMap map2 = (GradleDslExpressionMap)element2;
            index2 = GradleDslElementImpl.stripQuotes(index2);
            return map2.getPropertyElement(index2);
        }
        if (element2 instanceof GradleDslLiteral && ((GradleDslLiteral)element2).isReference()) {
            GradleDslElement value2 = PropertyUtil.followElement((GradleDslLiteral)element2);
            if (value2 == null) {
                return null;
            }
            return GradleDslElementImpl.dereference(value2, index2);
        }
        return null;
    }

    @Nullable
    private static GradleDslElement extractElementFromProperties(@NotNull GradlePropertiesDslElement properties2, @NotNull String name, GradleDslNameConverter converter, boolean sameScope, @Nullable GradleDslElement childElement, boolean includeSelf) {
        Matcher indexMatcher = GradleNameElement.INDEX_PATTERN.matcher(name);
        if (!indexMatcher.find()) {
            ModelPropertyDescription property2 = converter.modelDescriptionForParent(name, properties2);
            String modelName = property2 == null ? name : property2.name;
            return sameScope ? properties2.getElementBefore(childElement, modelName, includeSelf) : properties2.getPropertyElementBefore(childElement, modelName, includeSelf);
        }
        if (indexMatcher.groupCount() != 2) {
            return null;
        }
        String elementName = indexMatcher.group(0);
        if (elementName == null) {
            return null;
        }
        ModelPropertyDescription property3 = converter.modelDescriptionForParent(elementName, properties2);
        String modelName = property3 == null ? elementName : property3.name;
        GradleDslElement element2 = sameScope ? properties2.getElementBefore(childElement, modelName, includeSelf) : properties2.getPropertyElementBefore(childElement, modelName, includeSelf);
        ArrayDeque<String> indexParts = new ArrayDeque<String>();
        while (indexMatcher.find()) {
            if (indexMatcher.groupCount() != 2) {
                return null;
            }
            indexParts.add(indexMatcher.group(1));
        }
        while (!indexParts.isEmpty()) {
            String index2 = (String)indexParts.pop();
            if (element2 == null) {
                return null;
            }
            element2 = GradleDslElementImpl.dereference(element2, index2);
        }
        return element2;
    }

    @Nullable
    private static GradleDslFile findDslFile(GradleDslFile rootModuleDslFile, File moduleDirectory) {
        if (FileUtil.filesEqual((File)rootModuleDslFile.getDirectoryPath(), (File)moduleDirectory)) {
            return rootModuleDslFile;
        }
        for (GradleDslFile dslFile : rootModuleDslFile.getChildModuleDslFiles()) {
            if (FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)moduleDirectory)) {
                return dslFile;
            }
            GradleDslFile childDslFile = GradleDslElementImpl.findDslFile(dslFile, moduleDirectory);
            if (childDslFile == null) continue;
            return dslFile;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnPropertiesElement(@NotNull GradlePropertiesDslElement properties2, @NotNull List<String> nameParts, GradleDslNameConverter converter, @NotNull List<GradleDslElement> trace) {
        int traceIndex = trace.size() - 1;
        for (int i2 = 0; i2 < nameParts.size() - 1; ++i2) {
            GradleDslElement element2 = GradleDslElementImpl.extractElementFromProperties(properties2, nameParts.get(i2), converter, i2 == 0, traceIndex < 0 ? null : trace.get(traceIndex--), traceIndex >= 0);
            if (element2 instanceof GradleDslLiteral && ((GradleDslLiteral)element2).isReference()) {
                element2 = PropertyUtil.followElement((GradleDslLiteral)element2);
            }
            if (!PropertyUtil.isPropertiesElementOrMap(element2)) {
                return null;
            }
            properties2 = (GradlePropertiesDslElement)element2;
        }
        return GradleDslElementImpl.extractElementFromProperties(properties2, nameParts.get(nameParts.size() - 1), converter, nameParts.size() == 1, traceIndex < 0 ? null : trace.get(traceIndex--), traceIndex >= 0);
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnElement(@NotNull GradleDslElement element2, @NotNull List<String> nameParts, GradleDslNameConverter converter, boolean resolveWithOrder, boolean checkExt, int ignoreParentNumber) {
        Stack<GradleDslElement> elementTrace = new Stack<GradleDslElement>();
        if (resolveWithOrder) {
            elementTrace.push(element2);
        }
        while (ignoreParentNumber-- > 0 && element2 != null && !(element2 instanceof GradleDslFile) && !(element2 instanceof BuildScriptDslElement)) {
            element2 = element2.getParent();
        }
        while (element2 != null) {
            GradleDslElement lastElement;
            GradleDslElement gradleDslElement = lastElement = elementTrace.isEmpty() ? null : (GradleDslElement)elementTrace.peek();
            if (PropertyUtil.isPropertiesElementOrMap(element2)) {
                GradleDslElement bsElement;
                GradleDslElement bsDslElement;
                GradleDslElement extPropertyElement;
                GradleDslElement extElement;
                GradleDslElement propertyElement = GradleDslElementImpl.resolveReferenceOnPropertiesElement((GradlePropertiesDslElement)element2, nameParts, converter, elementTrace);
                if (propertyElement != null) {
                    return propertyElement;
                }
                if (!(lastElement instanceof ExtDslElement) && checkExt && (extElement = ((GradlePropertiesDslElement)element2).getPropertyElementBefore(lastElement, ExtDslElement.EXT.name, false)) instanceof ExtDslElement && (extPropertyElement = GradleDslElementImpl.resolveReferenceOnPropertiesElement((ExtDslElement)extElement, nameParts, converter, elementTrace)) != null) {
                    return extPropertyElement;
                }
                if (!(lastElement instanceof BuildScriptDslElement) && (bsDslElement = ((GradlePropertiesDslElement)element2).getPropertyElementBefore(element2, BuildScriptDslElement.BUILDSCRIPT.name, false)) instanceof BuildScriptDslElement && (bsElement = GradleDslElementImpl.resolveReferenceOnElement(bsDslElement, nameParts, converter, true, false, -1)) != null) {
                    return bsElement;
                }
            }
            if (resolveWithOrder) {
                elementTrace.push(element2);
            }
            if (element2 instanceof BuildScriptDslElement) {
                return null;
            }
            element2 = element2.getParent();
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInPropertiesFile(@NotNull GradleDslFile buildDslFile, @NotNull String referenceText) {
        GradleDslFile propertiesDslFile = buildDslFile.getSiblingDslFile();
        return propertiesDslFile != null ? propertiesDslFile.getPropertyElement(referenceText) : null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInParentModules(@NotNull GradleDslFile dslFile, @NotNull List<String> referenceText, GradleDslNameConverter converter) {
        for (GradleDslFile parentDslFile = dslFile.getParentModuleDslFile(); parentDslFile != null; parentDslFile = parentDslFile.getParentModuleDslFile()) {
            GradleDslElement bsElement;
            GradleDslElement extPropertyElement;
            ExtDslElement extDslElement = parentDslFile.getPropertyElement(ExtDslElement.EXT);
            if (extDslElement != null && (extPropertyElement = GradleDslElementImpl.resolveReferenceOnPropertiesElement(extDslElement, referenceText, converter, new Stack<GradleDslElement>())) != null) {
                return extPropertyElement;
            }
            BuildScriptDslElement bsDslElement = parentDslFile.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
            if (bsDslElement != null && (bsElement = GradleDslElementImpl.resolveReferenceOnElement(bsDslElement, referenceText, converter, false, true, -1)) != null) {
                return bsElement;
            }
            if (parentDslFile.getParentModuleDslFile() == null) {
                return null;
            }
            GradleDslElement propertyElement = GradleDslElementImpl.resolveReferenceInPropertiesFile(parentDslFile, String.join((CharSequence)".", referenceText));
            if (propertyElement == null) continue;
            return propertyElement;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInSameModule(@NotNull GradleDslElement startElement, @NotNull List<String> referenceText, GradleDslNameConverter converter, boolean resolveWithOrder) {
        GradleDslFile parentModuleDslFile;
        GradleDslElement bsElement;
        GradleDslElement element2 = GradleDslElementImpl.resolveReferenceOnElement(startElement, referenceText, converter, resolveWithOrder, true, startElement.getNameElement().fullNameParts().size());
        if (element2 != null) {
            return element2;
        }
        String text2 = String.join((CharSequence)".", referenceText);
        GradleDslFile dslFile = startElement.getDslFile();
        GradleDslElement propertyElement = GradleDslElementImpl.resolveReferenceInPropertiesFile(dslFile, text2);
        if (propertyElement != null) {
            return propertyElement;
        }
        BuildScriptDslElement bsDslElement = dslFile.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
        if (bsDslElement != null && (bsElement = GradleDslElementImpl.resolveReferenceOnElement(bsDslElement, referenceText, converter, false, true, -1)) != null) {
            return bsElement;
        }
        if (dslFile.getParentModuleDslFile() == null) {
            return null;
        }
        GradleDslFile rootProjectDslFile = dslFile;
        while ((parentModuleDslFile = rootProjectDslFile.getParentModuleDslFile()) != null) {
            rootProjectDslFile = parentModuleDslFile;
        }
        return GradleDslElementImpl.resolveReferenceInPropertiesFile(rootProjectDslFile, text2);
    }

    @Override
    @Nullable
    public GradleDslElement resolveExternalSyntaxReference(@NotNull String referenceText, boolean resolveWithOrder) {
        GradleDslElementImpl searchStartElement = this;
        GradleDslParser parser = this.getDslFile().getParser();
        referenceText = parser.convertReferenceText(searchStartElement, referenceText);
        return this.resolveInternalSyntaxReference(referenceText, resolveWithOrder);
    }

    @Override
    @Nullable
    public GradleDslElement resolveInternalSyntaxReference(@NotNull String referenceText, boolean resolveWithOrder) {
        GradleDslFile dslFile;
        int index2;
        GradleDslElementImpl searchStartElement = this;
        GradleDslParser parser = this.getDslFile().getParser();
        boolean withinBuildscript = false;
        GradleDslElement element2 = this;
        while (element2 != null) {
            if (!((element2 = element2.getParent()) instanceof BuildScriptDslElement)) continue;
            withinBuildscript = true;
            break;
        }
        List<String> referenceTextSegments = GradleNameElement.split(referenceText);
        int segmentCount = referenceTextSegments.size();
        for (index2 = 0; index2 < segmentCount && (dslFile = GradleDslElementImpl.resolveProjectReference(searchStartElement, referenceTextSegments.get(index2))) != null; ++index2) {
            searchStartElement = dslFile;
        }
        GradleDslElement resolvedElement = null;
        GradleDslFile dslFile2 = searchStartElement.getDslFile();
        if (index2 >= segmentCount) {
            resolvedElement = searchStartElement;
        } else {
            referenceTextSegments = referenceTextSegments.subList(index2, segmentCount);
            if (dslFile2 == searchStartElement && withinBuildscript) {
                searchStartElement = dslFile2.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
            }
            if (searchStartElement != null) {
                resolvedElement = GradleDslElementImpl.resolveReferenceInSameModule(searchStartElement, referenceTextSegments, parser, resolveWithOrder);
            }
        }
        if (resolvedElement == null) {
            resolvedElement = GradleDslElementImpl.resolveReferenceInParentModules(dslFile2, referenceTextSegments, parser);
        }
        return resolvedElement;
    }

    @Nullable
    private static GradleDslFile resolveProjectReference(GradleDslElement startElement, @NotNull String projectReference) {
        GradleDslFile dslFile;
        if ("project".equals(projectReference)) {
            return dslFile;
        }
        if ("parent".equals(projectReference)) {
            return dslFile.getParentModuleDslFile();
        }
        if ("rootProject".equals(projectReference)) {
            for (dslFile = startElement.getDslFile(); dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir())); dslFile = dslFile.getParentModuleDslFile()) {
            }
            return dslFile;
        }
        String standardProjectKey = ProjectPropertiesDslElement.getStandardProjectKey(projectReference);
        if (standardProjectKey != null) {
            String modulePath = standardProjectKey.substring(standardProjectKey.indexOf(39) + 1, standardProjectKey.lastIndexOf(39));
            VirtualFile settingFile = dslFile.tryToFindSettingsFile();
            if (settingFile == null) {
                return null;
            }
            GradleSettingsFile file2 = dslFile.getContext().getOrCreateSettingsFile(settingFile);
            GradleSettingsModelImpl model2 = new GradleSettingsModelImpl(file2);
            File moduleDirectory = model2.moduleDirectory(modulePath);
            if (moduleDirectory == null) {
                return null;
            }
            while (dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir()))) {
                dslFile = dslFile.getParentModuleDslFile();
            }
            if (dslFile == null) {
                return null;
            }
            return GradleDslElementImpl.findDslFile(dslFile, moduleDirectory);
        }
        return null;
    }

    @NotNull
    private static String stripQuotes(@NotNull String index2) {
        if (index2.startsWith(SINGLE_QUOTES) && index2.endsWith(SINGLE_QUOTES) || index2.startsWith(DOUBLE_QUOTES) && index2.endsWith(DOUBLE_QUOTES)) {
            return index2.substring(1, index2.length() - 1);
        }
        return index2;
    }
}

