/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ArityHelper;
import com.android.tools.idea.gradle.dsl.parser.semantics.MethodSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertySemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.SemanticsDescription;
import com.google.common.collect.ImmutableMap;
import com.intellij.psi.PsiElement;
import java.util.Map;
import java.util.Objects;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDslBlockElement
extends GradlePropertiesDslElement {
    private boolean hasBraces = true;

    protected GradleDslBlockElement(@Nullable GradleDslElement parent, @NotNull GradleNameElement name) {
        super(parent, null, name);
    }

    public void setHasBraces(boolean newValue) {
        this.hasBraces = newValue;
    }

    public boolean getHasBraces() {
        return this.hasBraces;
    }

    @Override
    @Nullable
    public PsiElement create() {
        if (!this.hasBraces) {
            this.delete();
        }
        return super.create();
    }

    @Override
    public boolean isBlockElement() {
        return true;
    }

    private ModelEffectDescription getModelEffect(@NotNull GradleDslElement element2) {
        String name = element2.getName();
        ImmutableMap<Pair<String, Integer>, ModelEffectDescription> nameMapper = this.getExternalToModelMap(element2.getDslFile().getParser());
        if (element2.shouldUseAssignment()) {
            ModelEffectDescription value2 = (ModelEffectDescription)nameMapper.get(new Pair((Object)name, (Object)null));
            if (value2 != null) {
                return value2;
            }
        } else {
            for (Map.Entry entry : nameMapper.entrySet()) {
                String entryName = (String)((Pair)entry.getKey()).getFirst();
                Integer arity = (Integer)((Pair)entry.getKey()).getSecond();
                if (!entryName.equals(name) || Objects.equals(arity, ArityHelper.property)) continue;
                return (ModelEffectDescription)entry.getValue();
            }
        }
        return null;
    }

    private void maybeCanonizeElement(@NotNull GradleDslElement element2) {
        ModelEffectDescription effect = this.getModelEffect(element2);
        if (effect == null) {
            return;
        }
        SemanticsDescription description2 = effect.semantics;
        if (element2.shouldUseAssignment() && description2 != PropertySemanticsDescription.VAR && description2 != PropertySemanticsDescription.VWO && description2 != PropertySemanticsDescription.VAR_BUT_DO_NOT_USE_FOR_WRITING_IN_KTS) {
            return;
        }
        element2.setModelEffect(effect);
    }

    @Override
    public void addParsedElement(@NotNull GradleDslElement element2) {
        if ("apply".equals(element2.getFullName())) {
            ApplyDslElement applyDslElement = this.getPropertyElement("apply", ApplyDslElement.class);
            if (applyDslElement == null) {
                applyDslElement = new ApplyDslElement(this);
                super.addParsedElement(applyDslElement);
            }
            applyDslElement.addParsedElement(element2);
            return;
        }
        ModelEffectDescription effect = this.getModelEffect(element2);
        if (effect != null) {
            SemanticsDescription description2 = effect.semantics;
            if (description2 == MethodSemanticsDescription.ADD_AS_LIST && element2 instanceof GradleDslSimpleExpression) {
                this.addAsParsedDslExpressionList(effect.property.name, (GradleDslSimpleExpression)element2);
                return;
            }
            this.maybeCanonizeElement(element2);
        }
        super.addParsedElement(element2);
    }

    @Override
    public void setParsedElement(@NotNull GradleDslElement element2) {
        this.maybeCanonizeElement(element2);
        super.setParsedElement(element2);
    }

    @Override
    @NotNull
    public GradleDslElement setNewElement(@NotNull GradleDslElement element2) {
        this.maybeCanonizeElement(element2);
        return super.setNewElement(element2);
    }
}

