/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.DefaultTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.FileTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.FakeElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.intellij.psi.PsiElement;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyUtil {
    @NonNls
    public static final String FILE_METHOD_NAME = "file";
    @NonNls
    public static final String FILE_CONSTRUCTOR_NAME = "File";
    @NotNull
    public static final PropertyTransform DEFAULT_TRANSFORM = new DefaultTransform();
    @NotNull
    public static final PropertyTransform FILE_TRANSFORM = new FileTransform();

    @NotNull
    public static GradleDslSimpleExpression createOrReplaceBasicExpression(@NotNull GradleDslElement parent, @Nullable GradleDslElement oldElement, @NotNull Object value2, @NotNull GradleNameElement name, @Nullable ModelPropertyDescription propertyDescription) {
        ModelEffectDescription effect = null;
        if (oldElement instanceof GradleDslLiteral) {
            GradleDslSimpleExpression expression2 = (GradleDslSimpleExpression)oldElement;
            expression2.setValue(value2);
            return expression2;
        }
        if (oldElement != null) {
            name = oldElement.getNameElement();
            effect = oldElement.getModelEffect();
        } else if (propertyDescription != null) {
            effect = new ModelEffectDescription(propertyDescription, ModelSemanticsDescription.CREATE_WITH_VALUE);
        }
        GradleDslSimpleExpression expression3 = PropertyUtil.createBasicExpression(parent, value2, name);
        expression3.setModelEffect(effect);
        return expression3;
    }

    @NotNull
    public static GradleDslSimpleExpression createBasicExpression(@NotNull GradleDslElement parent, @NotNull Object value2, @NotNull GradleNameElement name) {
        GradleDslLiteral newElement = new GradleDslLiteral(parent, name);
        ((GradleDslSimpleExpression)newElement).setValue(value2);
        return newElement;
    }

    public static void replaceElement(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (holder instanceof GradlePropertiesDslElement) {
            if (oldElement != null) {
                ((GradlePropertiesDslElement)holder).replaceElement(oldElement, newElement);
            } else {
                ((GradlePropertiesDslElement)holder).setNewElement(newElement);
            }
        } else if (holder instanceof GradleDslMethodCall) {
            assert (newElement instanceof GradleDslExpression);
            GradleDslMethodCall methodCall = (GradleDslMethodCall)holder;
            if (oldElement != null) {
                assert (oldElement instanceof GradleDslExpression);
                methodCall.replaceArgument((GradleDslExpression)oldElement, (GradleDslExpression)newElement);
            } else {
                methodCall.addNewArgument((GradleDslExpression)newElement);
            }
        } else {
            throw new IllegalStateException("Property holder has unknown type, " + holder);
        }
    }

    public static void removeElement(@NotNull GradleDslElement element2) {
        GradleDslElement holder = element2.getParent();
        if (holder == null) {
            return;
        }
        if (holder instanceof GradlePropertiesDslElement) {
            ((GradlePropertiesDslElement)holder).removeProperty(element2);
        } else if (holder instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)holder;
            if (element2 == methodCall.getArgumentsElement()) {
                PropertyUtil.removeElement(methodCall);
            }
            methodCall.remove(element2);
        } else {
            throw new IllegalStateException("Property holder has unknown type, " + holder);
        }
    }

    @NotNull
    public static GradlePropertyModelImpl resolveModel(@NotNull GradlePropertyModelImpl model2) {
        HashSet<String> seenModels = new HashSet<String>();
        while (model2.getValueType() == GradlePropertyModel.ValueType.REFERENCE && !seenModels.contains(model2.getFullyQualifiedName())) {
            if (model2.getDependencies().isEmpty()) {
                return model2;
            }
            seenModels.add(model2.getFullyQualifiedName());
            model2 = model2.dependencies().get(0);
        }
        return model2;
    }

    @NotNull
    public static GradleDslSimpleExpression resolveElement(@NotNull GradleDslSimpleExpression expression2) {
        while (expression2 instanceof GradleDslLiteral && expression2.isReference() && !expression2.hasCycle()) {
            GradleReferenceInjection injection = ((GradleDslLiteral)expression2).getReferenceInjection();
            if (injection == null) {
                return expression2;
            }
            GradleDslSimpleExpression next = injection.getToBeInjectedExpression();
            if (next == null) {
                return expression2;
            }
            expression2 = next;
        }
        return expression2;
    }

    @Nullable
    public static GradleDslElement followElement(@NotNull GradleDslSimpleExpression expression2) {
        GradleDslElement element2 = expression2;
        while (element2 instanceof GradleDslLiteral && ((GradleDslLiteral)element2).isReference() && !((GradleDslLiteral)element2).hasCycle()) {
            GradleReferenceInjection injection = ((GradleDslLiteral)element2).getReferenceInjection();
            if (injection == null) {
                return null;
            }
            GradleDslElement next = injection.getToBeInjected();
            if (next == null) {
                return null;
            }
            element2 = next;
        }
        return element2;
    }

    @Nullable
    public static String getFileValue(@NotNull GradleDslMethodCall methodCall) {
        if (!(methodCall.getMethodName().equals(FILE_METHOD_NAME) && !methodCall.isConstructor() || methodCall.getMethodName().equals(FILE_CONSTRUCTOR_NAME) && methodCall.isConstructor())) {
            return null;
        }
        StringBuilder builder2 = new StringBuilder();
        for (GradleDslExpression expression2 : methodCall.getArguments()) {
            String value2;
            if (!(expression2 instanceof GradleDslSimpleExpression) || (value2 = ((GradleDslSimpleExpression)expression2).getValue(String.class)) == null) continue;
            if (builder2.length() != 0) {
                builder2.append("/");
            }
            builder2.append(value2);
        }
        String result2 = builder2.toString();
        return result2.isEmpty() ? null : result2;
    }

    public static boolean isNonExpressionPropertiesElement(@Nullable GradleDslElement e) {
        return e instanceof GradlePropertiesDslElement && !(e instanceof GradleDslExpression);
    }

    public static boolean isPropertiesElementOrMap(@Nullable GradleDslElement e) {
        return e instanceof GradlePropertiesDslElement && !(e instanceof GradleDslExpressionList);
    }

    public static boolean isElementModified(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        return PropertyUtil.checkForModifiedValue(oldElement, newElement) || PropertyUtil.checkForModifiedName(oldElement, newElement);
    }

    @Nullable
    public static GradleDslElement findOriginalElement(@NotNull GradleDslElement parent, @NotNull GradleDslElement element2) {
        GradlePropertiesDslElement holder;
        GradlePropertiesDslElement gradlePropertiesDslElement = holder = parent instanceof GradleDslMethodCall ? ((GradleDslMethodCall)parent).getArgumentsElement() : (GradlePropertiesDslElement)parent;
        if (holder instanceof GradleDslExpressionList) {
            List<GradleDslElement> elements = holder.getAllPropertyElements();
            List<GradleDslElement> originalElement = holder.getOriginalElements();
            int index2 = elements.indexOf(element2);
            return index2 >= 0 && index2 < originalElement.size() ? originalElement.get(index2) : null;
        }
        return holder.getOriginalElementForNameAndType(element2.getName(), element2.getElementType());
    }

    public static boolean isFakeElementModified(@NotNull FakeElement element2) {
        GradleDslElement realExpression = element2.getRealExpression();
        GradleDslElement realParent = realExpression.getParent();
        GradleDslElement oldRealExpression = realParent == null ? null : PropertyUtil.findOriginalElement(realParent, realExpression);
        return oldRealExpression == null || PropertyUtil.isElementModified(oldRealExpression, realExpression);
    }

    private static boolean checkForModifiedValue(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (!oldElement.getClass().equals(newElement.getClass())) {
            return true;
        }
        if (oldElement instanceof GradleDslSettableExpression) {
            GradleDslSettableExpression oExpression = (GradleDslSettableExpression)oldElement;
            GradleDslSettableExpression nExpression = (GradleDslSettableExpression)newElement;
            String newText = null;
            String oldText = null;
            if (nExpression.getUnsavedValue() != null) {
                newText = nExpression.getUnsavedValue().getText();
            } else if (nExpression.getExpression() != null) {
                newText = nExpression.getExpression().getText();
            }
            if (oExpression.getExpression() != null) {
                oldText = oExpression.getExpression().getText();
            } else if (oExpression.getUnsavedValue() != null) {
                oldText = oExpression.getUnsavedValue().getText();
            }
            return (newText != null || oldText != null) && !Objects.equals(newText, oldText);
        }
        if (oldElement instanceof GradlePropertiesDslElement) {
            GradlePropertiesDslElement oListOrMap = (GradlePropertiesDslElement)oldElement;
            GradlePropertiesDslElement nListOrMap = (GradlePropertiesDslElement)newElement;
            List<GradleDslElement> originalElements = oListOrMap.getOriginalElements();
            List<GradleDslElement> newElements = nListOrMap.getCurrentElements();
            if (originalElements.size() != newElements.size()) {
                return true;
            }
            BiFunction<GradleDslElement, GradleDslElement, Boolean> func = oldElement instanceof GradleDslExpressionList ? PropertyUtil::checkForModifiedValue : PropertyUtil::isElementModified;
            for (int i2 = 0; i2 < originalElements.size(); ++i2) {
                if (!func.apply(originalElements.get(i2), newElements.get(i2)).booleanValue()) continue;
                return true;
            }
            return false;
        }
        if (oldElement instanceof GradleDslMethodCall) {
            GradleDslMethodCall oMethodCall = (GradleDslMethodCall)oldElement;
            GradleDslMethodCall nMethodCall = (GradleDslMethodCall)newElement;
            if (!oMethodCall.getMethodName().equals(nMethodCall.getMethodName())) {
                return false;
            }
            return PropertyUtil.checkForModifiedValue(oMethodCall.getArgumentsElement(), nMethodCall.getArgumentsElement());
        }
        PsiElement oldPsi = oldElement.getPsiElement();
        PsiElement newPsi = newElement.getPsiElement();
        return oldPsi == null || newPsi == null || !Objects.equals(oldPsi.getText(), newPsi.getText());
    }

    private static boolean checkForModifiedName(@NotNull GradleDslElement originalElement, @NotNull GradleDslElement newElement) {
        ModelEffectDescription oEffect = originalElement.getModelEffect();
        ModelEffectDescription nEffect = newElement.getModelEffect();
        if (oEffect != null && nEffect != null && Objects.equals(oEffect.property, nEffect.property)) {
            return false;
        }
        GradleNameElement oNameElement = originalElement.getNameElement();
        String oldName = oNameElement.getOriginalName();
        if (oldName == null) {
            return false;
        }
        GradleNameElement nNameElement = newElement.getNameElement();
        String newName2 = nNameElement.getLocalName();
        if (newName2 == null) {
            return false;
        }
        return !Objects.equals(GradleNameElement.convertNameToKey(newName2), GradleNameElement.convertNameToKey(oldName));
    }
}

