/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.api.android.FlavorTypeModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.SigningConfigPropertyModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.parser.android.AbstractFlavorTypeDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;

public abstract class FlavorTypeModelImpl
extends GradleDslBlockModel
implements FlavorTypeModel {
    @NonNls
    public static final String APPLICATION_ID_SUFFIX = "mApplicationIdSuffix";
    @NonNls
    public static final String BUILD_CONFIG_FIELD = "mBuildConfigField";
    @NonNls
    public static final String CONSUMER_PROGUARD_FILES = "mConsumerProguardFiles";
    @NonNls
    public static final String MANIFEST_PLACEHOLDERS = "mMmanifestPlaceholders";
    @NonNls
    public static final String MATCHING_FALLBACKS = "mMatchingFallbacks";
    @NonNls
    public static final String MULTI_DEX_ENABLED = "mMultiDexEnabled";
    @NonNls
    public static final String MULTI_DEX_KEEP_FILE = "mMultiDexKeepFile";
    @NonNls
    public static final String MULTI_DEX_KEEP_PROGUARD = "mMultiDexKeepProguard";
    @NonNls
    public static final String PROGUARD_FILES = "mProguardFiles";
    @NonNls
    public static final String RES_VALUE = "mResValue";
    @NonNls
    public static final String SIGNING_CONFIG = "mSigningConfig";
    @NonNls
    public static final String USE_JACK = "mUseJack";
    @NonNls
    public static final String VERSION_NAME_SUFFIX = "mVersionNameSuffix";

    public FlavorTypeModelImpl(@NotNull AbstractFlavorTypeDslElement dslElement) {
        super(dslElement);
    }

    @Override
    @NotNull
    public String name() {
        return this.myDslElement.getName();
    }

    @Override
    public void rename(@NotNull String newName2) {
        this.myDslElement.getNameElement().rename(newName2);
        this.myDslElement.setModified();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel applicationIdSuffix() {
        return this.getModelForProperty(APPLICATION_ID_SUFFIX);
    }

    @Override
    @NotNull
    public List<FlavorTypeModel.BuildConfigField> buildConfigFields() {
        return this.getTypeNameValuesElements(BuildConfigFieldImpl::new, BUILD_CONFIG_FIELD);
    }

    @Override
    public FlavorTypeModel.BuildConfigField addBuildConfigField(@NotNull String type, @NotNull String name, @NotNull String value2) {
        return (FlavorTypeModel.BuildConfigField)this.addNewTypeNameValueElement(BuildConfigFieldImpl::new, BUILD_CONFIG_FIELD, type, name, value2);
    }

    @Override
    public void removeBuildConfigField(@NotNull String type, @NotNull String name, @NotNull String value2) {
        FlavorTypeModel.BuildConfigField model2 = (FlavorTypeModel.BuildConfigField)this.getTypeNameValueElement(BuildConfigFieldImpl::new, BUILD_CONFIG_FIELD, type, name, value2);
        if (model2 != null) {
            model2.remove();
        }
    }

    @Override
    @Nullable
    public FlavorTypeModel.BuildConfigField replaceBuildConfigField(@NotNull String oldType, @NotNull String oldName, @NotNull String oldValue, @NotNull String type, @NotNull String name, @NotNull String value2) {
        FlavorTypeModel.BuildConfigField field2 = (FlavorTypeModel.BuildConfigField)this.getTypeNameValueElement(BuildConfigFieldImpl::new, BUILD_CONFIG_FIELD, oldType, oldName, oldValue);
        if (field2 == null) {
            return null;
        }
        field2.type().setValue(type);
        field2.name().setValue(name);
        field2.value().setValue(value2);
        return field2;
    }

    @Override
    public void removeAllBuildConfigFields() {
        this.myDslElement.removeProperty(BUILD_CONFIG_FIELD);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel consumerProguardFiles() {
        return this.getModelForProperty(CONSUMER_PROGUARD_FILES);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel manifestPlaceholders() {
        GradleDslExpressionMap manifestPlaceholders2 = this.myDslElement.getPropertyElement(GradleDslExpressionMap.MANIFEST_PLACEHOLDERS);
        if (manifestPlaceholders2 == null) {
            this.myDslElement.addDefaultProperty(new GradleDslExpressionMap(this.myDslElement, GradleNameElement.fake(MANIFEST_PLACEHOLDERS)));
        }
        return this.getModelForProperty(MANIFEST_PLACEHOLDERS);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel matchingFallbacks() {
        return this.getModelForProperty(MATCHING_FALLBACKS);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel multiDexEnabled() {
        return this.getModelForProperty(MULTI_DEX_ENABLED);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel multiDexKeepFile() {
        return GradlePropertyModelBuilder.create(this.myDslElement, MULTI_DEX_KEEP_FILE).addTransform(PropertyUtil.FILE_TRANSFORM).buildResolved();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel multiDexKeepProguard() {
        return GradlePropertyModelBuilder.create(this.myDslElement, MULTI_DEX_KEEP_PROGUARD).addTransform(PropertyUtil.FILE_TRANSFORM).buildResolved();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel proguardFiles() {
        return this.getModelForProperty(PROGUARD_FILES);
    }

    @Override
    @NotNull
    public List<FlavorTypeModel.ResValue> resValues() {
        return this.getTypeNameValuesElements(ResValueImpl::new, RES_VALUE);
    }

    @Override
    @NotNull
    public FlavorTypeModel.ResValue addResValue(@NotNull String type, @NotNull String name, @NotNull String value2) {
        return (FlavorTypeModel.ResValue)this.addNewTypeNameValueElement(ResValueImpl::new, RES_VALUE, type, name, value2);
    }

    @Override
    public void removeResValue(@NotNull String type, @NotNull String name, @NotNull String value2) {
        FlavorTypeModel.ResValue model2 = (FlavorTypeModel.ResValue)this.getTypeNameValueElement(ResValueImpl::new, RES_VALUE, type, name, value2);
        if (model2 != null) {
            model2.remove();
        }
    }

    @Override
    public FlavorTypeModel.ResValue replaceResValue(@NotNull String oldType, @NotNull String oldName, @NotNull String oldValue, @NotNull String type, @NotNull String name, @NotNull String value2) {
        FlavorTypeModel.ResValue field2 = (FlavorTypeModel.ResValue)this.getTypeNameValueElement(ResValueImpl::new, RES_VALUE, oldType, oldName, oldValue);
        if (field2 == null) {
            return null;
        }
        field2.type().setValue(type);
        field2.name().setValue(name);
        field2.value().setValue(value2);
        return field2;
    }

    @Override
    public void removeAllResValues() {
        this.myDslElement.removeProperty(RES_VALUE);
    }

    @Override
    @NotNull
    public SigningConfigPropertyModel signingConfig() {
        return GradlePropertyModelBuilder.create(this.myDslElement, SIGNING_CONFIG).buildSigningConfig();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel useJack() {
        return this.getModelForProperty(USE_JACK);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel versionNameSuffix() {
        return this.getModelForProperty(VERSION_NAME_SUFFIX);
    }

    protected <T extends FlavorTypeModel.TypeNameValueElement> T addNewTypeNameValueElement(@NotNull Function<GradleDslExpressionList, T> producer, @NotNull String elementName, @NotNull String type, @NotNull String name, @NotNull String value2) {
        GradleDslExpressionList expressionList;
        GradleNameElement nameElement = GradleNameElement.create(elementName);
        boolean forKotlin = this.myDslElement.getDslFile().getPsiElement() instanceof KtFile;
        GradleDslMethodCall expressionCall = null;
        if (forKotlin) {
            expressionCall = new GradleDslMethodCall((GradleDslElement)this.myDslElement, nameElement, elementName);
            expressionList = new GradleDslExpressionList((GradleDslElement)expressionCall, nameElement, false);
            expressionCall.setParsedArgumentList(expressionList);
        } else {
            expressionList = new GradleDslExpressionList((GradleDslElement)this.myDslElement, nameElement, false);
        }
        FlavorTypeModel.TypeNameValueElement newValue = (FlavorTypeModel.TypeNameValueElement)producer.apply((Object)expressionList);
        assert (newValue != null);
        newValue.type().setValue(type);
        newValue.name().setValue(name);
        newValue.value().setValue(value2);
        if (expressionCall == null) {
            this.myDslElement.setNewElement(expressionList);
        } else {
            this.myDslElement.setNewElement(expressionCall);
        }
        return (T)newValue;
    }

    protected <T> List<T> getTypeNameValuesElements(@NotNull Function<GradleDslExpressionList, T> producer, @NotNull String elementName) {
        ArrayList result2 = Lists.newArrayList();
        for (GradleDslElement element2 : this.myDslElement.getPropertyElementsByName(elementName)) {
            if (element2 instanceof GradleDslMethodCall) {
                element2 = ((GradleDslMethodCall)element2).getArgumentsElement();
            }
            if (!(element2 instanceof GradleDslExpressionList)) continue;
            GradleDslExpressionList list = (GradleDslExpressionList)element2;
            Object value2 = producer.apply((Object)list);
            assert (value2 != null);
            result2.add(value2);
        }
        return result2;
    }

    @Nullable
    protected <T extends FlavorTypeModel.TypeNameValueElement> T getTypeNameValueElement(@NotNull Function<GradleDslExpressionList, T> producer, @NotNull String elementName, @NotNull String type, @NotNull String name, @NotNull String value2) {
        for (GradleDslElement element2 : this.myDslElement.getPropertyElementsByName(elementName)) {
            GradleDslExpressionList list = null;
            if (element2 instanceof GradleDslMethodCall) {
                list = ((GradleDslMethodCall)element2).getArgumentsElement();
            } else if (element2 instanceof GradleDslExpressionList) {
                list = (GradleDslExpressionList)element2;
            }
            FlavorTypeModel.TypeNameValueElement typeNameValueElement = (FlavorTypeModel.TypeNameValueElement)producer.apply((Object)list);
            assert (typeNameValueElement != null);
            String oldType = typeNameValueElement.type().getValue(GradlePropertyModel.STRING_TYPE);
            String oldName = typeNameValueElement.name().getValue(GradlePropertyModel.STRING_TYPE);
            String oldValue = typeNameValueElement.value().getValue(GradlePropertyModel.STRING_TYPE);
            if (oldType == null || !oldType.equals(type) || oldName == null || !oldName.equals(name) || oldValue == null || !oldValue.equals(value2)) continue;
            return (T)typeNameValueElement;
        }
        return null;
    }

    public static final class BuildConfigFieldImpl
    extends TypeNameValueElementImpl
    implements FlavorTypeModel.BuildConfigField {
        public BuildConfigFieldImpl(@NotNull GradleDslExpressionList list) {
            super(FlavorTypeModelImpl.BUILD_CONFIG_FIELD, list);
        }
    }

    public static final class ResValueImpl
    extends TypeNameValueElementImpl
    implements FlavorTypeModel.ResValue {
        public ResValueImpl(@NotNull GradleDslExpressionList list) {
            super(FlavorTypeModelImpl.RES_VALUE, list);
        }
    }

    public static class TypeNameValueElementImpl
    implements FlavorTypeModel.TypeNameValueElement {
        @NotNull
        private final String myElementName;
        @NotNull
        private final GradlePropertyModelImpl myList;

        public TypeNameValueElementImpl(@NotNull String elementName, @NotNull GradleDslExpressionList list) {
            this.myElementName = elementName;
            this.myList = new GradlePropertyModelImpl(list);
            List<GradlePropertyModel> elements = this.myList.getValue(GradlePropertyModel.LIST_TYPE);
            assert (elements != null);
            for (int i2 = elements.size(); i2 < 3; ++i2) {
                this.myList.addListValue();
            }
        }

        @NotNull
        private ResolvedPropertyModel getModelForIndex(int index2) {
            List<GradlePropertyModel> elements = this.myList.getValue(GradlePropertyModel.LIST_TYPE);
            assert (elements != null);
            GradlePropertyModel expression2 = elements.get(index2);
            assert (expression2.getValueType() != GradlePropertyModel.ValueType.NONE);
            return expression2.resolve();
        }

        @Override
        @NotNull
        public ResolvedPropertyModel type() {
            return this.getModelForIndex(0);
        }

        @Override
        @NotNull
        public ResolvedPropertyModel name() {
            return this.getModelForIndex(1);
        }

        @Override
        @NotNull
        public ResolvedPropertyModel value() {
            return this.getModelForIndex(2);
        }

        @Override
        @NotNull
        public String elementName() {
            return this.myElementName;
        }

        @Override
        public void remove() {
            this.myList.delete();
        }

        @Override
        public GradlePropertyModel getModel() {
            return this.myList;
        }

        public String toString() {
            return String.format("Type: %1$s, Name: %2$s, Value: %3$s", this.type().getValue(GradlePropertyModel.STRING_TYPE), this.name().getValue(GradlePropertyModel.STRING_TYPE), this.value().getValue(GradlePropertyModel.STRING_TYPE));
        }
    }
}

