/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleFileModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.configurations.ConfigurationsModel;
import com.android.tools.idea.gradle.dsl.api.crashlytics.CrashlyticsModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.java.JavaModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleFileModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.PluginModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModelImpl;
import com.android.tools.idea.gradle.dsl.model.build.BuildScriptModelImpl;
import com.android.tools.idea.gradle.dsl.model.configurations.ConfigurationsModelImpl;
import com.android.tools.idea.gradle.dsl.model.crashlytics.CrashlyticsModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.ExtModelImpl;
import com.android.tools.idea.gradle.dsl.model.java.JavaModelImpl;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoriesModelImpl;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.configurations.ConfigurationsDslElement;
import com.android.tools.idea.gradle.dsl.parser.crashlytics.CrashlyticsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.plugins.PluginsDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildModelImpl
extends GradleFileModelImpl
implements GradleBuildModel {
    @NonNls
    private static final String PLUGIN = "plugin";
    @NonNls
    private static final String ID = "id";

    public GradleBuildModelImpl(@NotNull GradleBuildFile buildDslFile) {
        super(buildDslFile);
    }

    @Override
    @NotNull
    public List<PluginModel> plugins() {
        ApplyDslElement applyDslElement;
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        ArrayList<PluginModelImpl> plugins = new ArrayList<PluginModelImpl>();
        if (pluginsDslElement != null) {
            plugins.addAll(PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(pluginsDslElement)).values());
        }
        if ((applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class)) != null) {
            plugins.addAll(PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement)).values());
        }
        return new ArrayList<PluginModel>(PluginModelImpl.deduplicatePlugins(plugins).values());
    }

    @Override
    @NotNull
    public PluginModel applyPlugin(@NotNull String plugin) {
        Map<String, PluginModelImpl> applyPluginsModels;
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class);
        if (pluginsDslElement == null && applyDslElement == null) {
            pluginsDslElement = new PluginsDslElement(this.myGradleDslFile, GradleNameElement.fake(PluginsDslElement.PLUGINS.name));
            this.myGradleDslFile.addNewElementAt(0, pluginsDslElement);
        } else if (pluginsDslElement == null) {
            Map<String, PluginModelImpl> models2 = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement));
            if (models2.containsKey(plugin)) {
                return models2.get(plugin);
            }
            GradleDslExpressionMap applyMap = new GradleDslExpressionMap(this.myGradleDslFile, GradleNameElement.create("apply"));
            applyMap.setAsNamedArgs(true);
            GradleDslLiteral literal = new GradleDslLiteral(applyMap, GradleNameElement.create(PLUGIN));
            literal.setValue(plugin.trim());
            applyMap.setNewElement(literal);
            applyDslElement.setNewElement(applyMap);
            return new PluginModelImpl(applyMap, literal);
        }
        Map<String, PluginModelImpl> models3 = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(pluginsDslElement));
        if (models3.containsKey(plugin)) {
            return models3.get(plugin);
        }
        if (applyDslElement != null && (applyPluginsModels = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement))).containsKey(plugin)) {
            return applyPluginsModels.get(plugin);
        }
        GradleDslLiteral literal = new GradleDslLiteral(pluginsDslElement, GradleNameElement.create(ID));
        literal.setElementType(PropertyType.REGULAR);
        literal.setValue(plugin.trim());
        pluginsDslElement.setNewElement(literal);
        return new PluginModelImpl(literal, literal);
    }

    @Override
    public void removePlugin(@NotNull String plugin) {
        ApplyDslElement applyDslElement;
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        if (pluginsDslElement != null) {
            PluginModelImpl.removePlugins(PluginModelImpl.create(pluginsDslElement), plugin);
        }
        if ((applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class)) != null) {
            PluginModelImpl.removePlugins(PluginModelImpl.create(applyDslElement), plugin);
        }
    }

    @Override
    @Nullable
    public PsiElement getPluginsPsiElement() {
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        if (pluginsDslElement != null) {
            return pluginsDslElement.getPsiElement();
        }
        return null;
    }

    @Override
    @NotNull
    public AndroidModel android() {
        AndroidDslElement androidDslElement = this.myGradleDslFile.ensurePropertyElement(AndroidDslElement.ANDROID);
        return new AndroidModelImpl(androidDslElement);
    }

    @Override
    @NotNull
    public BuildScriptModel buildscript() {
        BuildScriptDslElement buildScriptDslElement = this.myGradleDslFile.ensurePropertyElement(BuildScriptDslElement.BUILDSCRIPT);
        return new BuildScriptModelImpl(buildScriptDslElement);
    }

    @Override
    @NotNull
    public ConfigurationsModel configurations() {
        ConfigurationsDslElement configurationsDslElement = this.myGradleDslFile.ensurePropertyElementBefore(ConfigurationsDslElement.CONFIGURATIONS, DependenciesDslElement.class);
        return new ConfigurationsModelImpl(configurationsDslElement);
    }

    @Override
    @NotNull
    public CrashlyticsModel crashlytics() {
        CrashlyticsDslElement crashlyticsDslElement = this.myGradleDslFile.ensurePropertyElement(CrashlyticsDslElement.CRASHLYTICS);
        return new CrashlyticsModelImpl(crashlyticsDslElement);
    }

    @Override
    @NotNull
    public DependenciesModel dependencies() {
        DependenciesDslElement dependenciesDslElement = this.myGradleDslFile.ensurePropertyElement(DependenciesDslElement.DEPENDENCIES);
        return new DependenciesModelImpl(dependenciesDslElement);
    }

    @Override
    @NotNull
    public ExtModel ext() {
        int at = 0;
        List<GradleDslElement> elements = this.myGradleDslFile.getAllElements();
        if (!elements.isEmpty() && elements.get(0) instanceof ApplyDslElement) {
            ++at;
        }
        ExtDslElement extDslElement = this.myGradleDslFile.ensurePropertyElementAt(ExtDslElement.EXT, at);
        return new ExtModelImpl(extDslElement);
    }

    @Override
    @NotNull
    public JavaModel java() {
        JavaDslElement javaDslElement = this.myGradleDslFile.ensurePropertyElement(JavaDslElement.JAVA);
        return new JavaModelImpl(javaDslElement);
    }

    @Override
    @NotNull
    public RepositoriesModel repositories() {
        RepositoriesDslElement repositoriesDslElement = this.myGradleDslFile.ensurePropertyElement(RepositoriesDslElement.REPOSITORIES);
        return new RepositoriesModelImpl(repositoriesDslElement);
    }

    @Override
    @NotNull
    public Set<GradleFileModel> getInvolvedFiles() {
        return this.getAllInvolvedFiles().stream().distinct().map(e -> GradleBuildModelImpl.getFileModel(e)).collect(Collectors.toSet());
    }

    @NotNull
    private static GradleFileModel getFileModel(@NotNull GradleDslFile file2) {
        if (file2 instanceof GradleBuildFile) {
            return new GradleBuildModelImpl((GradleBuildFile)file2);
        }
        if (file2 instanceof GradleSettingsFile) {
            return new GradleSettingsModelImpl((GradleSettingsFile)file2);
        }
        if (file2 instanceof GradlePropertiesFile) {
            return new GradlePropertiesModel(file2);
        }
        throw new IllegalStateException("Unknown GradleDslFile type found!");
    }

    @Override
    @NotNull
    public File getModuleRootDirectory() {
        BuildModelContext context = this.myGradleDslFile.getContext();
        VirtualFile projectSettingsFile = context.getProjectSettingsFile();
        if (projectSettingsFile == null) {
            return this.myGradleDslFile.getDirectoryPath();
        }
        GradleSettingsFile settingsFile = context.getOrCreateSettingsFile(projectSettingsFile);
        GradleSettingsModelImpl settingsModel = new GradleSettingsModelImpl(settingsFile);
        File directory = settingsModel.moduleDirectory(this.myGradleDslFile.getName());
        if (directory == null) {
            return this.myGradleDslFile.getDirectoryPath();
        }
        return directory;
    }

    @Override
    public void removeRepositoriesBlocks() {
        this.myGradleDslFile.removeProperty(RepositoriesDslElement.REPOSITORIES.name);
    }
}

