/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.adtimport;

import com.android.SdkConstants;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.gradle.adtimport.EclipseImportModule;
import com.android.tools.idea.gradle.adtimport.GradleImport;
import com.android.tools.idea.gradle.adtimport.ImportModule;
import com.android.tools.idea.util.PropertiesFiles;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class EclipseProject
implements Comparable<EclipseProject> {
    static final String DEFAULT_LANGUAGE_LEVEL = "1.6";
    private static final String HOME_PROPERTY = "user.home";
    private static final String HOME_PROPERTY_REF = "${user.home}";
    private static final String SDK_PROPERTY_REF = "${sdk.dir}";
    private final GradleImport myImporter;
    private final File myDir;
    private final File myCanonicalDir;
    private boolean myLibrary;
    private boolean myAndroidProject;
    private boolean myNdkProject;
    private AndroidVersion myMinSdkVersion;
    private AndroidVersion myTargetSdkVersion;
    private Document myProjectDoc;
    private Document myManifestDoc;
    private Properties myProjectProperties;
    private AndroidVersion myVersion;
    private String myAddOn;
    private String myName;
    private String myLanguageLevel;
    private List<EclipseProject> myDirectLibraries;
    private List<File> mySourcePaths;
    private List<File> myJarPaths;
    private List<File> myInstrumentationJarPaths;
    private List<File> myNativeLibs;
    private List<String> myInferredLibraries;
    private File myNativeSources;
    private String myNativeModuleName;
    private File myOutputDir;
    private String myPackage;
    private List<File> myLocalProguardFiles;
    private List<File> mySdkProguardFiles;
    private List<EclipseProject> myAllLibraries;
    private EclipseImportModule myModule;
    private Map<String, String> myProjectVariableMap;
    private Map<String, String> myLinkedResourceMap;
    private File myInstrumentationDir;
    private Map<File, Charset> myFileCharsets;
    private Charset myDefaultCharset;

    private EclipseProject(GradleImport importer, File dir) throws IOException {
        this.myImporter = importer;
        this.myDir = dir;
        this.myCanonicalDir = dir.getCanonicalFile();
        this.myImporter.registerProject(this);
        this.initProjectName();
        this.initAndroidProject();
        this.initLanguageLevel();
        if (this.isAndroidProject()) {
            Properties properties2 = this.getProjectProperties();
            if (properties2 != null) {
                this.initProguard(properties2);
                this.initVersion(properties2);
                this.initLibraries(properties2);
                this.initLibrary(properties2);
            }
            this.initPackage();
            this.initMinSdkVersion();
            this.initInstrumentation();
        } else {
            this.myDirectLibraries = new ArrayList<EclipseProject>(4);
        }
        this.initClassPathEntries();
        this.initJni();
        this.initEncoding();
    }

    public static EclipseProject getProject(GradleImport importer, File dir) throws IOException {
        Map<File, EclipseProject> mProjectMap = importer.getProjectMap();
        EclipseProject project = mProjectMap.get(dir);
        if (project == null) {
            project = EclipseProject.createProject(importer, dir);
            assert (mProjectMap.get(dir) != null);
        }
        return project;
    }

    private static EclipseProject createProject(GradleImport importer, File dir) throws IOException {
        return new EclipseProject(importer, dir);
    }

    private static AndroidVersion getApiVersion(Element usesSdk, String attribute, AndroidVersion defaultApiLevel) {
        AndroidVersion version2;
        String valueString = null;
        if (usesSdk.hasAttributeNS("http://schemas.android.com/apk/res/android", attribute)) {
            valueString = usesSdk.getAttributeNS("http://schemas.android.com/apk/res/android", attribute);
        }
        if (valueString != null && (version2 = SdkVersionInfo.getVersion((String)valueString, null)) != null) {
            return version2;
        }
        return defaultApiLevel;
    }

    private static String getInstrumentationTarget(GradleImport importer, File manifest) throws IOException {
        Document doc = importer.getXmlDocument(manifest, true);
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("instrumentation");
            for (int i2 = 0; i2 < list.getLength(); ++i2) {
                Element tag = (Element)list.item(i2);
                String target = tag.getAttributeNS("http://schemas.android.com/apk/res/android", "targetPackage");
                if (target == null || target.isEmpty()) continue;
                return target;
            }
        }
        return null;
    }

    private static String getStringValue(Element element2) {
        NodeList children = element2.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue().trim();
        }
        return null;
    }

    public static List<? extends ImportModule> performImport(GradleImport importer, Collection<EclipseProject> projects2) {
        ArrayList modules = Lists.newArrayList();
        ArrayList replacedByDependencies = Lists.newArrayList();
        for (EclipseProject project : projects2) {
            EclipseImportModule module2 = new EclipseImportModule(importer, project);
            module2.initialize();
            if (module2.isReplacedWithDependency()) {
                replacedByDependencies.add(module2);
                continue;
            }
            modules.add(module2);
        }
        for (EclipseImportModule replaced : replacedByDependencies) {
            assert (replaced.getReplaceWithDependencies() != null);
            EclipseProject project = replaced.getProject();
            for (EclipseImportModule module3 : modules) {
                if (!module3.getProject().getAllLibraries().contains(project)) continue;
                module3.addDependencies(replaced.getReplaceWithDependencies());
            }
        }
        for (EclipseImportModule module4 : modules) {
            module4.removeJarDependencies();
        }
        Collections.sort(modules);
        return modules;
    }

    private void initVersion(Properties properties2) {
        String target = properties2.getProperty("target");
        if (target != null) {
            this.myVersion = AndroidTargetHash.getPlatformVersion((String)target);
            if (this.myVersion != null && this.myVersion.isPreview()) {
                AndroidVersion version2 = SdkVersionInfo.getVersion((String)this.myVersion.getCodename(), null);
                if (version2 != null) {
                    this.myVersion = version2;
                }
            } else {
                int index2 = target.lastIndexOf(58);
                if (index2 != -1) {
                    this.myVersion = SdkVersionInfo.getVersion((String)target.substring(index2 + 1), null);
                    this.myAddOn = target;
                }
            }
        }
    }

    private void initLibraries(Properties properties2) throws IOException {
        this.myDirectLibraries = new ArrayList<EclipseProject>(4);
        for (int i2 = 0; i2 < 1000; ++i2) {
            String key = String.format(Locale.US, "android.library.reference.%1$d", i2);
            String library = properties2.getProperty(key);
            if (library == null || library.isEmpty()) {
                if (i2 != 0) break;
                continue;
            }
            library = SdkConstants.CURRENT_PLATFORM == 2 ? library.replace('/', '\\') : library.replace('\\', '/');
            File path2 = new File(library);
            File joined = path2.isAbsolute() ? path2 : new File(this.myDir, library);
            File libraryDir = joined.getCanonicalFile();
            if (!libraryDir.exists()) {
                if (this.myImporter.isReplaceLibs()) {
                    String parentName;
                    File parent;
                    String libraryDirName = libraryDir.getName().replace('_', '-');
                    if (libraryDirName.indexOf(45) == -1 && (parent = libraryDir.getParentFile()) != null && (parentName = parent.getName()).equals("v7")) {
                        libraryDirName = libraryDirName + '-' + parentName;
                    }
                    if ("appcompat-v7".equals(libraryDirName) || "support-v4".equals(libraryDirName) || "gridlayout-v7".equals(libraryDirName) || "mediarouter-v7".equals(libraryDirName)) {
                        if (this.myInferredLibraries == null) {
                            this.myInferredLibraries = Lists.newArrayList();
                        }
                        this.myInferredLibraries.add(libraryDirName);
                        continue;
                    }
                }
                String message2 = "Library reference " + library + " could not be found";
                if (!path2.isAbsolute()) {
                    message2 = message2 + "\nPath is " + joined + " which resolves to " + libraryDir.getPath();
                }
                this.myImporter.reportError(this, this.getProjectPropertiesFile(), message2);
            }
            EclipseProject libraryPrj = EclipseProject.getProject(this.myImporter, libraryDir);
            this.myDirectLibraries.add(libraryPrj);
        }
    }

    private void initLibrary(Properties properties2) throws IOException {
        boolean mergeManifests;
        assert (this.myDirectLibraries != null);
        String value2 = properties2.getProperty("android.library");
        this.myLibrary = "true".equals(value2);
        if (!this.myLibrary && !(mergeManifests = "true".equals(properties2.getProperty("manifestmerger.enabled")))) {
            for (EclipseProject library : this.getAllLibraries()) {
                if (!library.isAndroidProject() || !library.isLibrary() || !library.getManifestFile().exists() || library.getManifestDoc().getDocumentElement() == null || !XmlUtils.hasElementChildren((Node)library.getManifestDoc().getDocumentElement())) continue;
                this.myImporter.getSummary().reportManifestsMayDiffer();
                break;
            }
        }
    }

    private void initPackage() throws IOException {
        this.myPackage = this.getManifestDoc().getDocumentElement().getAttribute("package");
    }

    private void initMinSdkVersion() throws IOException {
        NodeList usesSdks = this.getManifestDoc().getDocumentElement().getElementsByTagName("uses-sdk");
        if (usesSdks.getLength() > 0) {
            Element usesSdk = (Element)usesSdks.item(0);
            this.myMinSdkVersion = EclipseProject.getApiVersion(usesSdk, "minSdkVersion", AndroidVersion.DEFAULT);
            this.myTargetSdkVersion = EclipseProject.getApiVersion(usesSdk, "targetSdkVersion", this.myMinSdkVersion);
        } else {
            this.myMinSdkVersion = null;
            this.myTargetSdkVersion = null;
        }
    }

    private void initProjectName() throws IOException {
        Document document = this.getProjectDocument();
        if (document == null) {
            return;
        }
        NodeList names = document.getElementsByTagName("name");
        for (int i2 = 0; i2 < names.getLength(); ++i2) {
            Node element2 = names.item(i2);
            this.myName = EclipseProject.getStringValue((Element)element2);
            if (this.myName != null) break;
        }
        if (this.myName == null) {
            this.myName = this.myDir.getName();
        }
    }

    private void initJni() throws IOException {
        File jniDir = new File(this.myDir, "jni");
        if (!jniDir.exists()) {
            return;
        }
        if (this.myNdkProject) {
            this.myNativeSources = jniDir;
            File makefile = new File(jniDir, "Android.mk");
            if (makefile.exists()) {
                Pattern pattern = Pattern.compile("\\s*LOCAL_MODULE\\s*:=\\s*(\\S+)\\s*");
                for (String line2 : Files.readLines((File)makefile, (Charset)Charsets.UTF_8)) {
                    Matcher matcher = pattern.matcher(line2);
                    if (!matcher.matches()) continue;
                    this.myNativeModuleName = matcher.group(1);
                    if (this.myNativeLibs == null) break;
                    String libName = "lib" + this.myNativeModuleName + ".so";
                    ListIterator<File> iterator = this.myNativeLibs.listIterator();
                    while (iterator.hasNext()) {
                        File lib = iterator.next();
                        if (!libName.equals(lib.getName())) continue;
                        iterator.remove();
                    }
                    if (!this.myNativeLibs.isEmpty()) break;
                    this.myNativeLibs = null;
                    break;
                }
            }
        }
    }

    private void initEncoding() throws IOException {
        Properties properties2;
        File propertyFile = new File(this.myDir, ".settings" + File.separator + "org.eclipse.core.resources.prefs");
        if (propertyFile.exists() && (properties2 = PropertiesFiles.getProperties(propertyFile)) != null) {
            Enumeration<?> enumeration = properties2.propertyNames();
            String prefix = "encoding/";
            while (enumeration.hasMoreElements()) {
                String key;
                Object next = enumeration.nextElement();
                if (!(next instanceof String) || !(key = (String)next).startsWith(prefix)) continue;
                String path2 = key.substring(prefix.length());
                String encoding = properties2.getProperty(key);
                if (encoding == null || encoding.isEmpty()) continue;
                try {
                    File file2;
                    Charset charset = Charset.forName(encoding);
                    if ("<project>".equals(path2)) {
                        this.myDefaultCharset = charset;
                        continue;
                    }
                    if (this.myFileCharsets == null) {
                        this.myFileCharsets = Maps.newHashMap();
                    }
                    if ((file2 = this.resolveVariableExpression(path2)) != null) {
                        this.myFileCharsets.put(file2, charset);
                        continue;
                    }
                    this.myFileCharsets.put(new File(path2), charset);
                }
                catch (UnsupportedCharsetException uce) {
                    this.myImporter.reportWarning(this, propertyFile, "Unknown charset " + encoding);
                }
            }
        }
    }

    Charset getProjectEncoding() {
        return this.myDefaultCharset;
    }

    Charset getFileEncoding(File file2) {
        return this.myFileCharsets != null ? this.myFileCharsets.get(file2) : null;
    }

    private void initInstrumentation() throws IOException {
        File projectDir = this.findInstrumentationTests(this.myDir);
        if (projectDir == null && this.myDir.getParentFile() != null) {
            projectDir = this.findInstrumentationTests(this.myDir.getParentFile());
        }
        if (projectDir != null && !projectDir.equals(this.myDir)) {
            File[] files2;
            this.myInstrumentationDir = projectDir;
            File libs = new File(this.myInstrumentationDir, "libs");
            if (libs.exists() && (files2 = libs.listFiles()) != null) {
                for (File file2 : files2) {
                    if (!file2.isFile() || !SdkUtils.endsWithIgnoreCase((String)file2.getPath(), (String)".jar")) continue;
                    if (this.myInstrumentationJarPaths == null) {
                        this.myInstrumentationJarPaths = Lists.newArrayList();
                    }
                    this.myInstrumentationJarPaths.add(file2);
                }
            }
        }
    }

    private File findInstrumentationTests(File parent) {
        File[] files2 = parent.listFiles();
        if (files2 != null) {
            for (File file2 : files2) {
                File manifest;
                if (!file2.isDirectory() || !(manifest = new File(file2, "AndroidManifest.xml")).exists()) continue;
                try {
                    String target = EclipseProject.getInstrumentationTarget(this.myImporter, manifest);
                    if (target != null && target.equals(this.myPackage)) {
                        return file2;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private void initClassPathEntries() throws IOException {
        File[] libs;
        assert (this.mySourcePaths == null && this.myJarPaths == null);
        this.mySourcePaths = Lists.newArrayList();
        this.myJarPaths = Lists.newArrayList();
        Document document = null;
        File classPathFile = this.getClassPathFile();
        if (!classPathFile.exists()) {
            File src = new File(this.myDir, "src");
            if (src.exists()) {
                this.mySourcePaths.add(src);
            }
        } else {
            document = this.myImporter.getXmlDocument(classPathFile, false);
        }
        if (document != null) {
            NodeList entries = document.getElementsByTagName("classpathentry");
            for (int i2 = 0; i2 < entries.getLength(); ++i2) {
                String relative;
                File file2;
                File resolved;
                Node entry = entries.item(i2);
                assert (entry.getNodeType() == 1);
                Element element2 = (Element)entry;
                String kind = element2.getAttribute("kind");
                String path2 = element2.getAttribute("path");
                if (kind.equals("var")) {
                    resolved = this.resolveVariableExpression(path2);
                    if (resolved != null) {
                        this.mySourcePaths.add(resolved);
                        continue;
                    }
                    this.myImporter.reportWarning(this, this.getClassPathFile(), "Could not resolve path variable " + path2);
                    continue;
                }
                if (kind.equals("src") && !path2.isEmpty()) {
                    if (path2.equals("gen")) continue;
                    resolved = this.resolveVariableExpression(path2);
                    if (resolved != null) {
                        if (path2.startsWith("/") && GradleImport.isEclipseProjectDir(resolved)) {
                            EclipseProject lib = EclipseProject.getProject(this.myImporter, resolved);
                            if (this.myDirectLibraries.contains(lib)) continue;
                            this.myDirectLibraries.add(lib);
                            this.myAllLibraries = null;
                            continue;
                        }
                        this.mySourcePaths.add(resolved);
                        continue;
                    }
                    this.myImporter.reportWarning(this, this.getClassPathFile(), "Could not resolve source path " + path2 + " in project " + this.getName() + ": ignored. The project may not compile if the given source path provided source code.");
                    continue;
                }
                if (kind.equals("lib") && !path2.isEmpty()) {
                    if (this.isAndroidProject()) continue;
                    resolved = this.resolveVariableExpression(path2);
                    if (resolved != null) {
                        this.myJarPaths.add(resolved);
                        continue;
                    }
                    this.myImporter.reportWarning(this, this.getClassPathFile(), "Absolute path in the path entry: If outside project, may not work correctly: " + path2);
                    continue;
                }
                if (!kind.equals("output") || path2.isEmpty() || (file2 = new File(relative = path2.replace('/', File.separatorChar))).isAbsolute()) continue;
                this.myOutputDir = file2;
            }
        }
        if ((libs = new File(this.myDir, "libs").listFiles()) != null) {
            for (File lib : libs) {
                File relative;
                if (!lib.isFile()) {
                    File[] libraries = lib.listFiles();
                    if (libraries == null) continue;
                    for (File library : libraries) {
                        String name = library.getName();
                        if (!library.isFile() || !name.startsWith("lib") || !name.contains(".so")) continue;
                        if (this.myNativeLibs == null) {
                            this.myNativeLibs = Lists.newArrayList();
                        }
                        File relative2 = new File("libs", lib.getName() + File.separator + library.getName());
                        this.myNativeLibs.add(relative2);
                    }
                    continue;
                }
                assert (lib.isFile());
                if (!SdkUtils.endsWithIgnoreCase((String)lib.getPath(), (String)".jar") || this.myJarPaths.contains(relative = new File("libs", lib.getName())) || this.myJarPaths.contains(lib)) continue;
                boolean isLibraryJar = false;
                for (EclipseProject project : this.getAllLibraries()) {
                    String jarName;
                    String pkg;
                    if (!project.isAndroidProject() || (pkg = project.getPackage()) == null || !(jarName = pkg.replace('.', '-') + ".jar").equals(lib.getName())) continue;
                    isLibraryJar = true;
                    break;
                }
                if (isLibraryJar) continue;
                this.myJarPaths.add(relative);
            }
            Collections.sort(this.myJarPaths);
            if (this.myNativeLibs != null) {
                Collections.sort(this.myNativeLibs);
            }
        }
    }

    private Map<String, String> getProjectVariableMap() {
        if (this.myProjectVariableMap == null) {
            Document document;
            this.myProjectVariableMap = Maps.newHashMap();
            try {
                document = this.getProjectDocument();
                if (document == null) {
                    return this.myProjectVariableMap;
                }
            }
            catch (IOException e) {
                return this.myProjectVariableMap;
            }
            NodeList variables = document.getElementsByTagName("variable");
            int n = variables.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Element variable = (Element)variables.item(i2);
                NodeList names = variable.getElementsByTagName("name");
                NodeList values2 = variable.getElementsByTagName("value");
                if (names.getLength() != 1 || values2.getLength() != 1) continue;
                String value2 = EclipseProject.getStringValue((Element)values2.item(0));
                String key = EclipseProject.getStringValue((Element)names.item(0));
                this.myProjectVariableMap.put(key, value2);
            }
        }
        return this.myProjectVariableMap;
    }

    private Map<String, String> getLinkedResourceMap() {
        if (this.myLinkedResourceMap == null) {
            Document document;
            this.myLinkedResourceMap = Maps.newHashMap();
            try {
                document = this.getProjectDocument();
                if (document == null) {
                    return this.myProjectVariableMap;
                }
            }
            catch (IOException e) {
                return this.myLinkedResourceMap;
            }
            NodeList links = document.getElementsByTagName("link");
            int n = links.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Element variable = (Element)links.item(i2);
                NodeList names = variable.getElementsByTagName("name");
                NodeList values2 = variable.getElementsByTagName("locationURI");
                if (names.getLength() != 1 || values2.getLength() != 1) continue;
                String value2 = EclipseProject.getStringValue((Element)values2.item(0));
                String key = EclipseProject.getStringValue((Element)names.item(0));
                this.myLinkedResourceMap.put(key, value2);
            }
        }
        return this.myLinkedResourceMap;
    }

    @VisibleForTesting
    File resolveVariableExpression(String path2) throws IOException {
        File file2 = this.resolveVariableExpression(path2, true, 0);
        if (file2 != null && this.myImporter.getPathMap().containsKey(path2)) {
            this.myImporter.getPathMap().put(path2, file2);
        }
        return file2;
    }

    private File resolveVariableExpression(String path2, boolean record, int depth) throws IOException {
        Pattern pattern;
        Matcher matcher;
        if (depth > 50) {
            return null;
        }
        if (path2.equals("PROJECT_LOC")) {
            return this.myDir;
        }
        if (path2.equals("PARENT_LOC")) {
            return this.myDir.getParentFile();
        }
        if (path2.equals("WORKSPACE_LOC")) {
            return this.myImporter.getEclipseWorkspace();
        }
        if (path2.startsWith("PARENT-") && (matcher = (pattern = Pattern.compile("PARENT-(\\d+)-(.+)")).matcher(path2)).matches()) {
            String var;
            File file2;
            int count = Integer.parseInt(matcher.group(1));
            String target = matcher.group(2);
            int index2 = target.indexOf(47);
            if (index2 == -1) {
                index2 = target.indexOf(92);
            }
            if ((file2 = this.resolveVariableExpression(var = index2 == -1 ? target : target.substring(0, index2), false, depth + 1)) != null) {
                int i2;
                File original = file2;
                for (i2 = 0; i2 < count && file2 != null; file2 = file2.getParentFile(), ++i2) {
                }
                if (file2 == null) {
                    file2 = original.getCanonicalFile();
                    for (i2 = 0; i2 < count && file2 != null; file2 = file2.getParentFile(), ++i2) {
                    }
                }
            }
            if (file2 != null && index2 != -1) {
                file2 = new File(file2, target.substring(index2 + 1));
            }
            return file2;
        }
        String filePath = path2.replace('/', File.separatorChar);
        File resolved = new File(filePath);
        if (resolved.exists()) {
            return resolved;
        }
        resolved = new File(this.myDir, filePath);
        if (resolved.exists()) {
            return resolved;
        }
        resolved = this.myImporter.getPathMap().get(path2);
        if (resolved != null) {
            return resolved;
        }
        if (record) {
            this.myImporter.getPathMap().put(path2, null);
        }
        if (path2.startsWith("/")) {
            resolved = this.myImporter.resolveWorkspacePath(this, path2, record);
            if (resolved != null) {
                return resolved;
            }
            if (path2.indexOf(47, 1) == -1 && path2.indexOf(92, 1) == -1) {
                File sibling;
                String name = path2.substring(1);
                File parent = this.myDir.getParentFile();
                if (parent != null && (sibling = new File(parent, name)).exists()) {
                    return sibling;
                }
                File child = new File(this.myDir, name);
                if (child.exists()) {
                    return child;
                }
            }
        } else if (path2.startsWith("$%7B")) {
            String sub;
            File expression2;
            int start2 = 4;
            int end = path2.indexOf("%7D", 4);
            if (end != -1 && (expression2 = this.resolveVariableExpression(sub = path2.substring(start2, end), false, depth + 1)) != null) {
                String suffix = path2.substring(end + 3);
                if (suffix.isEmpty()) {
                    return expression2;
                }
                resolved = new File(expression2, suffix.replace('/', File.separatorChar));
                if (resolved.exists()) {
                    return resolved;
                }
            }
        } else {
            int index3 = path2.indexOf(47);
            if (index3 == -1) {
                index3 = path2.indexOf(92);
            }
            String var = index3 == -1 ? path2 : path2.substring(0, index3);
            Map<String, String> map2 = this.getLinkedResourceMap();
            String expression3 = map2.get(var);
            if (expression3 == null || expression3.equals(var)) {
                map2 = this.getProjectVariableMap();
                expression3 = map2.get(var);
            }
            File file3 = expression3 != null ? (expression3.startsWith("file:") ? SdkUtils.urlToFile((String)expression3) : this.resolveVariableExpression(expression3, false, depth + 1)) : this.myImporter.resolvePathVariable(this, var, false);
            if (file3 != null) {
                if (index3 == -1) {
                    return file3;
                }
                resolved = new File(file3, path2.substring(index3 + 1));
                if (resolved.exists()) {
                    return resolved;
                }
            }
        }
        return null;
    }

    private void initAndroidProject() throws IOException {
        this.myAndroidProject = this.hasNature("com.android.ide.eclipse.adt.AndroidNature");
        if (!this.myAndroidProject && this.getProjectDocument() == null) {
            this.myAndroidProject = GradleImport.isAdtProjectDir(this.myDir);
        }
        this.myNdkProject = this.myAndroidProject && (this.hasNature("org.eclipse.cdt.core.cnature") || this.hasNature("org.eclipse.cdt.core.ccnature") || new File(this.myDir, "jni" + File.separator + "Android.mk").exists());
    }

    private boolean hasNature(String nature) throws IOException {
        Document document = this.getProjectDocument();
        if (document != null) {
            NodeList natures = document.getElementsByTagName("nature");
            for (int i2 = 0; i2 < natures.getLength(); ++i2) {
                Node element2 = natures.item(i2);
                String value2 = EclipseProject.getStringValue((Element)element2);
                if (!nature.equals(value2)) continue;
                return true;
            }
        }
        return false;
    }

    private void initLanguageLevel() throws IOException {
        if (this.myLanguageLevel == null) {
            String source;
            Properties properties2;
            this.myLanguageLevel = DEFAULT_LANGUAGE_LEVEL;
            File file2 = new File(this.myDir, ".settings" + File.separator + "org.eclipse.jdt.core.prefs");
            if (file2.exists() && (properties2 = PropertiesFiles.getProperties(file2)) != null && (source = properties2.getProperty("org.eclipse.jdt.core.compiler.source")) != null) {
                this.myLanguageLevel = source;
            }
        }
    }

    private void initProguard(Properties properties2) {
        this.myLocalProguardFiles = Lists.newArrayList();
        this.mySdkProguardFiles = Lists.newArrayList();
        String proguardConfig = properties2.getProperty("proguard.config");
        if (proguardConfig != null && !proguardConfig.isEmpty()) {
            if (File.separatorChar != '/' && proguardConfig.indexOf(47) != -1) {
                proguardConfig = proguardConfig.replace('/', File.separatorChar);
            }
            Iterable paths = Lint.splitPath((String)proguardConfig);
            for (String path2 : paths) {
                if (path2.startsWith(SDK_PROPERTY_REF)) {
                    this.mySdkProguardFiles.add(new File(path2.substring(SDK_PROPERTY_REF.length()).replace('/', File.separatorChar)));
                    continue;
                }
                if (path2.startsWith(HOME_PROPERTY_REF)) {
                    this.myImporter.getSummary().reportIgnoredUserHomeProGuardFile(path2);
                    continue;
                }
                File proguardConfigFile = new File(path2.replace('/', File.separatorChar));
                if (!proguardConfigFile.isAbsolute()) {
                    proguardConfigFile = new File(this.myDir, proguardConfigFile.getPath());
                }
                if (!proguardConfigFile.isFile()) continue;
                this.myLocalProguardFiles.add(proguardConfigFile);
            }
        }
    }

    public File getDir() {
        return this.myDir;
    }

    public File getCanonicalDir() {
        return this.myCanonicalDir;
    }

    public boolean isLibrary() {
        return this.myLibrary;
    }

    public List<File> getLocalProguardFiles() {
        assert (this.isAndroidProject());
        return this.myLocalProguardFiles;
    }

    public List<File> getSdkProguardFiles() {
        assert (this.isAndroidProject());
        return this.mySdkProguardFiles;
    }

    public File getResourceDir() {
        assert (this.isAndroidProject());
        return new File(this.myDir, "res");
    }

    public File getAssetsDir() {
        assert (this.isAndroidProject());
        return new File(this.myDir, "assets");
    }

    private File getClassPathFile() {
        return new File(this.myDir, ".classpath");
    }

    public Document getManifestDoc() throws IOException {
        assert (this.isAndroidProject());
        if (this.myManifestDoc == null) {
            File file2 = this.getManifestFile();
            this.myManifestDoc = this.myImporter.getXmlDocument(file2, true);
        }
        return this.myManifestDoc;
    }

    File getManifestFile() {
        assert (this.isAndroidProject());
        return new File(this.myDir, "AndroidManifest.xml");
    }

    public Properties getProjectProperties() throws IOException {
        if (this.myProjectProperties == null) {
            assert (this.isAndroidProject());
            File file2 = this.getProjectPropertiesFile();
            this.myProjectProperties = file2.exists() ? PropertiesFiles.getProperties(file2) : new Properties();
        }
        return this.myProjectProperties;
    }

    private File getProjectPropertiesFile() {
        return new File(this.myDir, "project.properties");
    }

    private Document getProjectDocument() throws IOException {
        File file2;
        if (this.myProjectDoc == null && (file2 = new File(this.myDir, ".project")).exists()) {
            this.myProjectDoc = this.myImporter.getXmlDocument(file2, false);
        }
        return this.myProjectDoc;
    }

    public boolean isAndroidProject() {
        return this.myAndroidProject;
    }

    public boolean isNdkProject() {
        return this.myNdkProject;
    }

    public File getInstrumentationDir() {
        return this.myInstrumentationDir;
    }

    public String getPackage() {
        assert (this.isAndroidProject());
        return this.myPackage;
    }

    public List<File> getSourcePaths() {
        return this.mySourcePaths;
    }

    public List<String> getInferredLibraries() {
        return this.myInferredLibraries == null ? Collections.emptyList() : this.myInferredLibraries;
    }

    public List<File> getJarPaths() {
        return this.myJarPaths;
    }

    public List<File> getTestJarPaths() {
        return this.myInstrumentationJarPaths != null ? this.myInstrumentationJarPaths : Collections.emptyList();
    }

    public List<File> getNativeLibs() {
        return this.myNativeLibs != null ? this.myNativeLibs : Collections.emptyList();
    }

    public File getNativeSources() {
        return this.myNativeSources;
    }

    public String getNativeModuleName() {
        return this.myNativeModuleName;
    }

    public File getOutputDir() {
        return this.myOutputDir;
    }

    public String getLanguageLevel() {
        return this.myLanguageLevel;
    }

    public String getName() {
        return this.myName != null ? this.myName : this.myDir.getName();
    }

    public AndroidVersion getMinSdkVersion() {
        assert (this.isAndroidProject());
        return this.myMinSdkVersion != null ? this.myMinSdkVersion : AndroidVersion.DEFAULT;
    }

    public AndroidVersion getTargetSdkVersion() {
        assert (this.isAndroidProject());
        return this.myTargetSdkVersion != null ? this.myTargetSdkVersion : this.getMinSdkVersion();
    }

    public AndroidVersion getCompileSdkVersion() {
        assert (this.isAndroidProject());
        return this.myVersion == null ? new AndroidVersion(30, null) : this.myVersion;
    }

    public String getAddOn() {
        assert (this.isAndroidProject());
        return this.myAddOn;
    }

    public List<EclipseProject> getDirectLibraries() {
        return this.myDirectLibraries;
    }

    public List<EclipseProject> getAllLibraries() {
        if (this.myAllLibraries == null) {
            if (this.myDirectLibraries.isEmpty()) {
                return this.myDirectLibraries;
            }
            ArrayList<EclipseProject> all = new ArrayList<EclipseProject>();
            HashSet seen = Sets.newHashSet();
            HashSet path2 = Sets.newHashSet();
            seen.add(this);
            path2.add(this);
            this.addLibraryProjects(all, seen, path2);
            this.myAllLibraries = all;
        }
        return this.myAllLibraries;
    }

    private void addLibraryProjects(Collection<EclipseProject> collection2, Set<EclipseProject> seen, Set<EclipseProject> path2) {
        for (EclipseProject library : this.myDirectLibraries) {
            if (seen.contains(library)) {
                if (!path2.contains(library)) continue;
                this.myImporter.reportWarning(library, library.getDir(), "Internal error: cyclic library dependency for " + library);
                continue;
            }
            collection2.add(library);
            seen.add(library);
            path2.add(library);
            library.addLibraryProjects(collection2, seen, path2);
            path2.remove(library);
        }
    }

    @Override
    public int compareTo(EclipseProject other) {
        return this.myDir.compareTo(other.myDir);
    }

    public String toString() {
        return this.myDir.getPath();
    }

    public EclipseImportModule getModule() {
        return this.myModule;
    }

    public void setModule(EclipseImportModule module2) {
        this.myModule = module2;
    }
}

