/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.build.OutputFile;
import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.AppBundleVariantBuildOutput;
import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.builder.model.ProjectBuildOutput;
import com.android.builder.model.VariantBuildOutput;
import com.android.ide.common.gradle.model.IdeAndroidArtifactOutput;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.util.GradleBuildOutputUtil;
import com.android.tools.idea.gradle.util.OutputType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildsToPathsMapper {
    @NotNull
    public static BuildsToPathsMapper getInstance(@NotNull Project project) {
        return (BuildsToPathsMapper)ServiceManager.getService((Project)project, BuildsToPathsMapper.class);
    }

    @NotNull
    Map<String, File> getBuildsToPaths(@Nullable Object model2, @NotNull List<String> buildVariants, @NotNull Collection<Module> modules, boolean isAppBundle, @Nullable String signedApkOrBundlePath) {
        boolean isSigned;
        boolean bl = isSigned = !buildVariants.isEmpty();
        if (isSigned) assert (modules.size() == 1);
        PostBuildModel postBuildModel = null;
        TreeMap<String, File> buildsToPathsCollector = new TreeMap<String, File>();
        if (model2 instanceof OutputBuildAction.PostBuildProjectModels) {
            postBuildModel = new PostBuildModel((OutputBuildAction.PostBuildProjectModels)model2);
        }
        for (Module module2 : modules) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
            if (androidModel == null) continue;
            if (!isSigned) {
                buildVariants = ImmutableList.singleton((Object)androidModel.getSelectedVariant().getName());
            }
            for (String buildVariant : buildVariants) {
                BuildsToPathsMapper.collectBuildsToPaths(androidModel, postBuildModel, module2, buildVariant, buildsToPathsCollector, isAppBundle, isSigned, signedApkOrBundlePath);
            }
        }
        return buildsToPathsCollector;
    }

    private static void collectBuildsToPaths(@NotNull AndroidModuleModel androidModel, @Nullable PostBuildModel postBuildModel, @NotNull Module module2, @NotNull String buildVariant, @NotNull Map<String, File> buildsToPathsCollector, boolean isAppBundle, boolean isSigned, @Nullable String signedApkOrBundlePath) {
        File outputFolderOrFile = null;
        if (androidModel.getFeatures().isBuildOutputFileSupported()) {
            OutputType outputType = isAppBundle ? OutputType.Bundle : OutputType.Apk;
            outputFolderOrFile = GradleBuildOutputUtil.getOutputFileOrFolderFromListingFile(androidModel, buildVariant, outputType, false);
        } else if (postBuildModel != null) {
            if (androidModel.getAndroidProject().getProjectType() == 0 || androidModel.getAndroidProject().getProjectType() == 6) {
                outputFolderOrFile = isAppBundle ? BuildsToPathsMapper.tryToGetOutputPostBuildBundleFile(module2, postBuildModel, buildVariant) : BuildsToPathsMapper.tryToGetOutputPostBuildApkFile(module2, postBuildModel, buildVariant);
            } else if (androidModel.getAndroidProject().getProjectType() == 4) {
                outputFolderOrFile = BuildsToPathsMapper.tryToGetOutputPostBuildInstantApp(module2, postBuildModel, buildVariant);
            }
        }
        if (outputFolderOrFile == null) {
            if (isSigned) {
                assert (signedApkOrBundlePath != null);
                outputFolderOrFile = new File(signedApkOrBundlePath);
            } else if (!isAppBundle) {
                outputFolderOrFile = BuildsToPathsMapper.tryToGetOutputPreBuild(androidModel);
            }
        }
        if (outputFolderOrFile == null) {
            return;
        }
        buildsToPathsCollector.put(isSigned ? buildVariant : module2.getName(), outputFolderOrFile);
    }

    @Nullable
    private static File tryToGetOutputPostBuildApkFile(@NotNull Module module2, @NotNull PostBuildModel postBuildModel, @NotNull String buildVariant) {
        ProjectBuildOutput projectBuildOutput = postBuildModel.findProjectBuildOutput(module2);
        if (projectBuildOutput == null) {
            return null;
        }
        for (VariantBuildOutput variantBuildOutput : projectBuildOutput.getVariantsBuildOutput()) {
            if (!variantBuildOutput.getName().equals(buildVariant)) continue;
            Collection outputs = variantBuildOutput.getOutputs();
            File outputFolderOrApk = ((OutputFile)outputs.iterator().next()).getOutputFile();
            if (outputs.size() > 1) {
                return outputFolderOrApk.getParentFile();
            }
            return outputFolderOrApk;
        }
        return null;
    }

    @Nullable
    private static File tryToGetOutputPostBuildBundleFile(@NotNull Module module2, @NotNull PostBuildModel postBuildModel, @NotNull String buildVariant) {
        AppBundleProjectBuildOutput appBundleProjectBuildOutput = postBuildModel.findAppBundleProjectBuildOutput(module2);
        if (appBundleProjectBuildOutput == null) {
            return null;
        }
        for (AppBundleVariantBuildOutput variantBuildOutput : appBundleProjectBuildOutput.getAppBundleVariantsBuildOutput()) {
            if (!variantBuildOutput.getName().equals(buildVariant)) continue;
            return variantBuildOutput.getBundleFile();
        }
        return null;
    }

    @Nullable
    private static File tryToGetOutputPostBuildInstantApp(@NotNull Module module2, @NotNull PostBuildModel postBuildModel, @NotNull String buildVariant) {
        InstantAppProjectBuildOutput instantAppProjectBuildOutput = postBuildModel.findInstantAppProjectBuildOutput(module2);
        if (instantAppProjectBuildOutput == null) {
            return null;
        }
        for (InstantAppVariantBuildOutput variantBuildOutput : instantAppProjectBuildOutput.getInstantAppVariantsBuildOutput()) {
            if (!variantBuildOutput.getName().equals(buildVariant)) continue;
            return variantBuildOutput.getOutput().getOutputFile();
        }
        return null;
    }

    @Nullable
    private static File tryToGetOutputPreBuild(@NotNull AndroidModuleModel androidModel) {
        List outputs = androidModel.getMainArtifact().getOutputs();
        if (outputs.isEmpty()) {
            return null;
        }
        File outputFolderOrApk = ((IdeAndroidArtifactOutput)outputs.iterator().next()).getOutputFile();
        if (outputs.size() > 1) {
            return outputFolderOrApk.getParentFile();
        }
        return outputFolderOrApk;
    }
}

