/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceCapabilities;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandBuilder;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandException;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandResult;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandsUtil;
import com.android.tools.idea.explorer.adbimpl.UniqueFileNameGenerator;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbFileOperations {
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final FutureCallbackExecutor myExecutor;
    @NotNull
    private final AdbDeviceCapabilities myDeviceCapabilities;

    public AdbFileOperations(@NotNull IDevice device, @NotNull AdbDeviceCapabilities deviceCapabilities, @NotNull Executor taskExecutor2) {
        this.myDevice = device;
        this.myExecutor = FutureCallbackExecutor.wrap((Executor)taskExecutor2);
        this.myDeviceCapabilities = deviceCapabilities;
    }

    @NotNull
    public ListenableFuture<Void> createNewFile(@NotNull String parentPath, @NotNull String fileName) {
        return this.createNewFileRunAs(parentPath, fileName, null);
    }

    @NotNull
    public ListenableFuture<Void> createNewFileRunAs(@NotNull String parentPath, @NotNull String fileName, @Nullable String runAs) {
        return this.myExecutor.executeAsync(() -> {
            if (fileName.contains("/")) {
                throw AdbShellCommandException.create("File name \"%s\" contains invalid characters", fileName);
            }
            String remotePath = AdbPathUtil.resolve(parentPath, fileName);
            String command = this.myDeviceCapabilities.supportsTestCommand() ? this.getCommand(runAs, "test -e ").withEscapedPath(remotePath).build() : this.getCommand(runAs, "ls -d -a ").withEscapedPath(remotePath).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            if (!commandResult.isError()) {
                throw AdbShellCommandException.create("File \"%s\" already exists on device", remotePath);
            }
            this.touchFileRunAs(remotePath, runAs);
            return null;
        });
    }

    @NotNull
    public ListenableFuture<Void> createNewDirectory(@NotNull String parentPath, @NotNull String directoryName) {
        return this.createNewDirectoryRunAs(parentPath, directoryName, null);
    }

    @NotNull
    public ListenableFuture<Void> createNewDirectoryRunAs(@NotNull String parentPath, @NotNull String directoryName, @Nullable String runAs) {
        return this.myExecutor.executeAsync(() -> {
            if (directoryName.contains("/")) {
                throw AdbShellCommandException.create("Directory name \"%s\" contains invalid characters", directoryName);
            }
            String remotePath = AdbPathUtil.resolve(parentPath, directoryName);
            String command = this.getCommand(runAs, "mkdir ").withEscapedPath(remotePath).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return null;
        });
    }

    public ListenableFuture<List<String>> listPackages() {
        return this.myExecutor.executeAsync(() -> {
            String command = this.getCommand(null, "pm list packages").build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return commandResult.getOutput().stream().map(AdbFileOperations::processPackageListLine).filter(x -> !StringUtil.isEmpty((String)x)).collect(Collectors.toList());
        });
    }

    @Nullable
    private static String processPackageListLine(@NotNull String line2) {
        String prefix = "package:";
        if (!line2.startsWith(prefix)) {
            return null;
        }
        return line2.substring(prefix.length());
    }

    public ListenableFuture<List<PackageInfo>> listPackageInfo() {
        return this.myExecutor.executeAsync(() -> {
            String command = this.getCommand(null, "pm list packages -f").build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return commandResult.getOutput().stream().map(AdbFileOperations::processPackageInfoLine).filter(Objects::nonNull).collect(Collectors.toList());
        });
    }

    @Nullable
    private static PackageInfo processPackageInfoLine(@NotNull String line2) {
        String prefix = "package:";
        if (!line2.startsWith(prefix)) {
            return null;
        }
        int separatorIndex = line2.indexOf(61, prefix.length());
        if (separatorIndex < 0) {
            return null;
        }
        String path2 = line2.substring(prefix.length(), separatorIndex).trim();
        if (StringUtil.isEmpty((String)path2)) {
            return null;
        }
        String packageName = line2.substring(separatorIndex + 1).trim();
        if (StringUtil.isEmpty((String)packageName)) {
            return null;
        }
        return new PackageInfo(packageName, path2);
    }

    @NotNull
    public ListenableFuture<Void> deleteFile(@NotNull String path2) {
        return this.deleteFileRunAs(path2, null);
    }

    @NotNull
    public ListenableFuture<Void> deleteFileRunAs(@NotNull String path2, @Nullable String runAs) {
        return this.myExecutor.executeAsync(() -> {
            String command = this.getRmCommand(runAs, path2, false);
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return null;
        });
    }

    @NotNull
    public ListenableFuture<Void> deleteRecursive(@NotNull String path2) {
        return this.deleteRecursiveRunAs(path2, null);
    }

    @NotNull
    public ListenableFuture<Void> deleteRecursiveRunAs(@NotNull String path2, @Nullable String runAs) {
        return this.myExecutor.executeAsync(() -> {
            String command = this.getRmCommand(runAs, path2, true);
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return null;
        });
    }

    @NotNull
    public ListenableFuture<Void> copyFile(@NotNull String source, @NotNull String destination) {
        return this.copyFileRunAs(source, destination, null);
    }

    @NotNull
    public ListenableFuture<Void> copyFileRunAs(@NotNull String source, @NotNull String destination, @Nullable String runAs) {
        return this.myExecutor.executeAsync(() -> {
            String command = this.myDeviceCapabilities.supportsCpCommand() ? this.getCommand(runAs, "cp ").withEscapedPath(source).withText(" ").withEscapedPath(destination).build() : this.getCommand(runAs, "cat ").withEscapedPath(source).withText(" >").withEscapedPath(destination).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return null;
        });
    }

    @NotNull
    public ListenableFuture<String> createTempFile(@NotNull String tempPath) {
        return this.createTempFileRunAs(tempPath, null);
    }

    @NotNull
    public ListenableFuture<String> createTempFileRunAs(@NotNull String tempDirectoy, @Nullable String runAs) {
        return this.myExecutor.executeAsync(() -> {
            String tempFileName = UniqueFileNameGenerator.getInstance().getUniqueFileName("temp", "");
            String remotePath = AdbPathUtil.resolve(tempDirectoy, tempFileName);
            this.touchFileRunAs(remotePath, runAs);
            return remotePath;
        });
    }

    @NotNull
    public ListenableFuture<Void> touchFileAsDefaultUser(@NotNull String remotePath) {
        return this.myExecutor.executeAsync(() -> {
            String command = this.myDeviceCapabilities.supportsTouchCommand() ? new AdbShellCommandBuilder().withText("touch ").withEscapedPath(remotePath).build() : new AdbShellCommandBuilder().withText("echo -n >").withEscapedPath(remotePath).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return null;
        });
    }

    private void touchFileRunAs(@NotNull String remotePath, @Nullable String runAs) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, AdbShellCommandException {
        String command = this.myDeviceCapabilities.supportsTouchCommand() ? this.getCommand(runAs, "touch ").withEscapedPath(remotePath).build() : this.getCommand(runAs, "echo -n >").withEscapedPath(remotePath).build();
        AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
        commandResult.throwIfError();
    }

    @NotNull
    private String getRmCommand(@Nullable String runAs, @NotNull String path2, boolean recursive) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        if (this.myDeviceCapabilities.supportsRmForceFlag()) {
            return this.getCommand(runAs, String.format("rm %s-f ", recursive ? "-r " : "")).withEscapedPath(path2).build();
        }
        return this.getCommand(runAs, String.format("rm %s", recursive ? "-r " : "")).withEscapedPath(path2).build();
    }

    @NotNull
    private AdbShellCommandBuilder getCommand(@Nullable String runAs, @NotNull String text2) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbShellCommandBuilder command = new AdbShellCommandBuilder();
        if (this.myDeviceCapabilities.supportsSuRootCommand()) {
            command.withSuRootPrefix();
        } else if (runAs != null) {
            command.withRunAs(runAs);
        }
        return command.withText(text2);
    }

    public static class PackageInfo {
        @NotNull
        private final String myName;
        @NotNull
        private final String myPath;

        public PackageInfo(@NotNull String name, @NotNull String path2) {
            this.myName = name;
            this.myPath = path2;
        }

        @NotNull
        public String getPackageName() {
            return this.myName;
        }

        @NotNull
        public String getPath() {
            return this.myPath;
        }

        public String toString() {
            return String.format("%s: path=%s", this.myName, this.myPath);
        }
    }
}

