/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceNamePropertiesProvider;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystem;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystemService;
import com.android.tools.idea.explorer.fs.DeviceFileSystemRenderer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public final class AdbDeviceFileSystemRenderer
implements DeviceFileSystemRenderer<AdbDeviceFileSystem> {
    @NotNull
    private final DeviceNameRenderer myDeviceNameRenderer;

    public AdbDeviceFileSystemRenderer(@NotNull AdbDeviceFileSystemService service, @NotNull DeviceNamePropertiesProvider deviceNamePropertiesProvider) {
        this.myDeviceNameRenderer = new DeviceNameRenderer(service, deviceNamePropertiesProvider);
    }

    @Override
    @NotNull
    public ListCellRenderer<AdbDeviceFileSystem> getDeviceNameListRenderer() {
        return this.myDeviceNameRenderer;
    }

    private static final class DeviceNameRenderer
    extends ColoredListCellRenderer<AdbDeviceFileSystem> {
        @NotNull
        private final AdbDeviceFileSystemService myService;
        private final DeviceNamePropertiesProvider myDeviceNamePropertiesProvider;

        private DeviceNameRenderer(@NotNull AdbDeviceFileSystemService service, @NotNull DeviceNamePropertiesProvider deviceNamePropertiesProvider) {
            this.myService = service;
            this.myDeviceNamePropertiesProvider = deviceNamePropertiesProvider;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends AdbDeviceFileSystem> list, AdbDeviceFileSystem value2, int index2, boolean selected, boolean focused) {
            if (value2 == null) {
                this.append("No Connected Devices", SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            IDevice device = value2.getDevice();
            List devices2 = ContainerUtil.map(this.myService.getDeviceList(), AdbDeviceFileSystem::getDevice);
            boolean showSerialNumbers = DeviceRenderer.shouldShowSerialNumbers(devices2, this.myDeviceNamePropertiesProvider);
            DeviceRenderer.renderDeviceName(device, this.myDeviceNamePropertiesProvider.get(device), (ColoredTextContainer)this, showSerialNumbers);
        }
    }
}

