/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceCapabilities;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceDataDirectoryEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceDefaultFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceDirectFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbFileListing;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.adbimpl.AdbFileOperations;
import com.android.tools.idea.explorer.adbimpl.AdbFileTransfer;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.DeviceState;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbDeviceFileSystem
implements DeviceFileSystem {
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final AdbDeviceCapabilities myDeviceCapabilities;
    @NotNull
    private final AdbFileListing myFileListing;
    @NotNull
    private final AdbFileOperations myFileOperations;
    @NotNull
    private final AdbFileTransfer myFileTransfer;
    @NotNull
    private final FutureCallbackExecutor myEdtExecutor;
    @NotNull
    private final FutureCallbackExecutor myTaskExecutor;

    public AdbDeviceFileSystem(@NotNull IDevice device, @NotNull Executor edtExecutor2, @NotNull Executor taskExecutor2) {
        this.myEdtExecutor = new FutureCallbackExecutor(edtExecutor2);
        this.myTaskExecutor = new FutureCallbackExecutor(taskExecutor2);
        this.myDevice = device;
        this.myDeviceCapabilities = new AdbDeviceCapabilities(this.myDevice);
        this.myFileListing = new AdbFileListing(this.myDevice, this.myDeviceCapabilities, (Executor)this.myTaskExecutor);
        this.myFileOperations = new AdbFileOperations(this.myDevice, this.myDeviceCapabilities, (Executor)this.myTaskExecutor);
        this.myFileTransfer = new AdbFileTransfer(this.myDevice, this.myFileOperations, (Executor)this.myEdtExecutor, (Executor)this.myTaskExecutor);
    }

    boolean isDevice(@Nullable IDevice device) {
        return this.myDevice.equals(device);
    }

    @NotNull
    IDevice getDevice() {
        return this.myDevice;
    }

    @NotNull
    public AdbDeviceCapabilities getCapabilities() {
        return this.myDeviceCapabilities;
    }

    @NotNull
    public AdbFileListing getAdbFileListing() {
        return this.myFileListing;
    }

    @NotNull
    public AdbFileOperations getAdbFileOperations() {
        return this.myFileOperations;
    }

    @NotNull
    public AdbFileTransfer getAdbFileTransfer() {
        return this.myFileTransfer;
    }

    @NotNull
    FutureCallbackExecutor getTaskExecutor() {
        return this.myTaskExecutor;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myDevice.getName();
    }

    @Override
    @NotNull
    public String getDeviceSerialNumber() {
        return this.myDevice.getSerialNumber();
    }

    @Override
    @NotNull
    public DeviceState getDeviceState() {
        IDevice.DeviceState state = this.myDevice.getState();
        if (state == null) {
            return DeviceState.DISCONNECTED;
        }
        switch (state) {
            case ONLINE: {
                return DeviceState.ONLINE;
            }
            case OFFLINE: {
                return DeviceState.OFFLINE;
            }
            case UNAUTHORIZED: {
                return DeviceState.UNAUTHORIZED;
            }
            case DISCONNECTED: {
                return DeviceState.DISCONNECTED;
            }
            case BOOTLOADER: {
                return DeviceState.BOOTLOADER;
            }
            case RECOVERY: {
                return DeviceState.RECOVERY;
            }
            case SIDELOAD: {
                return DeviceState.SIDELOAD;
            }
        }
        return DeviceState.DISCONNECTED;
    }

    @Override
    @NotNull
    public ListenableFuture<DeviceFileEntry> getRootDirectory() {
        return this.getTaskExecutor().transform(this.getAdbFileListing().getRoot(), entry -> {
            assert (entry != null);
            return new AdbDeviceDefaultFileEntry(this, (AdbFileListingEntry)entry, null);
        });
    }

    @Override
    @NotNull
    public ListenableFuture<DeviceFileEntry> getEntry(final @NotNull String path2) {
        final SettableFuture resultFuture = SettableFuture.create();
        ListenableFuture<DeviceFileEntry> currentDir = this.getRootDirectory();
        this.getTaskExecutor().addCallback(currentDir, (FutureCallback)new FutureCallback<DeviceFileEntry>(){

            public void onSuccess(@Nullable DeviceFileEntry result2) {
                assert (result2 != null);
                if (StringUtil.isEmpty((String)path2) || StringUtil.equals((CharSequence)path2, (CharSequence)"/")) {
                    resultFuture.set((Object)result2);
                    return;
                }
                String[] pathSegments = path2.substring(1).split("/");
                AdbDeviceFileSystem.this.resolvePathSegments((SettableFuture<DeviceFileEntry>)resultFuture, result2, pathSegments, 0);
            }

            public void onFailure(@NotNull Throwable t) {
                resultFuture.setException(t);
            }
        });
        return resultFuture;
    }

    private void resolvePathSegments(final @NotNull SettableFuture<DeviceFileEntry> future2, @NotNull DeviceFileEntry currentEntry, final @NotNull String[] segments, final int segmentIndex) {
        if (segmentIndex >= segments.length) {
            future2.set((Object)currentEntry);
            return;
        }
        ListenableFuture<List<DeviceFileEntry>> entriesFuture = currentEntry.getEntries();
        this.getTaskExecutor().addCallback(entriesFuture, (FutureCallback)new FutureCallback<List<DeviceFileEntry>>(){

            public void onSuccess(@Nullable List<DeviceFileEntry> result2) {
                assert (result2 != null);
                Optional<DeviceFileEntry> entry = result2.stream().filter(x -> x.getName().equals(segments[segmentIndex])).findFirst();
                if (!entry.isPresent()) {
                    future2.setException((Throwable)new IllegalArgumentException("Path not found"));
                } else {
                    AdbDeviceFileSystem.this.resolvePathSegments((SettableFuture<DeviceFileEntry>)future2, entry.get(), segments, segmentIndex + 1);
                }
            }

            public void onFailure(@NotNull Throwable t) {
                future2.setException(t);
            }
        });
    }

    @NotNull
    public ListenableFuture<AdbDeviceFileEntry> resolveMountPoint(@NotNull AdbDeviceFileEntry entry) {
        return this.getTaskExecutor().executeAsync(() -> {
            if (this.myDeviceCapabilities.supportsSuRootCommand() || this.myDeviceCapabilities.isRoot()) {
                return AdbDeviceFileSystem.createDirectFileEntry(entry);
            }
            if (Objects.equals(entry.getFullPath(), "/data")) {
                return new AdbDeviceDataDirectoryEntry(entry);
            }
            return AdbDeviceFileSystem.createDirectFileEntry(entry);
        });
    }

    @NotNull
    private static AdbDeviceDirectFileEntry createDirectFileEntry(@NotNull AdbDeviceFileEntry entry) {
        return new AdbDeviceDirectFileEntry(entry.myDevice, entry.myEntry, entry.myParent, null);
    }
}

