/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystem;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbDeviceDefaultFileEntry
extends AdbDeviceFileEntry {
    public AdbDeviceDefaultFileEntry(@NotNull AdbDeviceFileSystem device, @NotNull AdbFileListingEntry entry, @Nullable AdbDeviceFileEntry parent) {
        super(device, entry, parent);
    }

    @Override
    @NotNull
    public ListenableFuture<List<DeviceFileEntry>> getEntries() {
        ListenableFuture<AdbDeviceFileEntry> futureMountPoint = this.myDevice.resolveMountPoint(this);
        return this.myDevice.getTaskExecutor().transformAsync(futureMountPoint, DeviceFileEntry::getEntries);
    }

    @Override
    @NotNull
    public ListenableFuture<Void> delete() {
        ListenableFuture<AdbDeviceFileEntry> futureMountPoint = this.myDevice.resolveMountPoint(this);
        return this.myDevice.getTaskExecutor().transformAsync(futureMountPoint, DeviceFileEntry::delete);
    }

    @Override
    @NotNull
    public ListenableFuture<Void> createNewFile(@NotNull String fileName) {
        ListenableFuture<AdbDeviceFileEntry> futureMountPoint = this.myDevice.resolveMountPoint(this);
        return this.myDevice.getTaskExecutor().transformAsync(futureMountPoint, x -> {
            assert (x != null);
            return x.createNewFile(fileName);
        });
    }

    @Override
    @NotNull
    public ListenableFuture<Void> createNewDirectory(@NotNull String directoryName) {
        ListenableFuture<AdbDeviceFileEntry> futureMountPoint = this.myDevice.resolveMountPoint(this);
        return this.myDevice.getTaskExecutor().transformAsync(futureMountPoint, x -> {
            assert (x != null);
            return x.createNewDirectory(directoryName);
        });
    }

    @Override
    @NotNull
    public ListenableFuture<Boolean> isSymbolicLinkToDirectory() {
        ListenableFuture<AdbDeviceFileEntry> futureMountPoint = this.myDevice.resolveMountPoint(this);
        return this.myDevice.getTaskExecutor().transformAsync(futureMountPoint, DeviceFileEntry::isSymbolicLinkToDirectory);
    }

    @Override
    @NotNull
    public ListenableFuture<Void> downloadFile(@NotNull Path localPath, @NotNull FileTransferProgress progress) {
        ListenableFuture<AdbDeviceFileEntry> futureMountPoint = this.myDevice.resolveMountPoint(this);
        return this.myDevice.getTaskExecutor().transformAsync(futureMountPoint, x -> {
            assert (x != null);
            return x.downloadFile(localPath, progress);
        });
    }

    @Override
    @NotNull
    public ListenableFuture<Void> uploadFile(@NotNull Path localPath, @NotNull String fileName, @NotNull FileTransferProgress progress) {
        ListenableFuture<AdbDeviceFileEntry> futureMountPoint = this.myDevice.resolveMountPoint(this);
        return this.myDevice.getTaskExecutor().transformAsync(futureMountPoint, x -> {
            assert (x != null);
            return x.uploadFile(localPath, fileName, progress);
        });
    }
}

